/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;

public class NamingManager {
    public static final String CPE = "java.naming.spi.CannotProceedException";
    private static InitialContextFactoryBuilder icfb;
    static ObjectFactoryBuilder ofb;

    NamingManager() {
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return icfb != null;
    }

    public static Context getInitialContext(Hashtable environment) throws NamingException {
        InitialContextFactory icf = null;
        if (icfb != null) {
            icf = icfb.createInitialContextFactory(environment);
        } else {
            String java_naming_factory_initial = null;
            if (environment != null) {
                java_naming_factory_initial = (String)environment.get("java.naming.factory.initial");
            }
            if (java_naming_factory_initial == null) {
                java_naming_factory_initial = System.getProperty("java.naming.factory.initial");
            }
            if (java_naming_factory_initial == null) {
                throw new NoInitialContextException("Can't find property: java.naming.factory.initial");
            }
            try {
                icf = (InitialContextFactory)Class.forName(java_naming_factory_initial).newInstance();
            }
            catch (Exception exception) {
                NoInitialContextException e = new NoInitialContextException("Can't load InitialContextFactory class: " + java_naming_factory_initial);
                e.setRootCause(exception);
                throw e;
            }
        }
        return icf.getInitialContext(environment);
    }

    static Context getURLContext(Object refInfo, Name name, Context nameCtx, String scheme, Hashtable environment) throws NamingException {
        String prefixes = null;
        if (environment != null) {
            prefixes = (String)environment.get("java.naming.factory.url.pkgs");
        }
        if (prefixes == null) {
            prefixes = System.getProperty("java.naming.factory.url.pkgs");
        }
        if (prefixes == null) {
            prefixes = "com.sun.jndi.url";
        }
        scheme = scheme + "." + scheme + "URLContextFactory";
        StringTokenizer tokens = new StringTokenizer(prefixes, ":");
        while (tokens.hasMoreTokens()) {
            String aTry = tokens.nextToken();
            try {
                Class factoryClass = Class.forName(aTry + "." + scheme);
                ObjectFactory factory = (ObjectFactory)factoryClass.newInstance();
                Object obj = factory.getObjectInstance(refInfo, name, nameCtx, environment);
                Context ctx = (Context)obj;
                if (ctx == null) continue;
                return ctx;
            }
            catch (ClassNotFoundException _1) {
            }
            catch (ClassCastException _2) {
            }
            catch (InstantiationException _3) {
            }
            catch (IllegalAccessException _4) {
            }
            catch (NamingException _5) {
                throw _5;
            }
            catch (Exception _6) {
            }
        }
        return null;
    }

    public static Context getURLContext(String scheme, Hashtable environment) throws NamingException {
        return NamingManager.getURLContext(null, null, null, scheme, environment);
    }

    public static void setObjectFactoryBuilder(ObjectFactoryBuilder builder) throws NamingException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        if (ofb != null) {
            throw new IllegalStateException("builder already installed");
        }
        if (builder != null) {
            ofb = builder;
        }
    }

    static StringTokenizer getPlusPath(String property, Hashtable env, Context nameCtx) throws NamingException {
        String path = (String)env.get(property);
        if (nameCtx == null) {
            nameCtx = NamingManager.getInitialContext(env);
        }
        String path2 = (String)nameCtx.getEnvironment().get(property);
        if (path == null) {
            path = path2;
        } else if (path2 != null) {
            path = path + new StringBuffer(":").append(path2);
        }
        return new StringTokenizer(path != null ? path : "", ":");
    }

    public static Object getObjectInstance(Object refInfo, Name name, Context nameCtx, Hashtable environment) throws Exception {
        ObjectFactory factory = null;
        if (ofb != null) {
            factory = ofb.createObjectFactory(refInfo, environment);
        } else {
            Class k;
            Object ref2 = refInfo;
            if (refInfo instanceof Referenceable) {
                ref2 = ((Referenceable)refInfo).getReference();
            }
            if (ref2 instanceof Reference) {
                Reference ref = (Reference)ref2;
                String fClass = ref.getFactoryClassName();
                if (fClass != null) {
                    k = Class.forName(fClass);
                    factory = (ObjectFactory)k.newInstance();
                } else {
                    Enumeration e = ref.getAll();
                    while (e.hasMoreElements()) {
                        Object obj;
                        RefAddr ra = (RefAddr)e.nextElement();
                        if (!(ra instanceof StringRefAddr) || !"URL".equals(ra.getType()) || (obj = (factory = (ObjectFactory)((Object)NamingManager.getURLContext(refInfo, name, nameCtx, (String)ra.getContent(), environment))).getObjectInstance(refInfo, name, nameCtx, environment)) == null) continue;
                        return obj;
                    }
                    factory = null;
                }
            }
            if (factory == null) {
                StringTokenizer tokens = NamingManager.getPlusPath("java.naming.factory.object", environment, nameCtx);
                while (tokens.hasMoreTokens()) {
                    String klassName = tokens.nextToken();
                    k = Class.forName(klassName);
                    factory = (ObjectFactory)k.newInstance();
                    Object obj = factory.getObjectInstance(refInfo, name, nameCtx, environment);
                    if (obj == null) continue;
                    return obj;
                }
                return refInfo;
            }
        }
        if (factory == null) {
            return refInfo;
        }
        Object obj = factory.getObjectInstance(refInfo, name, nameCtx, environment);
        if (obj == null) {
            return refInfo;
        }
        return obj;
    }

    public static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder builder) throws NamingException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        if (icfb != null) {
            throw new IllegalStateException("builder already installed");
        }
        if (builder != null) {
            icfb = builder;
        }
    }

    public static Context getContinuationContext(CannotProceedException cpe) throws NamingException {
        Hashtable env = cpe.getEnvironment();
        if (env != null) {
            env.put(CPE, cpe);
        }
        try {
            Object obj = NamingManager.getObjectInstance(null, cpe.getAltName(), cpe.getAltNameCtx(), env);
            if (obj != null) {
                return (Context)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw cpe;
    }

    public static Object getStateToBind(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        StringTokenizer tokens = NamingManager.getPlusPath("java.naming.factory.state", environment, nameCtx);
        while (tokens.hasMoreTokens()) {
            String klassName = tokens.nextToken();
            try {
                Class k = Class.forName(klassName);
                StateFactory factory = (StateFactory)k.newInstance();
                Object o = factory.getStateToBind(obj, name, nameCtx, environment);
                if (o == null) continue;
                return o;
            }
            catch (ClassNotFoundException _1) {
            }
            catch (ClassCastException _2) {
            }
            catch (InstantiationException _3) {
            }
            catch (IllegalAccessException _4) {
            }
        }
        return obj;
    }

    static {
        CPE = CPE;
        icfb = null;
        ofb = null;
    }
}

