#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/nail.rc.new
# Make symlinks:
( cd usr/man/man1 ; rm -rf mail.1.gz )
( cd usr/man/man1 ; ln -sf nail.1.gz mail.1.gz )
( cd usr/man/man1 ; rm -rf mailx.1.gz )
( cd usr/man/man1 ; ln -sf nail.1.gz mailx.1.gz )
( cd usr/man/man1 ; rm -rf Mail.1.gz )
( cd usr/man/man1 ; ln -sf nail.1.gz Mail.1.gz )
( cd usr/bin ; rm -rf Mail )
( cd usr/bin ; ln -sf nail Mail )
( cd usr/bin ; rm -rf mail )
( cd usr/bin ; ln -sf nail mail )
( cd usr/bin ; rm -rf mailx )
( cd usr/bin ; ln -sf nail mailx )
( cd bin ; rm -rf Mail )
( cd bin ; ln -sf /usr/bin/nail Mail )
( cd bin ; rm -rf mail )
( cd bin ; ln -sf /usr/bin/nail mail )
