
/*
* Name: CommandUpdate_App
* Arguments: none. 
* Description:
* This function is called by the command update handler. Based on the events you specify this get called.
* Right now it is used only by delete.
* Return Value: none
* Author: Suresh Kasinathan<suresh@netscape.com> 8/29/01
*/

function CommandUpdate_App()
{
  goUpdateCommand("cmd_delete");
  goUpdateCommand("cmd_buddyalert");
  goUpdateCommand("cmd_editbuddyalert");
  goUpdateCommand("cmd_delbuddyalert");
}


var AppController =
{
  
  supportsCommand: function(command)
  {
    switch (command) {
      case "cmd_delete":
        return true;
        break;
      case "cmd_buddyalert":  
        if (SetMenuBuddyAlert() == false) {
          var result= getSelectedScreenName();
          var Msg1=top.document.getElementById("cmd_buddyalert").getAttribute("buddyAlertMsg1");
          var Msg2=top.document.getElementById("cmd_buddyalert").getAttribute("buddyAlertMsg2");
          var newlabel=Msg1+result+Msg2;
          top.document.getElementById("menu_buddyAlert").removeAttribute("hidden");
          top.document.getElementById("menu_buddyAlert").setAttribute("label", newlabel);
          goSetAccessKey("cmd_buddyalert", 'buddyAlertAccessKey');
          top.document.getElementById("menu_editAlert").removeAttribute("label");
          top.document.getElementById("menu_delAlert").removeAttribute("label");
          top.document.getElementById("menu_editAlert").setAttribute("hidden", true);
          top.document.getElementById("menu_delAlert").setAttribute("hidden", true);
          return true;
          }
          else 
            return false;
          break;
      case "cmd_editbuddyalert":
          if (SetMenuBuddyAlert() == true) {
             top.document.getElementById("cmd_buddyalert").removeAttribute("label");
             top.document.getElementById("cmd_buddyalert").setAttribute("hidden",true);
             top.document.getElementById("cmd_editbuddyalert").removeAttribute("hidden");
             goSetMenuValue("menu_editAlert", "editbuddyAlert");                 
             goSetAccessKey("cmd_editbuddyalert", "editbuddyAlertAccessKey");
             return true;
          }
          else 
            return false;
        break;
      case "cmd_delbuddyalert":
          if (SetMenuBuddyAlert() == true) {
            var result= getSelectedScreenName();
            var Msg1=top.document.getElementById("cmd_delbuddyalert").getAttribute("delbuddyAlertMsg1");
            var Msg2=top.document.getElementById("cmd_delbuddyalert").getAttribute("delbuddyAlertMsg2");
            var newlabel=Msg1+result+Msg2;
            top.document.getElementById("menu_delAlert").removeAttribute("hidden");
            top.document.getElementById("menu_delAlert").setAttribute("label", newlabel);
            goSetAccessKey("cmd_delbuddyalert", "delbuddyAlertAccessKey");
            return true;
          }
          else 
            return false;
         break;
      case "cmd_sendFile":
        var screenName = getSelectedScreenName();
        if (aimBuddyIsOnline(screenName)) {
            top.document.getElementById("menu_sendFile").removeAttribute("hidden");
            top.document.getElementById("menu_sendFileSep").removeAttribute("hidden");
        }
        else
        {
            top.document.getElementById("menu_sendFile").setAttribute("hidden", true);
            top.document.getElementById("menu_sendFileSep").setAttribute("hidden", true);
        }
      default:
        return true;
    }
  },

  isCommandEnabled: function(command)
  {
    switch (command) {
      case "cmd_delete":
        return true;
        break;
      case "cmd_buddyalert":
        return true;
        break;
      case "cmd_delbuddyalert":
        return true;
        break;
      case "cmd_editbuddyalert":
        return true;
        break;
      default:
        return true;
    }
  },

  doCommand: function(command)
  {
    switch (command) {
      case "cmd_delete":
        cmdDelete();
        break;
      case "cmd_buddyalert":
        cmdBuddyAlert();
        break;
      case "cmd_editbuddyalert":
        cmdBuddyAlert();
        break;
    }
  },

  onEvent: function(event)
  {
     dump("Nothing for now ...\n");
  }
};

/*
* Name: SetupCommandUpdateHandlers
* Arguments: none. 
* Description:
* This function initializes command update handler. This is called by AppSessionObserver.
* Return Value: none
* Author: Suresh Kasinathan<suresh@netscape.com> 8/29/01
*/

function AimSetupCommandUpdateHandlers()
{
  var sidebarframe=getsidebarframe();
  var onlineTree;
  var listsetupTree;
  if (sidebarframe) {
    onlineTree = sidebarframe.document.getElementById("OnlineBuddies");
    listsetupTree = sidebarframe.document.getElementById("ListSetup");
  }
  else {
    onlineTree = document.getElementById("OnlineBuddies");
    listsetupTree = document.getElementById("ListSetup");
  }
  
  if (onlineTree) {
    onlineTree.controllers.appendController(AppController);
  }

  if (listsetupTree) {
    listsetupTree.controllers.appendController(AppController);
  }
}

/*
* Name: onSelectionChange
* Arguments: none. 
* Description:
* This function is called whenever the selection changes in Online tree and list setup tree. 
* Return Value: none
* Author: Suresh Kasinathan<suresh@netscape.com> 8/29/01
*/

function onSelectionChange(event) {
  goUpdateCommand("cmd_delete");
  goUpdateCommand("cmd_sendFile");
  onItemFocus(event);
}

function onItemFocus(event) {
  goUpdateCommand("cmd_buddyalert");
  goUpdateCommand("cmd_editbuddyalert");
  goUpdateCommand("cmd_delbuddyalert");
  goUpdateCommand("cmd_sendFile");
}


/*
* Name: SetMenuBuddyAlert
* Arguments: none. 
* Description:
* This function is called to check if the selected screen name is in alert list and show the appropriate alert 
* menu. Do not show menu is a specific screen name was not selected.
* Return Value: screenName
* Author: Prassanna<prass@netscape.com> 
*/

function SetMenuBuddyAlert() {
      var scrName = getSelectedScreenName();
      if (!scrName  || scrName == null) {
        //remove the buddy alert menu item from people Menu if no screen name was selected
        top.document.getElementById("menu_buddyAlert").removeAttribute("label");
        top.document.getElementById("menu_buddyAlert").setAttribute("hidden", true);
        // Do not set buddy alert menu item (mutiple select or screen name was null);
        return false;
      }
      var isInList = new Object();
      aimBuddyManager().IsBuddyInAlertList(scrName, isInList);
      return isInList.value;
}


