var migrationScreenName = "";
var migrationPassword = "";
var migrationSource = "";
var migrationScreenNameVec = "";
var migrationScreenNameVecSize = 0;
var selectedRadioItem;

// Navigation Set for pages contained in wizard
var wizardMap =
{
  migWiz0_0_0: { previous: null,                       next: "migWiz1_0_0", finish: false },
  migWiz1_0_0: { previous: "migWiz0_0_0",              next: null,    finish: true },
  migWiz2_0_0: { previous: "migWiz0_0_0",              next: null,    finish: true },
  migWiz2_1_0: { previous: "migWiz3_0_0",              next: null,    finish: true },
  migWiz3_0_0: { previous: "migWiz0_0_0",              next: "migWiz2_1_0", finish: false },
  migWiz4_0_0: { previous: "migWiz0_0_0",              next: null,    finish: true },
}

// page specific variables
var profName      = "";
var profDir       = "";
var wizardManager = null;

// startup procedure
function Startup( startPage, frame_id )
{
  if(frame_id == "")
    return false;
  
  // instantiate the Wizard Manager
  wizardManager                   = new WizardManager( frame_id, null, null, wizardMap );
  wizardManager.URL_PagePrefix    = "chrome://aim/content/";
  wizardManager.URL_PagePostfix   = ".xul";

  // set the button handler functions
  wizardManager.SetHandlers( null, null, onFinish, onCancel, null, null );

  // load the start page
  wizardManager.LoadPage(startPage, false);

  // move to center of screen if no opener, otherwise, to center of opener
  if( window.opener )
    moveToAlertPosition();
  else
    centerWindowOnScreen();
}

/*
 * Function: setSelectedRadioItem()
 *
 * Arguments: defaultRadioItem
 * 
 * Return: None
 *
 * Description: Determines if the user has previously selected a radio button in this instance of the wizard, and sets
 *              that button to be checked when stepping back to the first panel.  If not takes the defaultRadioItem
 *              and sets that to be checked.
 */

function setSelectedRadioItem(defaultRadioItem)
{
  var item;
  var iframe = document.getElementById('content').docShell.contentViewer.DOMDocument;
  var radiogroup = iframe.getElementById("migwiz000radiogroup1");

  if (selectedRadioItem)
    item = iframe.getElementById(selectedRadioItem);
  else
    item = iframe.getElementById(defaultRadioItem);

  radiogroup.selectedItem = item;
}


/*
 * Function: onCancel()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Run when the user cancels out of the wizard using the cancel button.
 */

function onCancel()
{
  if( top.window.opener )
    window.close();
  else
  { 
    try 
    {
      profile.forgetCurrentProfile();
    }
    catch (ex)
    {
      dump("failed to forget current profile.\n");
    }
    ExitApp();
  }
}


/*
 * Function: onFinish()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Run when the user finishes the wizard.  Takes the Screenname/Password the user chose, and sets the prefs
 *              to remember it, and also prefills the sign on panel.
 */

function onFinish()
{
  var iframe = document.getElementById('content').docShell.contentViewer.DOMDocument;
  var curPage = wizardManager.currentPageTag;
  var sname = "";
  var pword = "";
  if (curPage != "migWiz1_0_0")
  {
    pword = iframe.getElementById("inputpassword").value;
    if (curPage == "migWiz4_0_0")
      sname = iframe.getElementById("inputscreenname").label;
    else
      sname = iframe.getElementById("inputscreenname").value;
  }
  else
    sname = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);  
  
  cmdRegisterRemoteScreenNameWiz(curPage,sname,pword);
  aimPrefsManager().SetBoolPref("aim.session.finishedwizard",true, null, true);
  var checkbox = top.frames[0].document.getElementById("migrateScreenNameCheck");
  if ( checkbox && checkbox.checked == false )
    aimPrefsManager().SetCharPref("aim.session.migrateBuddyList",sname, null, true);
    
  window.close();
}

function ExitApp()
{
  // Need to call this to stop the event loop
  var appShell = Components.classes['@mozilla.org/appshell/appShellService;1'].getService();
  appShell = appShell.QueryInterface( Components.interfaces.nsIAppShellService);
  appShell.Quit();
}

//set up login screen
function cmdRegisterRemoteScreenNameWiz(panelName,sn,pw)
{
  aimPrefsManager().SetCharPref("aim.session.screenname", sn, null, true);
  
  if(pw != "")
  {
    aimSessionSavePassword(pw);
    aimPrefsManager().SetBoolPref("aim.session.storepassword", true, null, false);
  }

  aimPrefsManager().SetBoolPref("aim.session.autologin", false, null, false);

  wizard_AimSession_Register(sn);
  
  top.close();
}

function wizard_AimSession_Register(screenName)
{
  if(aimSession())
    aimSession().RegisterScreenName(screenName);
}
