// globals
// window arguments defined here, but may not be used.
// mainly to test & explain valid arguments.

inviteArgsObj = window.arguments[0];

var inviteMode                = inviteArgsObj.inviteMode;
var fileProposalScreenName    = inviteArgsObj.inviteProposalScreenName;
var fileXferSession           = inviteArgsObj.fileXferSession;
var filepath                  = inviteArgsObj.filepath;

var fileXferSessionCallback = new Object();
var remoteError = false;

fileXferSessionCallback.OnStateChange = function (state, msg)
{
	var stateEnum = Components.interfaces.nsAimFileXferStates;
	if (stateEnum.Complete == state)
	{
	    window.close();
	}
	if (stateEnum.Progress == state)
	{
	    if (document.getElementById("imfileprogress").getAttribute("mode") !="determined"){
	    	document.getElementById("imfileprogress").setAttribute("mode", "determined");
	    }
	    document.getElementById("filestate").setAttribute("value", fileXferSession.GetTotalBytes() + " / " + fileXferSession.GetTotalSize() * 100);
		document.getElementById("imfileprogress").setAttribute("value", fileXferSession.GetTotalBytes() / fileXferSession.GetTotalSize() * 100);
	}
        if (stateEnum.Error == state)
        {
                alert(msg);
                remoteError = true;
                window.close();
        }
}

function transferOnWinLoad(){
  fileXferSession.SetFileXferSessionCallback(fileXferSessionCallback);
  dump ("Loaded transfer window\n");
  if(inviteMode && inviteMode=="incomingfile"){
    document.getElementById("IncomingFileTransfer").setAttribute("title", aimString("file.incomingtitle"));
    dump ("Receiving file\n");
    try {
      fileXferSession.AcceptSend(filepath);
    } catch (e) {
      aimErrorBox(aimString('file.error.error') + " " + aimString('file.pickdirectory'));
      window.close();
    }
  }
  if(inviteMode && inviteMode=="outgoingfile"){
    document.getElementById("IncomingFileTransfer").setAttribute("title", aimString("file.outgoingtitle").replace(/%ScreenName%/, fileProposalScreenName));
    fileXferSession.SetScreenName(fileProposalScreenName);
    fileXferSession.SetInviteMode(1);
    dump ("Sending file\n");
  }
}

function transferOnWinUnLoad(){
  if(remoteError != true)
  {
    try {
      fileXferSession.Cancel();
    } catch (e){}
  }
  window.close();
}
