var gSidebarNeverShown = true; // ... in this window
var gPrefs = null; // cached nsIPrefBranch reference

addEventListener("load", initSidebarButton, false);

function initSidebarButton()
{
  const kSidebarButtonPref = "browser.toolbars.showbutton.sidebar";
  var buttonShown;
  try {
    buttonShown = getPrefs().getBoolPref(kSidebarButtonPref);
    var pbi = getPrefs().QueryInterface(
              Components.interfaces.nsIPrefBranchInternal);
    pbi.addObserver(kSidebarButtonPref, sidebarButtonPrefObserver, false);
  }
  catch (ex)
  {
    buttonShown = true;
  }

  // hide/unhide sidebar button on personal toolbar for ns builds
  var sbheader = document.getElementById("sidebar-title-box");
  sbheader.setAttribute("prefixhidden", !buttonShown);
  var pt = document.getElementById("PersonalToolbar");
  pt.setAttribute("prefixhidden", !buttonShown);
dump("prefixhidden: " + !buttonShown + "\n");
  // init to open/closed
  var open = false;
  if (!sidebar_is_collapsed() && !sidebar_is_hidden())
    open = true;
  
  // set sidebar button state
  SidebarSetButtonOpen(open);
}

function onSidebarButtonClick()
{
  var was_hidden = sidebar_is_hidden();
  var was_collapsed = sidebar_is_collapsed();

  // are we in closed or collapsed state?
  if (was_collapsed)
  {
    // open/expand sidebar
    SidebarExpandCollapse();
    if (gSidebarNeverShown)
      SidebarCleanUpExpandCollapse();

    gSidebarNeverShown = false;
  }
  else if (was_hidden)
  {
    // open/unhide sidebar
    SidebarShowHide();

    gSidebarNeverShown = false;
  }

  // or are we open?
  else
  {
    // close sidebar
    SidebarShowHide(); 
  }
}

function getPrefs()
{
  try
  {
    if (!gPrefs)
      gPrefs = Components.classes["@mozilla.org/preferences-service;1"].
                 getService(Components.interfaces.nsIPrefBranch);
  }
  catch (ex)
  {
    gPrefs = null;
  }
  
  return gPrefs;
}

var sidebarButtonPrefObserver = 
{
  observe: function(aPrefs, aTopic, aPrefName)
  {
    var buttonShown = aPrefs.getBoolPref(aPrefName);

    var sbheader = document.getElementById("sidebar-title-box");
    sbheader.setAttribute("prefixhidden", !buttonShown);
    var pt = document.getElementById("PersonalToolbar");
    pt.setAttribute("prefixhidden", !buttonShown);
  }
}
