/*
 * tools/tools.h
 *
 * Copyright (C) 2002  Heinz Mauelshagen, Sistina Software
 *
 * March 2002
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    21/03/2002 - first drop
 *
 */

#ifndef _TOOLS_H_INCLUDE
#define _TOOLS_H_INCLUDE

#define	MAX_ARGS	64

#define	x(t)	extern int t ( int, char **);
x(e2fsadm)
x(lvchange)
x(lvcreate)
x(lvdisplay)
x(lvextend)
x(lvmchange)
x(lvmdiskscan)
x(lvmsadc)
x(lvmsar)
x(lvreduce)
x(lvremove)
x(lvrename)
x(lvscan)
x(pvchange)
x(pvcreate)
x(pvdata)
x(pvdisplay)
x(pvmove)
x(pvresize)
x(pvscan)
x(vgcfgbackup)
x(vgcfgrestore)
x(vgchange)
x(vgck)
x(vgcreate)
x(vgdisplay)
x(vgexport)
x(vgextend)
x(vgimport)
x(vgmerge)
x(vgmknodes)
x(vgreduce)
x(vgremove)
x(vgrename)
x(vgscan)
x(vgsplit)
#undef	x

typedef int (*func_t) (int argc, char **argv);

typedef	struct {
	char *name;
	func_t func;
} command_t;

#define	x(t)	{ #t, t },
command_t cmds[] = {
   x(e2fsadm)
   x(lvchange)
   x(lvcreate)
   x(lvdisplay)
   x(lvextend)
   x(lvmchange)
   x(lvmdiskscan)
   x(lvmsadc)
   x(lvmsar)
   x(lvreduce)
   x(lvremove)
   x(lvrename)
   x(lvscan)
   x(pvchange)
   x(pvcreate)
   x(pvdata)
   x(pvdisplay)
   x(pvmove)
   x(pvresize)
   x(pvscan)
   x(vgcfgbackup)
   x(vgcfgrestore)
   x(vgchange)
   x(vgck)
   x(vgcreate)
   x(vgdisplay)
   x(vgexport)
   x(vgextend)
   x(vgimport)
   x(vgmerge)
   x(vgmknodes)
   x(vgreduce)
   x(vgremove)
   x(vgrename)
   x(vgscan)
   x(vgsplit)
   { NULL, NULL }
};
#undef	x

#endif
