/* libwpd2
 * Copyright (C) 2002 William Lachance (william.lachance@sympatico.ca)
 * Copyright (C) 2002 Marc Maurer (j.m.maurer@student.utwente.nl)
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef WP6OUTLINESTYLEPACKET_H
#define WP6OUTLINESTYLEPACKET_H
#include "WP6PrefixDataPacket.h"
#include "WP6FileStructure.h"
#include "WP6LLListener.h"

class WP6OutlineStylePacket : public WP6PrefixDataPacket
{
 public:
	WP6OutlineStylePacket(GsfInput *input, int id, guint32 dataOffset, guint32 dataSize);
	virtual ~WP6OutlineStylePacket();
	virtual void _readContents(GsfInput *input);
	virtual void parse(WP6LLListener *llListener) const;

 private:              
      guint16 m_numPIDs;
      guint16 m_paragraphStylePIDs[WP6_NUM_LIST_LEVELS]; // seemingly useless
      guint16 m_nonDeletableInfoSize;
      guint16 m_outlineHash;
      guint8 m_numberingMethods[WP6_NUM_LIST_LEVELS];
      guint8 m_outlineFlags;
      guint8 m_tabBehaviourFlag;

};
#endif /* WP6OUTLINESTYLEPACKET_H */
