/* Copyright (C) 2002 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	 Boston, MA 02111-1307, USA.
	 */

/**
 * Taken from Vim's source code originally written by 
 * Flemming Madsen 
 */

#ifndef XVIM_H
#define XVIM_H

#include <stdio.h>
#include <string.h>
#ifdef HAVE_SELECT
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#else
#include <sys/poll.h>
#endif
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
//conflict with Qt
#undef Bool

#define MAX_PROP_WORDS 100000
#define SEND_MSEC_POLL 50
#define STATIC_SPACE 500

class XVim {
	public:
		XVim();
		~XVim();

		char * sendToVim (Display *dpy,const char *name, const char *cmd, int asKeys, int *code);
		int	AppendPropCarefully (Display *display, Window window, Atom property, char *value, int length);
		Window	LookupName (Display *dpy, const char *name, int del, char **loose);
		int	SendInit (Display *dpy);
	 	char	*SendEventProc (Display *dpy, XEvent *eventPtr, int expect, int *code);
		int	IsSerialName (const char *name);

	private:
		Atom	registryProperty;
		Atom	commProperty;
		Window	commWindow;
};
#endif
