/***************************************************************************
                            kde_KCompletionBox.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCOMPLETIONBOX
#define KDE_KCOMPLETIONBOX

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A little utility class for "completion-widgets", like @ref KLineEdit or
 @ref KComboBox. KCompletionBox is a listbox, displayed as a rectangle without
 any window decoration, usually directly under the lineedit or combobox.
 It is filled with all possible matches for a completion, so the user
 can select the one he wants.

 It is used when KGlobalSettings::Completion == CompletionPopup or CompletionPopupAuto.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A helper widget for "completion-widgets" (KLineEdit, KComboBox)).
*/

/** *
 Constructs a KCompletionBox.

 Notice: the parent needs to be always 0L,
 so you can't specify it in the constructor. Because of that, Qt's
 auto-deletion does not take place, so you have to explicitly delete
 this widget when you don't need it anymore.

 The parent widget is used to give the focus back when pressing the
 up-button on the very first item.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KCompletionBox * kde_new_KCompletionBox(qt_QWidget * parent, char* name);

/** *
 Destroys the box
     
*/
void kde_del_KCompletionBox( kde_KCompletionBox* p );
qt_QSize * kde_KCompletionBox_sizeHint(kde_KCompletionBox* instPointer);

/** *
 Returns a list of all items currently in the box.
     
*/
qt_QStringList* kde_KCompletionBox_items(kde_KCompletionBox* instPointer);

/** *
 Inserts @p items into the box. Does not clear the items before.
 @p index determines at which position @p items will be inserted.
 (defaults to appending them at the end)
     
*/
void kde_KCompletionBox_insertItems(kde_KCompletionBox* instPointer,qt_QStringList* items, int index);

/** *
 Clears the box and inserts @p items.
     
*/
void kde_KCompletionBox_setItems(kde_KCompletionBox* instPointer,qt_QStringList* items);

/** *
 Adjusts the size of the box to fit the width of the parent given in the
 constructor and pops it up at the most appropriate place, relative to
 the parent.

 Depending on the screensize and the position of the parent, this may
 be a different place, however the default is to pop it up and the
 lower left corner of the parent.

 Make sure to hide() the box when appropriate.
     
*/
void kde_KCompletionBox_popup(kde_KCompletionBox* instPointer);

/** *
 Makes this widget (when visible) capture Tab-key events to traverse the
 items in the dropdown list.

 Default off, as it conflicts with the usual behavior of Tab to traverse
 widgets. It is useful for cases like Konqueror's Location Bar, though.

*/
void kde_KCompletionBox_setTabHandling(kde_KCompletionBox* instPointer,int enable);

/** *

 Default is false.

*/
int kde_KCompletionBox_isTabHandling(kde_KCompletionBox* instPointer);

/** *
 Sets the text to be emitted if the user chooses not to
 pick from the available matches.

 If the cancelled text is not set through this function, the
 @ref userCancelled signal will not be emitted.

*/
void kde_KCompletionBox_setCancelledText(kde_KCompletionBox* instPointer,qt_QString * arg1);

/** *

*/
qt_QString * kde_KCompletionBox_cancelledText(kde_KCompletionBox* instPointer);

/** *
 Moves the selection one line down or select the first item if nothing is selected yet.
     
*/
void kde_KCompletionBox_down(kde_KCompletionBox* instPointer);

/** *
 Moves the selection one line up or select the first item if nothing is selected yet.
     
*/
void kde_KCompletionBox_up(kde_KCompletionBox* instPointer);

/** *
 Moves the selection one page down.
     
*/
void kde_KCompletionBox_pageDown(kde_KCompletionBox* instPointer);

/** *
 Moves the selection one page up.
     
*/
void kde_KCompletionBox_pageUp(kde_KCompletionBox* instPointer);

/** *
 Moves the selection up to the first item.
     
*/
void kde_KCompletionBox_home(kde_KCompletionBox* instPointer);

/** *
 Moves the selection down to the last item.
     
*/
void kde_KCompletionBox_end(kde_KCompletionBox* instPointer);

/** *
 Re-implemented for internal reasons.  API is unaffected.
     
*/
void kde_KCompletionBox_show(kde_KCompletionBox* instPointer);

/** *
 Re-implemented for internal reasons.  API is unaffected.
     
*/
void kde_KCompletionBox_hide(kde_KCompletionBox* instPointer);

/** *
 Reimplemented from KListBox to get events from the viewport (to hide
 this widget on mouse-click, Escape-presses, etc.
     
*/
int kde_KCompletionBox_eventFilter(kde_KCompletionBox* instPointer,qt_QObject * arg1, qt_QEvent * arg2);
void kde_KCompletionBox_virtual_hook(kde_KCompletionBox* instPointer,int identifier, void* data);

/** *
 Called when an item was activated. Emits
 @ref activated() with the item.
     
*/
void kde_KCompletionBox_slotActivated(kde_KCompletionBox* instPointer,qt_QListBoxItem * arg1);

#ifdef __cplusplus
}
#endif
#endif
