/***************************************************************************
                            kde_KIconEffect.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KICONEFFECT
#define KDE_KICONEFFECT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Applies effects to icons.

 This class applies effects to icons depending on their state and
 group. For example, it can be used to make all disabled icons
 in a toolbar grey.

 @short *
 Applies effects to icons.
*/
#define KICONEFFECT_NoEffect	0
#define KICONEFFECT_ToGray	1
#define KICONEFFECT_Colorize	2
#define KICONEFFECT_ToGamma	3
#define KICONEFFECT_DeSaturate	4
#define KICONEFFECT_LastEffect	5

/** *
 Create a new KIconEffect.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KIconEffect * kde_new_KIconEffect();
void kde_del_KIconEffect( kde_KIconEffect* p );

/** *
 Rereads configuration.
     
*/
void kde_KIconEffect_init(kde_KIconEffect* instPointer);

/** * 
 Tests whether an effect has been configured for the given icon group.

*/
int kde_KIconEffect_hasEffect(kde_KIconEffect* instPointer,int group, int state);

/** *
 Returns a fingerprint for the effect by encoding
 the given @p group and @p state into a QString. This 
 is useful for caching.

*/
qt_QString * kde_KIconEffect_fingerprint(kde_KIconEffect* instPointer,int group, int state);

/** *
 Applies an effect to an image. The effect to apply depends on the
 @p group and @p state parameters, and is configured by the user.

*/
qt_QImage * kde_KIconEffect_apply(kde_KIconEffect* instPointer,qt_QImage * src, int group, int state);

/** *
 Applies an effect to an image.

*/
qt_QImage * kde_KIconEffect_apply1(kde_KIconEffect* instPointer,qt_QImage * src, int effect, float value, qt_QColor * rgb, int trans);

/** *
 Applies an effect to a pixmap.

*/
qt_QPixmap * kde_KIconEffect_apply2(kde_KIconEffect* instPointer,qt_QPixmap * src, int group, int state);

/** *
 Applies an effect to a pixmap.

*/
qt_QPixmap * kde_KIconEffect_apply3(kde_KIconEffect* instPointer,qt_QPixmap * src, int effect, float value, qt_QColor * rgb, int trans);

/** *
 Returns an image twice as large, consisting of 2x2 pixels.

*/
qt_QImage * kde_KIconEffect_doublePixels(kde_KIconEffect* instPointer,qt_QImage * src);

/** *
 Provides visual feedback to show activation of an icon on a widget.

 Not strictly an 'icon effect', but in practice that's what it looks
 like.

 This method does nothing if the global 'Visual feedback on activation'
 option is not activated (See kcontrol/Peripherals/Mouse).

*/
void kde_KIconEffect_visualActivate( qt_QWidget * widget, qt_QRect* rect);

/** *
 Tints an image gray.

*/
void kde_KIconEffect_toGray( qt_QImage * image, float value);

/** *
 Colorizes an image with a specific color.

*/
void kde_KIconEffect_colorize( qt_QImage * image, qt_QColor * col, float value);

/** *
 Desaturates an image.

*/
void kde_KIconEffect_deSaturate( qt_QImage * image, float value);

/** *
 Changes the gamma value of an image.

*/
void kde_KIconEffect_toGamma( qt_QImage * image, float value);

/** *
 Renders an image semi-transparent.

*/
void kde_KIconEffect_semiTransparent( qt_QImage * image);

/** *
 Renders a pixmap semi-transparent.

*/
void kde_KIconEffect_semiTransparent1( qt_QPixmap * pixmap);

/** *
 Overlays an image with an other image.

*/
void kde_KIconEffect_overlay( qt_QImage * src, qt_QImage * overlay);

#ifdef __cplusplus
}
#endif
#endif
