/***************************************************************************
                            kde_NoteArray.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_NOTEARRAY
#define KDE_NOTEARRAY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Holds a resizeable array of note on/off and patch change events. It can
 increase it size, but it doesn't decreases (until destruction :-) )

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Stores an array of note on/off events.
*/

/** *
 Constructor. Initializes internal variables.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_NoteArray * kde_new_NoteArray();

/** *
 Destructor.
   
*/
void kde_del_NoteArray( kde_NoteArray* p );

/** *
 Adds (or modifies) an event in the given position . 

 Note that this has nothing to do with what is being played, this just
 modifies an internal array.
   
*/
void kde_NoteArray_at(kde_NoteArray* instPointer,unsigned long pos, unsigned long ms, int chn, int cmd, int note);

/** *
 A convenience function, which differs from the above in the parameters
 it accepts.
   
*/

/** *
 Returns the note event at a given position.
   
*/

/** *
 Adds a note/patch event at a given millisecond.

 Note: This method always appends at the end of the list.
   
*/
void kde_NoteArray_add(kde_NoteArray* instPointer,unsigned long ms, int chn, int cmd, int note);

/** *
 Initializes the iterator.

*/
void kde_NoteArray_iteratorBegin(kde_NoteArray* instPointer);

/** *
 Get the command currently pointed to by the iterator.
   
*/

/** *
 Advances the iterator to the next position.
   
*/
void kde_NoteArray_next(kde_NoteArray* instPointer);

/** *
 Calls @ref #next() until the next event is over ms milliseconds
 and puts in @p pgm[16] the instruments used at this moment.
   
*/
void kde_NoteArray_moveIteratorTo(kde_NoteArray* instPointer,unsigned long ms, int* pgm);

#ifdef __cplusplus
}
#endif
#endif
