/***************************************************************************
                            KHTMLView.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KHTMLVIEW_H
#define KHTMLVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QScrollView.h>

/**

 Renders and displays HTML in a @ref QScrollView.

 Suitable for use as an application's main view.

 @short 
 Renders and displays HTML in a @ref QScrollView.
*/
@class KHTMLPart; 

@interface KHTMLView : QScrollView 

/** 
 Constructs a KHTMLView.
     
*/
- initWithHTMLPart: (KHTMLPart*)part parent: (QWidget *)parent name: (NSString *)name;
- initWithHTMLPart: (KHTMLPart*)part parent: (QWidget *)parent ;
- (void) dealloc;

/** 
 Returns a pointer to the KHTMLPart that is
 rendering the page.

*/
- (KHTMLPart*) part;
- (int) frameWidth;

/** 
 Sets a margin in x direction.
     
*/
- setMarginWidth: (int)x;

/** 
 Returns the margin width.

 A return value of -1 means the default value will be used.
     
*/
- (int) marginWidth;
- setMarginHeight: (int)y;

/** 
 Returns the margin height.

 A return value of -1 means the default value will be used.
     
*/
- (int) marginHeight;

/** 
 Sets verticals scrollbar mode. Reimplemented for internal reasons.
     
*/
- setVScrollBarMode: (int)mode;

/** 
 Sets horizontal scrollbar mode. Reimplemented for internal reasons.
     
*/
- setHScrollBarMode: (int)mode;

/** 
 Overrides the scrollbar mode.
     
*/
//- forceHScrollBarMode: (int)mode;

/** 
 Overrides the scrollbar mode.
     
*/
//- forceVScrollBarMode: (int)mode;

/** 
 Prints the HTML document.
     
*/
- print;

/** 
 ensure the display is up to date
     
*/
- layout;
- clear;
- (BOOL) focusNextPrevChild: (BOOL)next;
- drawContents: (QPainter *)p clipx: (int)clipx clipy: (int)clipy clipw: (int)clipw cliph: (int)cliph;
- drawContents: (QPainter *)arg1;
- doAutoScroll;
- slotPaletteChanged;
- slotScrollBarMoved;
@end

/** Override these methods in subclasses of KHTMLView to customise event handling behaviour */
@protocol KHTMLViewEventHandling
- keyPressEvent:(QKeyEvent*) _ke;
- keyReleaseEvent:(QKeyEvent*) _ke;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) _ce;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;
- contentsMousePressEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) event;
@end


#endif
