/***************************************************************************
                            KRandomSequence.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KRANDOMSEQUENCE_H
#define KRANDOMSEQUENCE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 A class to create a pseudo-random sequence

 Given a seed number, this class will produce a sequence of
 pseudo-random numbers.  This would typically be used in
 applications like games.

 In general, you should instantiate a KRandomSequence object and
 pass along your seed number in the constructor.  From then on,
 simply call @ref getDouble or @ref getLong to obtain the next
 number in the sequence.

 @author Sean Harmer <sh@astro.keele.ac.uk>
 
 @short 
 A class to create a pseudo-random sequence

*/

@class QGList; 

@interface  KRandomSequence : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates a pseudo-random sequence based on the seed lngSeed.

 If lngSeed is 0, the sequence is initialized with a value from
 -[kapp random].

 A Pseudo-random sequence is different for each seed but can be 
 reproduced by starting the sequence with the same seed.

 If you need a single value which needs to be unpredictable, 
 you need to use -[kapp random] instead.

   
*/
- initWithLong: (long)lngSeed;
- init;

/** 
 Standard destructor
   
*/
- (void) dealloc;

/** 
 Copy constructor
   
*/
- copyWithZone: (NSZone *) zone;

/** 
 Restart the sequence based on lngSeed
   
*/
- setSeed: (long)lngSeed;
- setSeed;

/** 
 Get the next number from the pseudo-random sequence

*/
- (double) getDouble;

/** 
 Get the next number from the pseudo-random sequence

*/
- (unsigned long) getLong: (unsigned long)max;

/** 
 Get a boolean from the pseudo-random sequence

*/
- (BOOL) getBool;

/** 
 Put a list in random order

*/
- randomize: (QGList*)list;

/** 
 Modulate the random sequence. 

 If S(i) is the sequence of numbers that will follow 
 given the current state after calling modulate(i), 
 then S(i) != S(j) for i != j and   
      S(i) == S(j) for i == j.

 This can be usefull in game situation where "undo" restores
 the state of the random sequence. If the game modulates the
 random sequence with the move chosen by the player, the 
 random sequence will be identical whenever the player "redo"-s 
 his or hers original move, but different when the player 
 chooses another move.

 With this scenario "undo" can no longer be used to repeat a 
 certain move over and over again until the computer reacts 
 with a favourable response or to predict the response for a 
 certain move based on the response to another move.
   
*/
- modulate: (int)i;
@end

#endif
