/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* !HAVE_CONFIG_H */

#include <sys/time.h>
#include <sys/types.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include <libxfce4util/i18n.h>
#include <libxfcegui4/dialogs.h>
#include <xfprinterlist.h>
#include <xfprintsettings.h>

#include "printdlg.h"

extern gboolean xfprint_tofile(const gchar *, const gchar *,
		const XfPrintSettings *);
extern gboolean xfprint_toprinter(const XfPrinter *, const gchar *,
		const XfPrintSettings *);

XfPrinterList *printers;

#if 0
static void
_load_printers(gpointer data)
{
	printers = xfprinterlist_load();
}
#endif

int
main(int argc, char **argv)
{
	XfPrintSettings *settings;
	GtkWidget *selection;
	const gchar *file;
	struct timeval tv;
	GtkWidget *dlg;
	XfPrinter *pr;
	gint response;
	gchar *ifile;
	fd_set fds;
	GThread *thread1;
	GThread *thread2;

#if 0
#ifdef ENABLE_NLS
	/* This is required for UTF-8 at least - Please don't remove it */
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
	textdomain (GETTEXT_PACKAGE);
#endif
#else
	/* This is required for UTF-8 at least - Please don't remove it */
	xfce_textdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");
#endif

	if (!g_thread_supported())
		g_thread_init(NULL);

	thread1 = g_thread_create((GThreadFunc)xfprintsettings_load, NULL,
		TRUE, NULL);

	thread2 = g_thread_create((GThreadFunc)xfprinterlist_load, NULL,
		TRUE, NULL);

	gtk_set_locale ();
	gtk_init(&argc, &argv);

	/* if no filename given, check for input available on stdin
	 * XXX - put this into libxfce4util
	 */
	if (argc == 1) {
		FD_ZERO(&fds);
		FD_SET(STDIN_FILENO, &fds);

		tv.tv_sec = 0;
		tv.tv_usec = 20 * 1000;

		/* If no input is available on stdin, ask the users to
		 * choose a file to print.
		 */
		if (select(1, &fds, NULL, NULL, &tv) < 1) {
			selection = gtk_file_selection_new(
				_("Select file to print"));
			
			response = gtk_dialog_run(GTK_DIALOG(selection));
			
			if (response != GTK_RESPONSE_OK)
				exit(EXIT_SUCCESS);

			file = gtk_file_selection_get_filename(
				GTK_FILE_SELECTION(selection));

			if (!g_file_test(file, G_FILE_TEST_IS_REGULAR)) {
				show_error(_("The specified file does not exist"));
				exit(EXIT_FAILURE);
			}

			ifile = g_strdup(file);

			gtk_widget_destroy(selection);
		}
		else {
			/* Ok, data ready on stdin */
			ifile = g_strdup("-");
		}
	}
	else {
		ifile = g_strdup(argv[1]);
	}

	settings = (XfPrintSettings *)g_thread_join(thread1);
	printers = (XfPrinterList *)g_thread_join(thread2);

	dlg = printdlg_new(settings);

	for (;;) {
		response = gtk_dialog_run(GTK_DIALOG(dlg));

		/* the user clicked the "Save"-Button */
		if (response == GTK_RESPONSE_APPLY)
			continue;
		else if (response != GTK_RESPONSE_OK)
			break;

		printdlg_get_settings(PRINT_DLG(dlg), settings);

		if ((pr = printdlg_get_printer(PRINT_DLG(dlg))) != NULL) {
			if (!xfprint_toprinter(pr, ifile, settings))
				continue;
		}
		else {
			file = printdlg_get_file(PRINT_DLG(dlg));
			if (!xfprint_tofile(file, ifile, settings))
				continue;
		}

		break;
	}

	gtk_widget_destroy(dlg);

	xfprintsettings_free(settings);
	xfprinterlist_free(printers);
	g_free(ifile);

	return(EXIT_SUCCESS);
}

