/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.BevelBorder;

public class SoftBevelBorder
extends BevelBorder {
    static final long serialVersionUID = 5248789787305979975L;

    public SoftBevelBorder(int bevelType) {
        super(bevelType);
    }

    public SoftBevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public SoftBevelBorder(int bevelType, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        super(bevelType, highlightOuter, highlightInner, shadowOuter, shadowInner);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        switch (this.bevelType) {
            case 0: {
                SoftBevelBorder.paintSoftBevel(g, x, y, width, height, this.getHighlightOuterColor(c), this.getHighlightInnerColor(c), this.getShadowInnerColor(c), this.getShadowOuterColor(c));
                break;
            }
            case 1: {
                SoftBevelBorder.paintSoftBevel(g, x, y, width, height, this.getShadowOuterColor(c), this.getShadowInnerColor(c), this.getHighlightInnerColor(c), this.getHighlightOuterColor(c));
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(3, 3, 3, 3);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 3;
        insets.top = 3;
        insets.right = 3;
        insets.left = 3;
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private static void paintSoftBevel(Graphics g, int x, int y, int width, int height, Color a, Color b, Color c, Color d) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        --width;
        --height;
        try {
            g.setColor(a);
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(0, 1, 2, 1);
            g.drawLine(0, 2, 0, height - 1);
            g.setColor(b);
            g.drawLine(width, 0, width, 0);
            g.drawLine(2, 1, width - 1, 1);
            g.drawLine(1, 2, 2, 2);
            g.drawLine(1, 3, 1, height - 1);
            g.drawLine(0, height - 1, 0, height);
            g.setColor(c);
            g.drawLine(width - 1, height - 1, width - 1, height - 1);
            g.setColor(d);
            g.drawLine(2, height, width, height);
            g.drawLine(width, 2, width, height - 1);
        }
        finally {
            Object var10_10 = null;
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

