/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.ScopeDesc;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class PCDesc
extends VMObject {
    private static CIntegerField pcOffsetField;
    private static CIntegerField scopeDecodeOffsetField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("PcDesc");
        pcOffsetField = type.getCIntegerField("_pc_offset");
        scopeDecodeOffsetField = type.getCIntegerField("_scope_decode_offset");
    }

    public PCDesc(Address addr) {
        super(addr);
    }

    public int getPCOffset() {
        return (int)pcOffsetField.getValue(this.addr);
    }

    public int getScopeDecodeOffset() {
        return this.isAtCall() ? (int)scopeDecodeOffsetField.getValue(this.addr) : (int)(-scopeDecodeOffsetField.getValue(this.addr));
    }

    public boolean isAtCall() {
        return scopeDecodeOffsetField.getValue(this.addr) >= 0L;
    }

    public Address getRealPC(NMethod code) {
        return code.instructionsBegin().addOffsetTo(this.getPCOffset());
    }

    public void print(NMethod code) {
        this.printOn(System.out, code);
    }

    public void printOn(PrintStream tty, NMethod code) {
        tty.println("PCDesc(" + this.getRealPC(code) + "):");
        for (ScopeDesc sd = code.getScopeDescAt(this.getRealPC(code), this.isAtCall()); sd != null; sd = sd.sender()) {
            tty.print(" ");
            sd.getMethod().printValueOn(tty);
            tty.print("  @" + sd.getBCI());
            tty.print("  (" + (this.isAtCall() ? "at_call" : "not_at_call") + ")");
            tty.println();
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                PCDesc.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

