/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.IndexableFieldIdentifier;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.SignatureIterator;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.ProcImageClassLoader;
import sun.jvm.hotspot.utilities.RobustOopDeterminator;

public class ObjectReader {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.utilities.ObjectReader.DEBUG") != null;
    protected Symbol javaLangString;
    protected final ClassLoader cl;
    protected Map oopToObjMap;
    protected Map fieldMap;

    public ObjectReader(ClassLoader cl) {
        this.cl = cl;
        this.oopToObjMap = new HashMap();
        this.fieldMap = new HashMap();
    }

    public ObjectReader() {
        this(new ProcImageClassLoader());
    }

    public Object readObject(Oop oop) throws ClassNotFoundException {
        if (oop instanceof Instance) {
            return this.readInstance((Instance)oop);
        }
        if (oop instanceof TypeArray) {
            return this.readPrimitiveArray((TypeArray)oop);
        }
        if (oop instanceof ObjArray) {
            return this.readObjectArray((ObjArray)oop);
        }
        return null;
    }

    protected final Object getDefaultPrimitiveValue(Class clz) {
        if (clz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clz == Character.TYPE) {
            return new Character(' ');
        }
        if (clz == Byte.TYPE) {
            return new Byte(0);
        }
        if (clz == Short.TYPE) {
            return new Short(0);
        }
        if (clz == Integer.TYPE) {
            return new Integer(0);
        }
        if (clz == Long.TYPE) {
            return new Long(0L);
        }
        if (clz == Float.TYPE) {
            return new Float(0.0f);
        }
        if (clz == Double.TYPE) {
            return new Double(0.0);
        }
        throw new RuntimeException("should not reach here!");
    }

    protected Symbol javaLangString() {
        if (this.javaLangString == null) {
            this.javaLangString = VM.getVM().getSymbolTable().probe("java/lang/String");
        }
        return this.javaLangString;
    }

    public Object readInstance(Instance oop) throws ClassNotFoundException {
        Object result = this.getFromObjTable(oop);
        if (result == null) {
            InstanceKlass kls = (InstanceKlass)oop.getKlass();
            if (kls.getName().equals(this.javaLangString())) {
                return OopUtilities.stringOopToString(oop);
            }
            Class clz = this.readClass(kls);
            try {
                result = clz.newInstance();
            }
            catch (Exception ex) {
                Constructor<?>[] ctrs = clz.getDeclaredConstructors();
                for (int n = 0; n < ctrs.length; ++n) {
                    Constructor<?> c = ctrs[n];
                    Class<?>[] paramTypes = c.getParameterTypes();
                    Object[] params = new Object[paramTypes.length];
                    for (int i = 0; i < params.length; ++i) {
                        if (!paramTypes[i].isPrimitive()) continue;
                        params[i] = this.getDefaultPrimitiveValue(paramTypes[i]);
                    }
                    try {
                        c.setAccessible(true);
                        result = c.newInstance(params);
                        break;
                    }
                    catch (Exception exp) {
                        if (!DEBUG) continue;
                        System.err.println("Can't create object using " + c);
                        exp.printStackTrace();
                        continue;
                    }
                }
            }
            if (result != null) {
                this.putIntoObjTable(oop, result);
                oop.iterate(new FieldSetter(result), false);
            }
        }
        return result;
    }

    public Object readPrimitiveArray(final TypeArray array) {
        Object result = this.getFromObjTable(array);
        if (result == null) {
            int length = (int)array.getLength();
            TypeArrayKlass klass = (TypeArrayKlass)array.getKlass();
            int type = (int)klass.getType();
            switch (type) {
                case 4: {
                    final boolean[] arrayObj = new boolean[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doBoolean(BooleanField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                case 5: {
                    final char[] arrayObj = new char[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doChar(CharField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                case 6: {
                    final float[] arrayObj = new float[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doFloat(FloatField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                case 7: {
                    final double[] arrayObj = new double[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doDouble(DoubleField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                case 8: {
                    final byte[] arrayObj = new byte[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doByte(ByteField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                case 9: {
                    final short[] arrayObj = new short[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doShort(ShortField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                case 10: {
                    final int[] arrayObj = new int[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doInt(IntField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                case 11: {
                    final long[] arrayObj = new long[length];
                    array.iterate(new DefaultOopVisitor(){

                        public void doLong(LongField field, boolean isVMField) {
                            IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                            arrayObj[ifd.getIndex()] = field.getValue(array);
                        }
                    }, false);
                    result = arrayObj;
                    break;
                }
                default: {
                    throw new RuntimeException("should not reach here!");
                }
            }
            this.putIntoObjTable(array, result);
        }
        return result;
    }

    protected final boolean isRobust(OopHandle handle) {
        return RobustOopDeterminator.oopLooksValid(handle);
    }

    public Object readObjectArray(ObjArray array) throws ClassNotFoundException {
        Object[] result = this.getFromObjTable(array);
        if (result == null) {
            int length = (int)array.getLength();
            ObjArrayKlass klass = (ObjArrayKlass)array.getKlass();
            Klass bottomKls = klass.getBottomKlass();
            Class bottomCls = null;
            int dimension = (int)klass.getDimension();
            int[] dimArray = null;
            if (bottomKls instanceof InstanceKlass) {
                bottomCls = this.readClass((InstanceKlass)bottomKls);
                dimArray = new int[dimension];
            } else {
                TypeArrayKlass botKls = (TypeArrayKlass)bottomKls;
                dimArray = new int[dimension - 1];
            }
            dimArray[0] = length;
            final Object[] arrayObj = (Object[])Array.newInstance(bottomCls, dimArray);
            this.putIntoObjTable(array, arrayObj);
            result = arrayObj;
            array.iterate(new DefaultOopVisitor(){

                public void doOop(OopField field, boolean isVMField) {
                    block3: {
                        OopHandle handle = field.getValueAsOopHandle(this.getObj());
                        if (!ObjectReader.this.isRobust(handle)) {
                            return;
                        }
                        IndexableFieldIdentifier ifd = (IndexableFieldIdentifier)field.getID();
                        try {
                            arrayObj[ifd.getIndex()] = ObjectReader.this.readObject(field.getValue(this.getObj()));
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block3;
                            System.err.println("Array element set failed for " + ifd);
                            e.printStackTrace();
                        }
                    }
                }
            }, false);
        }
        return result;
    }

    public Class readClass(InstanceKlass kls) throws ClassNotFoundException {
        Class<?> cls = (Class<?>)this.getFromObjTable(kls);
        if (cls == null) {
            cls = Class.forName(kls.getName().asString().replace('/', '.'), true, this.cl);
            this.putIntoObjTable(kls, cls);
        }
        return cls;
    }

    public Object readMethodOrConstructor(sun.jvm.hotspot.oops.Method m) throws NoSuchMethodException, ClassNotFoundException {
        String name = m.getName().asString();
        if (name.equals("<init>")) {
            return this.readConstructor(m);
        }
        return this.readMethod(m);
    }

    public Method readMethod(sun.jvm.hotspot.oops.Method m) throws NoSuchMethodException, ClassNotFoundException {
        Method result = (Method)this.getFromObjTable(m);
        if (result == null) {
            Class clz = this.readClass((InstanceKlass)m.getMethodHolder());
            String name = m.getName().asString();
            Class[] paramTypes = this.getParamTypes(m.getSignature());
            result = clz.getMethod(name, paramTypes);
            this.putIntoObjTable(m, result);
        }
        return result;
    }

    public Constructor readConstructor(sun.jvm.hotspot.oops.Method m) throws NoSuchMethodException, ClassNotFoundException {
        Constructor result = (Constructor)this.getFromObjTable(m);
        if (result == null) {
            Class clz = this.readClass((InstanceKlass)m.getMethodHolder());
            String name = m.getName().asString();
            Class[] paramTypes = this.getParamTypes(m.getSignature());
            result = clz.getDeclaredConstructor(paramTypes);
            this.putIntoObjTable(m, result);
        }
        return result;
    }

    public Field readField(sun.jvm.hotspot.oops.Field f) throws NoSuchFieldException, ClassNotFoundException {
        Field result = (Field)this.fieldMap.get(f);
        if (result == null) {
            FieldIdentifier fieldId = f.getID();
            Class clz = this.readClass(f.getFieldHolder());
            String name = fieldId.getName();
            try {
                result = clz.getField(name);
            }
            catch (NoSuchFieldException nsfe) {
                result = clz.getDeclaredField(name);
            }
            this.fieldMap.put(f, result);
        }
        return result;
    }

    protected void putIntoObjTable(Oop oop, Object obj) {
        this.oopToObjMap.put(oop, obj);
    }

    protected Object getFromObjTable(Oop oop) {
        return this.oopToObjMap.get(oop);
    }

    protected Class[] getParamTypes(Symbol signature) {
        SignatureParser sp = new SignatureParser(signature);
        sp.iterateParameters();
        Class[] result = new Class[sp.getNumParams()];
        Enumeration e = sp.getParamTypes();
        int i = 0;
        while (e.hasMoreElements()) {
            result[i] = (Class)e.nextElement();
            ++i;
        }
        return result;
    }

    protected class SignatureParser
    extends SignatureIterator {
        protected Vector tmp;

        public SignatureParser(Symbol s) {
            super(s);
            this.tmp = new Vector();
        }

        public void doBool() {
            this.tmp.add(Boolean.TYPE);
        }

        public void doChar() {
            this.tmp.add(Character.TYPE);
        }

        public void doFloat() {
            this.tmp.add(Float.TYPE);
        }

        public void doDouble() {
            this.tmp.add(Double.TYPE);
        }

        public void doByte() {
            this.tmp.add(Byte.TYPE);
        }

        public void doShort() {
            this.tmp.add(Short.TYPE);
        }

        public void doInt() {
            this.tmp.add(Integer.TYPE);
        }

        public void doLong() {
            this.tmp.add(Long.TYPE);
        }

        public void doVoid() {
            if (!this.isReturnType()) {
                throw new RuntimeException("should not reach here");
            }
            this.tmp.add(Void.TYPE);
        }

        public void doObject(int begin, int end) {
            this.tmp.add(this.getClass(begin, end));
        }

        public void doArray(int begin, int end) {
            int inner = this.arrayInnerBegin(begin);
            Class elemCls = null;
            switch (this._signature.getByteAt(inner)) {
                case 66: {
                    elemCls = Boolean.TYPE;
                    break;
                }
                case 67: {
                    elemCls = Character.TYPE;
                    break;
                }
                case 68: {
                    elemCls = Double.TYPE;
                    break;
                }
                case 70: {
                    elemCls = Float.TYPE;
                    break;
                }
                case 73: {
                    elemCls = Integer.TYPE;
                    break;
                }
                case 74: {
                    elemCls = Long.TYPE;
                    break;
                }
                case 83: {
                    elemCls = Short.TYPE;
                    break;
                }
                case 90: {
                    elemCls = Boolean.TYPE;
                    break;
                }
                case 76: {
                    elemCls = this.getClass(inner + 1, end);
                    break;
                }
            }
            int dimension = inner - begin;
            int[] dimArray = new int[dimension];
            this.tmp.add(Array.newInstance(elemCls, dimArray).getClass());
        }

        protected Class getClass(int begin, int end) {
            String className = this.getClassName(begin, end);
            try {
                return Class.forName(className, true, ObjectReader.this.cl);
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.err.println("Can't load class " + className);
                }
                throw new RuntimeException(e);
            }
        }

        protected String getClassName(int begin, int end) {
            StringBuffer buf = new StringBuffer();
            for (int i = begin; i < end; ++i) {
                char c = (char)(this._signature.getByteAt(i) & 0xFF);
                if (c == '/') {
                    buf.append('.');
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }

        protected int arrayInnerBegin(int begin) {
            while (this._signature.getByteAt(begin) == 91) {
                ++begin;
            }
            return begin;
        }

        public int getNumParams() {
            return this.tmp.size();
        }

        public Enumeration getParamTypes() {
            return this.tmp.elements();
        }
    }

    protected class FieldSetter
    extends DefaultOopVisitor {
        protected Object obj;

        public FieldSetter(Object obj) {
            this.obj = obj;
        }

        private void printFieldSetError(Field f, Exception ex) {
            if (DEBUG) {
                if (f != null) {
                    System.err.println("Field set failed for " + f);
                }
                ex.printStackTrace();
            }
        }

        public void doOop(OopField field, boolean isVMField) {
            OopHandle handle = field.getValueAsOopHandle(this.getObj());
            if (!ObjectReader.this.isRobust(handle)) {
                return;
            }
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.set(this.obj, ObjectReader.this.readObject(field.getValue(this.getObj())));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doByte(ByteField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setByte(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doChar(CharField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setChar(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doBoolean(BooleanField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setBoolean(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doShort(ShortField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setShort(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doInt(IntField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setInt(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doLong(LongField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setLong(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doFloat(FloatField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setFloat(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doDouble(DoubleField field, boolean isVMField) {
            Field f = null;
            try {
                f = ObjectReader.this.readField(field);
                if (Modifier.isFinal(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.setDouble(this.obj, field.getValue(this.getObj()));
            }
            catch (Exception ex) {
                this.printFieldSetError(f, ex);
            }
        }

        public void doCInt(CIntField field, boolean isVMField) {
            throw new RuntimeException("should not reach here!");
        }
    }
}

