/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.CommunicatorServer;
import com.sun.jmx.trace.Trace;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class ClientHandler
implements Runnable {
    protected CommunicatorServer adaptorServer = null;
    protected int requestId = -1;
    protected MBeanServer mbs = null;
    protected ObjectName objectName = null;
    protected Thread thread = null;
    protected boolean interruptCalled = false;
    protected String dbgTag = null;

    public ClientHandler(CommunicatorServer communicatorServer, int n2, MBeanServer mBeanServer, ObjectName objectName) {
        this.adaptorServer = communicatorServer;
        this.requestId = n2;
        this.mbs = mBeanServer;
        this.objectName = objectName;
        this.interruptCalled = false;
        this.dbgTag = this.makeDebugTag();
        this.thread = this.createThread(this);
    }

    Thread createThread(Runnable runnable) {
        return new Thread(this);
    }

    public void interrupt() {
        if (this.isTraceOn()) {
            this.trace("interrupt", "start");
        }
        this.interruptCalled = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.isTraceOn()) {
            this.trace("interrupt", "end");
        }
    }

    public void join() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.adaptorServer.notifyClientHandlerCreated(this);
            this.doRun();
        }
        finally {
            this.adaptorServer.notifyClientHandlerDeleted(this);
        }
    }

    public abstract void doRun();

    protected boolean isTraceOn() {
        return Trace.isSelected(1, 256);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send(1, 256, string, string2, string3);
    }

    protected boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send(2, 256, string, string2, string3);
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected String makeDebugTag() {
        return "ClientHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }
}

