/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.ClientHandler;
import com.sun.jmx.snmp.daemon.CommunicationException;
import com.sun.jmx.snmp.daemon.CommunicatorServerMBean;
import com.sun.jmx.trace.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;

public abstract class CommunicatorServer
implements Runnable,
MBeanRegistration,
NotificationBroadcaster,
CommunicatorServerMBean {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    public static final int SNMP_TYPE = 4;
    volatile transient int state = 1;
    ObjectName objectName;
    MBeanServer topMBS;
    MBeanServer bottomMBS;
    transient String dbgTag = null;
    int maxActiveClientCount = 1;
    transient int servedClientCount = 0;
    String host = null;
    int port = -1;
    private transient Object stateLock = new Object();
    private transient Vector clientHandlerVector = new Vector();
    private transient Thread fatherThread = Thread.currentThread();
    private transient Thread mainThread = null;
    private volatile boolean stopRequested = false;
    private boolean interrupted = false;
    private transient Exception startException = null;
    private transient long notifCount = 0L;
    private transient NotificationBroadcasterSupport notifBroadcaster = new NotificationBroadcasterSupport();
    private transient MBeanNotificationInfo[] notifInfos = null;
    int infoType;

    public CommunicatorServer(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 4: {
                this.infoType = 256;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector Type");
            }
        }
        this.dbgTag = this.makeDebugTag();
    }

    protected Thread createMainThread() {
        return new Thread(this, this.makeThreadName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long l2) throws CommunicationException, InterruptedException {
        boolean bl2;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.waitState(1, 60000L);
            }
            boolean bl3 = bl2 = this.state == 1;
            if (bl2) {
                this.changeState(3);
                this.stopRequested = false;
                this.interrupted = false;
                this.startException = null;
            }
        }
        if (!bl2) {
            if (this.isTraceOn()) {
                this.trace("start", "Connector is not OFFLINE");
            }
            return;
        }
        if (this.isTraceOn()) {
            this.trace("start", "--> Start connector ");
        }
        this.mainThread = this.createMainThread();
        this.mainThread.start();
        if (l2 > 0L) {
            this.waitForStart(l2);
        }
    }

    public void start() {
        try {
            this.start(0L);
        }
        catch (InterruptedException interruptedException) {
            this.trace("start", "interrupted: " + interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1 || this.state == 2) {
                if (this.isTraceOn()) {
                    this.trace("stop", "Connector is not ONLINE");
                }
                return;
            }
            this.changeState(2);
            if (this.isTraceOn()) {
                this.trace("stop", "Interrupt main thread");
            }
            this.stopRequested = true;
            if (!this.interrupted) {
                this.interrupted = true;
                this.mainThread.interrupt();
            }
        }
        if (this.isTraceOn()) {
            this.trace("stop", "terminateAllClient");
        }
        this.terminateAllClient();
        object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                this.changeState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitState(int n2, long l2) {
        if (this.isTraceOn()) {
            this.trace("waitState", n2 + "(0on,1off,2st) TO=" + l2 + " ; current state = " + this.getStateString());
        }
        long l3 = 0L;
        if (l2 > 0L) {
            l3 = System.currentTimeMillis() + l2;
        }
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state != n2) {
                if (l2 < 0L) {
                    if (!this.isTraceOn()) return false;
                    this.trace("waitState", "timeOut < 0, return without wait");
                    return false;
                }
                try {
                    if (l2 > 0L) {
                        long l4 = l3 - System.currentTimeMillis();
                        if (l4 <= 0L) {
                            if (!this.isTraceOn()) return false;
                            this.trace("waitState", "timed out");
                            return false;
                        }
                        this.stateLock.wait(l4);
                        continue;
                    }
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (this.isTraceOn()) {
                        this.trace("waitState", "wait interrupted");
                    }
                    if (this.state != n2) return false;
                    return true;
                }
            }
            if (!this.isTraceOn()) return true;
            this.trace("waitState", "returning in desired state");
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForStart(long l2) throws CommunicationException, InterruptedException {
        if (this.isTraceOn()) {
            this.trace("waitForStart", "Timeout=" + l2 + " ; current state = " + this.getStateString());
        }
        long l3 = System.currentTimeMillis();
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state == 3) {
                long l4 = System.currentTimeMillis() - l3;
                long l5 = l2 - l4;
                if (l5 < 0L) {
                    if (this.isTraceOn()) {
                        this.trace("waitForStart", "timeout < 0, return without wait");
                    }
                    throw new InterruptedException("Timeout expired");
                }
                try {
                    this.stateLock.wait(l5);
                }
                catch (InterruptedException interruptedException) {
                    if (this.isTraceOn()) {
                        this.trace("waitForStart", "wait interrupted");
                    }
                    if (this.state == 0) continue;
                    throw interruptedException;
                }
            }
            if (this.state == 0) {
                if (this.isTraceOn()) {
                    this.trace("waitForStart", "started");
                }
                return;
            }
            if (this.startException instanceof CommunicationException) {
                throw (CommunicationException)this.startException;
            }
            if (this.startException instanceof InterruptedException) {
                throw (InterruptedException)this.startException;
            }
            if (this.startException != null) {
                throw new CommunicationException(this.startException, "Failed to start: " + this.startException);
            }
            throw new CommunicationException("Failed to start: state is " + CommunicatorServer.getStringForState(this.state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    public String getStateString() {
        return CommunicatorServer.getStringForState(this.state);
    }

    public String getHost() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "Unknown host";
        }
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int n2) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.port = n2;
            this.dbgTag = this.makeDebugTag();
        }
    }

    public abstract String getProtocol();

    int getServedClientCount() {
        return this.servedClientCount;
    }

    int getActiveClientCount() {
        int n2 = this.clientHandlerVector.size();
        return n2;
    }

    int getMaxActiveClientCount() {
        return this.maxActiveClientCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxActiveClientCount(int n2) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.maxActiveClientCount = n2;
        }
    }

    void notifyClientHandlerCreated(ClientHandler clientHandler) {
        this.clientHandlerVector.addElement(clientHandler);
    }

    synchronized void notifyClientHandlerDeleted(ClientHandler clientHandler) {
        this.clientHandlerVector.removeElement(clientHandler);
        this.notifyAll();
    }

    protected int getBindTries() {
        return 50;
    }

    protected long getBindSleepTime() {
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n2 = 0;
        boolean bl2 = false;
        try {
            int n3 = this.getBindTries();
            long l2 = this.getBindSleepTime();
            while (n2 < n3 && !bl2) {
                try {
                    this.doBind();
                    bl2 = true;
                }
                catch (CommunicationException communicationException) {
                    ++n2;
                    Thread.sleep(l2);
                }
            }
            if (!bl2) {
                this.doBind();
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("run", "Unexpected exception = " + exception);
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.startException = exception;
                this.changeState(1);
            }
            if (this.isTraceOn()) {
                this.trace("run", "State is OFFLINE");
            }
            this.doError(exception);
            return;
        }
        try {
            this.changeState(0);
            if (this.isTraceOn()) {
                this.trace("run", "State is ONLINE");
            }
            while (!this.stopRequested) {
                ++this.servedClientCount;
                this.doReceive();
                this.waitIfTooManyClients();
                this.doProcess();
            }
            if (this.isTraceOn()) {
                this.trace("run", "Stop has been requested");
            }
        }
        catch (InterruptedException interruptedException) {
            if (this.isTraceOn()) {
                this.trace("run", "Interrupt caught");
            }
            this.changeState(2);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("run", "Unexpected exception = " + exception);
            }
            this.changeState(2);
        }
        finally {
            Object object = this.stateLock;
            synchronized (object) {
                this.interrupted = true;
                Thread.currentThread();
                Thread.interrupted();
            }
            try {
                this.doUnbind();
                this.waitClientTermination();
                this.changeState(1);
                if (this.isTraceOn()) {
                    this.trace("run", "State is OFFLINE");
                }
            }
            catch (Exception exception) {
                if (this.isDebugOn()) {
                    this.debug("run", "Unexpected exception = " + exception);
                }
                this.changeState(1);
            }
        }
    }

    protected abstract void doError(Exception var1) throws CommunicationException;

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    public synchronized MBeanServer getMBeanServer() {
        return this.topMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMBeanServer(MBeanServer mBeanServer) throws IllegalArgumentException, IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
        }
        Vector<MBeanServer> vector = new Vector<MBeanServer>();
        MBeanServer mBeanServer2 = mBeanServer;
        while (mBeanServer2 != this.bottomMBS) {
            if (!(mBeanServer2 instanceof MBeanServerForwarder)) {
                throw new IllegalArgumentException("MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server");
            }
            if (vector.contains(mBeanServer2)) {
                throw new IllegalArgumentException("MBeanServerForwarder loop");
            }
            vector.addElement(mBeanServer2);
            mBeanServer2 = ((MBeanServerForwarder)mBeanServer2).getMBeanServer();
        }
        this.topMBS = mBeanServer;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int n2) {
        int n3;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == n2) {
                return;
            }
            n3 = this.state;
            this.state = n2;
            this.stateLock.notifyAll();
        }
        this.sendStateChangeNotification(n3, n2);
    }

    String makeDebugTag() {
        return "CommunicatorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    String makeThreadName() {
        String string = this.objectName == null ? "CommunicatorServer" : this.objectName.toString();
        return string;
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            if (this.isTraceOn()) {
                this.trace("waitIfTooManyClients", "Waiting for a client to terminate");
            }
            this.wait();
        }
    }

    private void waitClientTermination() {
        int n2 = this.clientHandlerVector.size();
        if (this.isTraceOn() && n2 >= 1) {
            this.trace("waitClientTermination", "waiting for " + n2 + " clients to terminate");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.join();
        }
        if (this.isTraceOn() && n2 >= 1) {
            this.trace("waitClientTermination", "Ok, let's go...");
        }
    }

    private void terminateAllClient() {
        int n2 = this.clientHandlerVector.size();
        if (this.isTraceOn() && n2 >= 1) {
            this.trace("terminateAllClient", "Interrupting " + n2 + " clients");
        }
        Enumeration enumeration = this.clientHandlerVector.elements();
        while (enumeration.hasMoreElements()) {
            ClientHandler clientHandler = (ClientHandler)enumeration.nextElement();
            clientHandler.interrupt();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stateLock = new Object();
        this.state = 1;
        this.stopRequested = false;
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.fatherThread = Thread.currentThread();
        this.mainThread = null;
        this.notifCount = 0L;
        this.notifInfos = null;
        this.notifBroadcaster = new NotificationBroadcasterSupport();
        this.dbgTag = this.makeDebugTag();
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (this.isDebugOn()) {
            this.debug("addNotificationListener", "Adding listener " + notificationListener + " with filter " + notificationFilter + " and handback " + object);
        }
        this.notifBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.isDebugOn()) {
            this.debug("removeNotificationListener", "Removing listener " + notificationListener);
        }
        this.notifBroadcaster.removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfos == null) {
            this.notifInfos = new MBeanNotificationInfo[1];
            String[] stringArray = new String[]{"jmx.attribute.change"};
            this.notifInfos[0] = new MBeanNotificationInfo(stringArray, AttributeChangeNotification.class.getName(), "Sent to notify that the value of the State attribute of this CommunicatorServer instance has changed.");
        }
        return this.notifInfos;
    }

    private void sendStateChangeNotification(int n2, int n3) {
        String string = CommunicatorServer.getStringForState(n2);
        String string2 = CommunicatorServer.getStringForState(n3);
        String string3 = new StringBuffer().append(this.dbgTag).append(" The value of attribute State has changed from ").append(n2).append(" (").append(string).append(") to ").append(n3).append(" (").append(string2).append(").").toString();
        ++this.notifCount;
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, this.notifCount, System.currentTimeMillis(), string3, "State", "int", new Integer(n2), new Integer(n3));
        if (this.isDebugOn()) {
            this.debug("sendStateChangeNotification", "Sending AttributeChangeNotification #" + this.notifCount + " with message: " + string3);
        }
        this.notifBroadcaster.sendNotification(attributeChangeNotification);
    }

    private static String getStringForState(int n2) {
        switch (n2) {
            case 0: {
                return "ONLINE";
            }
            case 3: {
                return "STARTING";
            }
            case 1: {
                return "OFFLINE";
            }
            case 2: {
                return "STOPPING";
            }
        }
        return "UNDEFINED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            if (this.bottomMBS != null) {
                throw new IllegalArgumentException("connector already registered in an MBean server");
            }
            this.topMBS = this.bottomMBS = mBeanServer;
        }
        this.dbgTag = this.makeDebugTag();
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRegister(Boolean bl2) {
        if (!bl2.booleanValue()) {
            CommunicatorServer communicatorServer = this;
            synchronized (communicatorServer) {
                this.bottomMBS = null;
                this.topMBS = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeregister() throws Exception {
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            this.bottomMBS = null;
            this.topMBS = null;
        }
        this.objectName = null;
        int n2 = this.getState();
        if (n2 == 0 || n2 == 3) {
            this.stop();
        }
    }

    public void postDeregister() {
    }

    Class loadClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoaderRepository classLoaderRepository = MBeanServerFactory.getClassLoaderRepository(this.bottomMBS);
            if (classLoaderRepository == null) {
                throw new ClassNotFoundException(string);
            }
            return classLoaderRepository.loadClass(string);
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, this.infoType, string, string2, throwable);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

