/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCache;

public class MemoryCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private MemoryCache cache = new MemoryCache();

    public MemoryCacheImageInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = inputStream;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        long l2 = this.streamPos;
        long l3 = this.cache.loadFromStream(this.stream, this.streamPos + 1L);
        if (l3 >= this.streamPos + 1L) {
            return this.cache.read(this.streamPos++);
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        this.bitOffset = 0;
        if (n3 == 0) {
            return 0;
        }
        long l2 = this.cache.loadFromStream(this.stream, this.streamPos + (long)n3);
        if ((n3 = (int)(l2 - this.streamPos)) > 0) {
            this.cache.read(byArray, n2, n3, this.streamPos);
            this.streamPos += (long)n3;
            return n3;
        }
        return -1;
    }

    public void flushBefore(long l2) throws IOException {
        super.flushBefore(l2);
        this.cache.disposeBefore(l2);
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return true;
    }

    public void close() throws IOException {
        super.close();
        this.cache.reset();
        this.stream = null;
    }
}

