/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFileFormat {
    private Type type;
    private int byteLength;
    private AudioFormat format;
    private int frameLength;
    private HashMap<String, Object> properties;

    protected AudioFileFormat(Type type, int n2, AudioFormat audioFormat, int n3) {
        this.type = type;
        this.byteLength = n2;
        this.format = audioFormat;
        this.frameLength = n3;
        this.properties = null;
    }

    public AudioFileFormat(Type type, AudioFormat audioFormat, int n2) {
        this(type, -1, audioFormat, n2);
    }

    public AudioFileFormat(Type type, AudioFormat audioFormat, int n2, Map<String, Object> map) {
        this(type, -1, audioFormat, n2);
        this.properties = new HashMap<String, Object>(map);
    }

    public Type getType() {
        return this.type;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public Map<String, Object> properties() {
        Map map = this.properties == null ? new HashMap(0) : (Map)this.properties.clone();
        return Collections.unmodifiableMap(map);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.type != null) {
            stringBuffer.append(this.type.toString() + " (." + this.type.getExtension() + ") file");
        } else {
            stringBuffer.append("unknown file format");
        }
        if (this.byteLength != -1) {
            stringBuffer.append(", byte length: " + this.byteLength);
        }
        stringBuffer.append(", data format: " + this.format);
        if (this.frameLength != -1) {
            stringBuffer.append(", frame length: " + this.frameLength);
        }
        return new String(stringBuffer);
    }

    public static class Type {
        public static final Type WAVE = new Type("WAVE", "wav");
        public static final Type AU = new Type("AU", "au");
        public static final Type AIFF = new Type("AIFF", "aif");
        public static final Type AIFC = new Type("AIFF-C", "aifc");
        public static final Type SND = new Type("SND", "snd");
        private final String name;
        private final String extension;

        public Type(String string, String string2) {
            this.name = string;
            this.extension = string2;
        }

        public final boolean equals(Object object) {
            if (this.toString() == null) {
                return object != null && object.toString() == null;
            }
            if (object instanceof Type) {
                return this.toString().equals(object.toString());
            }
            return false;
        }

        public final int hashCode() {
            if (this.toString() == null) {
                return 0;
            }
            return this.toString().hashCode();
        }

        public final String toString() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

