/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.CheckboxMenuItem;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XMenuComponentPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XToolkit;

public class XMenuItemPeer
extends XMenuComponentPeer
implements MenuItemPeer {
    private XMenuPeer menuPeer;
    private String label;
    private boolean enabled;
    private static final int ARROW_INDENT = 15;
    private static Field f_shortcut = XToolkit.getField(MenuItem.class, "shortcut");
    private static Method m_getActionCommand = XToolkit.getMethod(MenuItem.class, "getActionCommandImpl", null);

    XMenuItemPeer() {
    }

    XMenuItemPeer(MenuItem menuItem) {
        super(menuItem);
        this.setLabel(menuItem.getLabel());
        this.enabled = menuItem.isEnabled();
        this.visible = true;
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
    }

    public XMenuPeer getMenuPeer() {
        return this.menuPeer;
    }

    void setMenuPeer(XMenuPeer xMenuPeer) {
        this.menuPeer = xMenuPeer;
    }

    public void setLabel(String string) {
        String string2 = this.label = string == null ? "" : string;
        if (this.menuPeer != null && this.menuPeer.isVisible()) {
            this.menuPeer.repaintMenuItem(this);
        }
    }

    public void setEnabled(boolean bl2) {
        if (this.enabled != bl2) {
            this.enabled = bl2;
            if (this.menuPeer != null && this.menuPeer.isVisible()) {
                this.menuPeer.repaintMenuItem(this);
            }
        }
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    void action(long l2, int n2) {
        this.postEvent(new ActionEvent(this.menuTarget, 1001, this.getActionCommand(), l2, n2));
    }

    String getLabel() {
        return this.label;
    }

    MenuShortcut getTargetShortcut() {
        try {
            MenuComponent menuComponent = this.getMenuTarget();
            if (menuComponent != null) {
                return (MenuShortcut)f_shortcut.get(menuComponent);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    int getWidth(Graphics graphics) {
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.getLabel();
        return fontMetrics.stringWidth(string);
    }

    int getHeight(Graphics graphics) {
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return fontMetrics.getHeight();
    }

    int getShortcutWidth(Graphics graphics) {
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        MenuShortcut menuShortcut = this.getTargetShortcut();
        String string = menuShortcut != null ? "   " + menuShortcut.toString() : "";
        return fontMetrics.stringWidth(string.trim());
    }

    void paint(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
        String string;
        if (!this.getMenuPeer().isVisible() || this.isDisposed()) {
            return;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = fontMetrics.getHeight();
        int n7 = n2 + (n6 + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
        String string2 = this.getLabel();
        MenuShortcut menuShortcut = this.getTargetShortcut();
        String string3 = string = menuShortcut != null ? menuShortcut.toString() : "";
        if (string2.equals("-")) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(2, n2, n4 - 4, 1);
            this.draw3DRect(graphics, 2, n2, n4 - 5, 1, false);
        } else {
            if (bl2) {
                graphics.setColor(this.getSelect());
                graphics.fillRect(2, n2, n4 - 4, n6);
                this.draw3DRect(graphics, 2, n2, n4 - 5, n3 - n2, false);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(2, n2, n4 - 4, n6);
            }
            graphics.setColor(this.isEnabled() ? this.getForeground() : this.getDisabled());
            Shape shape = graphics.getClip();
            if (this.isEnabled() && this.menuTarget instanceof Menu) {
                graphics.setClip(0, n2, n4 - 15, n3 - n2 + 1);
            } else {
                graphics.setClip(0, n2, n4 - 3, n3 - n2 + 1);
            }
            graphics.drawString(string2, this.menuPeer.getXIndent(), n7);
            if (menuShortcut != null) {
                graphics.drawString(string, this.menuPeer.getXIndent() + n5, n7);
            }
            graphics.setClip(shape);
            if (this.isEnabled() && this.menuTarget instanceof Menu) {
                int n8 = n4 - 15;
                graphics.setColor(this.getDarkShadow());
                graphics.drawLine(n8, n7 - 2, n8 + 8, n7 - 6);
                graphics.setColor(this.getLightShadow());
                graphics.drawLine(n8 + 8, n7 - 6, n8, n7 - 10);
                graphics.drawLine(n8, n7 - 10, n8, n7 - 2);
            } else if (this.menuTarget instanceof CheckboxMenuItem) {
                this.paintCheck(graphics, 1, n2, n4, n6);
            }
        }
    }

    void paintCheck(Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    String getActionCommand() {
        String string = "";
        try {
            string = (String)m_getActionCommand.invoke(this.menuTarget, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return string;
    }

    void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    public String toString() {
        return this.getClass().getName() + "[label=" + this.getLabel() + "]";
    }
}

