/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

final class JsseJce {
    private static final Debug debug = Debug.getInstance("ssl");
    static final String CIPHER_RSA_PKCS1 = "RSA/ECB/PKCS1Padding";
    static final String CIPHER_RC4 = "RC4";
    static final String CIPHER_DES = "DES/CBC/NoPadding";
    static final String CIPHER_3DES = "DESede/CBC/NoPadding";
    static final String CIPHER_AES = "AES/CBC/NoPadding";
    static final String SIGNATURE_DSA = "DSA";
    static final String SIGNATURE_RAWDSA = "RawDSA";
    static final String SIGNATURE_RAWRSA = "NONEwithRSA";
    static final String SIGNATURE_SSLRSA = "MD5andSHA1withRSA";

    private JsseJce() {
    }

    static Cipher getCipher(String string) throws NoSuchAlgorithmException {
        try {
            Cipher cipher = Cipher.getInstance(string);
            return cipher;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException);
        }
    }

    static Signature getSignature(String string) throws NoSuchAlgorithmException {
        return Signature.getInstance(string);
    }

    static MessageDigest getMD5() {
        return JsseJce.getMessageDigest("MD5");
    }

    static MessageDigest getSHA() {
        return JsseJce.getMessageDigest("SHA");
    }

    private static MessageDigest getMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Algorithm " + string + " not available", noSuchAlgorithmException);
        }
    }

    static int getRSAKeyLength(PublicKey publicKey) {
        BigInteger bigInteger;
        if (publicKey instanceof RSAPublicKey) {
            bigInteger = ((RSAPublicKey)publicKey).getModulus();
        } else {
            RSAPublicKeySpec rSAPublicKeySpec = JsseJce.getRSAPublicKeySpec(publicKey);
            bigInteger = rSAPublicKeySpec.getModulus();
        }
        return bigInteger.bitLength();
    }

    static RSAPublicKeySpec getRSAPublicKeySpec(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.getKeySpec(publicKey, RSAPublicKeySpec.class);
        }
        catch (Exception exception) {
            throw (RuntimeException)new RuntimeException().initCause(exception);
        }
    }
}

