#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.udev.new
( cd etc/hotplug.d/default ; rm -rf 10-udev.hotplug )
( cd etc/hotplug.d/default ; ln -sf /sbin/udevsend 10-udev.hotplug )
( cd usr/man/man8 ; rm -rf udevsend.8.gz )
( cd usr/man/man8 ; ln -sf udevd.8.gz udevsend.8.gz )
( cd sbin ; rm -rf udevstart )
( cd sbin ; ln -sf /sbin/udev udevstart )
