/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.DigestMD5Client;
import com.sun.security.sasl.digest.DigestMD5Server;
import com.sun.security.sasl.util.PolicyUtils;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryImpl
implements SaslClientFactory,
SaslServerFactory {
    private static final String[] myMechs = new String[]{"DIGEST-MD5"};
    private static final int DIGEST_MD5 = 0;
    private static final int[] mechPolicies = new int[]{17};

    @Override
    public SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(myMechs[0]) || !PolicyUtils.checkPolicy(mechPolicies[0], map)) continue;
            if (callbackHandler == null) {
                throw new SaslException("Callback handler with support for RealmChoiceCallback, RealmCallback, NameCallback, and PasswordCallback required");
            }
            return new DigestMD5Client(string, string2, string3, map, callbackHandler);
        }
        return null;
    }

    @Override
    public SaslServer createSaslServer(String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        if (string.equals(myMechs[0]) && PolicyUtils.checkPolicy(mechPolicies[0], map)) {
            if (callbackHandler == null) {
                throw new SaslException("Callback handler with support for AuthorizeCallback, RealmCallback, NameCallback, and PasswordCallback required");
            }
            return new DigestMD5Server(string2, string3, map, callbackHandler);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> map) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, map);
    }
}

