/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalButtonUI
extends BasicButtonUI {
    private static final MetalButtonUI metalButtonUI = new MetalButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return super.createButtonListener(abstractButton);
    }

    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        return this.focusColor;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (jComponent.getBackground() instanceof UIResource && abstractButton.isContentAreaFilled() && jComponent.isEnabled()) {
            ButtonModel buttonModel = abstractButton.getModel();
            if (!MetalUtils.isToolBarButton(jComponent)) {
                if (!buttonModel.isArmed() && !buttonModel.isPressed() && MetalUtils.drawGradient(jComponent, graphics, "Button.gradient", 0, 0, jComponent.getWidth(), jComponent.getHeight(), true)) {
                    this.paint(graphics, jComponent);
                    return;
                }
            } else if (buttonModel.isRollover() && MetalUtils.drawGradient(jComponent, graphics, "Button.gradient", 0, 0, jComponent.getWidth(), jComponent.getHeight(), true)) {
                this.paint(graphics, jComponent);
                return;
            }
        }
        super.update(graphics, jComponent);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        boolean bl2;
        Rectangle rectangle4 = new Rectangle();
        String string = abstractButton.getText();
        boolean bl3 = bl2 = abstractButton.getIcon() != null;
        if (string != null && !string.equals("")) {
            if (!bl2) {
                rectangle4.setBounds(rectangle2);
            } else {
                rectangle4.setBounds(rectangle3.union(rectangle2));
            }
        } else if (bl2) {
            rectangle4.setBounds(rectangle3);
        }
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n2 = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
        } else {
            graphics.setColor(this.getDisabledTextColor());
        }
        SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }
}

