/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthIcon;
import sun.swing.plaf.synth.SynthUI;

class SynthToolBarUI
extends BasicToolBarUI
implements PropertyChangeListener,
SynthUI {
    protected Icon handleIcon = null;
    protected Rectangle contentRect = new Rectangle();
    private SynthStyle style;
    private SynthStyle contentStyle;
    private SynthStyle dragWindowStyle;

    SynthToolBarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthToolBarUI();
    }

    protected void installDefaults() {
        this.toolBar.setLayout(this.createLayout());
        this.updateStyle(this.toolBar);
    }

    protected void installListeners() {
        super.installListeners();
        this.toolBar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.toolBar.removePropertyChangeListener(this);
    }

    private void updateStyle(JToolBar jToolBar) {
        SynthContext synthContext = this.getContext((JComponent)jToolBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != this.style) {
            this.handleIcon = this.style.getIcon(synthContext, "ToolBar.handleIcon");
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
        synthContext = this.getContext(jToolBar, Region.TOOL_BAR_CONTENT, 1);
        this.contentStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jToolBar, Region.TOOL_BAR_DRAG_WINDOW, 1);
        this.dragWindowStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.toolBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        this.handleIcon = null;
        synthContext = this.getContext(this.toolBar, Region.TOOL_BAR_CONTENT, 1);
        this.contentStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.contentStyle = null;
        synthContext = this.getContext(this.toolBar, Region.TOOL_BAR_DRAG_WINDOW, 1);
        this.dragWindowStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.dragWindowStyle = null;
        this.toolBar.setLayout(null);
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected LayoutManager createLayout() {
        return new SynthToolBarLayoutManager();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.dragWindowStyle, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintToolBarBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintToolBarBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    protected void setBorderToNonRollover(Component component) {
    }

    protected void setBorderToRollover(Component component) {
    }

    protected void setBorderToNormal(Component component) {
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        if (this.handleIcon != null && this.toolBar.isFloatable()) {
            int n2 = this.toolBar.getComponentOrientation().isLeftToRight() ? 0 : this.toolBar.getWidth() - SynthIcon.getIconWidth(this.handleIcon, synthContext);
            SynthIcon.paintIcon(this.handleIcon, synthContext, graphics, n2, 0, SynthIcon.getIconWidth(this.handleIcon, synthContext), SynthIcon.getIconHeight(this.handleIcon, synthContext));
        }
        SynthContext synthContext2 = this.getContext((JComponent)this.toolBar, Region.TOOL_BAR_CONTENT);
        this.paintContent(synthContext2, graphics, this.contentRect);
        synthContext2.dispose();
    }

    public void paintContent(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintToolBarContentBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        synthContext.getPainter().paintToolBarContentBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void paintDragWindow(Graphics graphics) {
        int n2 = this.dragWindow.getWidth();
        int n3 = this.dragWindow.getHeight();
        SynthContext synthContext = this.getContext((JComponent)this.toolBar, Region.TOOL_BAR_DRAG_WINDOW);
        SynthLookAndFeel.updateSubregion(synthContext, graphics, new Rectangle(0, 0, n2, n3));
        synthContext.getPainter().paintToolBarDragWindowBackground(synthContext, graphics, 0, 0, n2, n3);
        synthContext.getPainter().paintToolBarDragWindowBorder(synthContext, graphics, 0, 0, n2, n3);
        synthContext.dispose();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JToolBar)propertyChangeEvent.getSource());
        }
    }

    class SynthToolBarLayoutManager
    implements LayoutManager {
        SynthToolBarLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            Dimension dimension = new Dimension();
            SynthContext synthContext = SynthToolBarUI.this.getContext(jToolBar);
            if (jToolBar.getOrientation() == 0) {
                dimension.width = SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, synthContext);
                for (int i2 = 0; i2 < jToolBar.getComponentCount(); ++i2) {
                    Dimension dimension2 = jToolBar.getComponent(i2).getMinimumSize();
                    dimension.width += dimension2.width;
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension.height = SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, synthContext);
                for (int i3 = 0; i3 < jToolBar.getComponentCount(); ++i3) {
                    Dimension dimension3 = jToolBar.getComponent(i3).getMinimumSize();
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            synthContext.dispose();
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            Dimension dimension = new Dimension();
            SynthContext synthContext = SynthToolBarUI.this.getContext(jToolBar);
            if (jToolBar.getOrientation() == 0) {
                dimension.width = SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, synthContext);
                for (int i2 = 0; i2 < jToolBar.getComponentCount(); ++i2) {
                    Dimension dimension2 = jToolBar.getComponent(i2).getPreferredSize();
                    dimension.width += dimension2.width;
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension.height = SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, synthContext);
                for (int i3 = 0; i3 < jToolBar.getComponentCount(); ++i3) {
                    Dimension dimension3 = jToolBar.getComponent(i3).getPreferredSize();
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            synthContext.dispose();
            return dimension;
        }

        public void layoutContainer(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            boolean bl2 = jToolBar.getComponentOrientation().isLeftToRight();
            SynthContext synthContext = SynthToolBarUI.this.getContext(jToolBar);
            int n2 = SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, synthContext);
            if (jToolBar.getOrientation() == 0) {
                int n3 = bl2 ? n2 : jToolBar.getWidth() - n2;
                for (int i2 = 0; i2 < jToolBar.getComponentCount(); ++i2) {
                    Component component = jToolBar.getComponent(i2);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(bl2 ? n3 : n3 - dimension.width, 0, dimension.width, dimension.height);
                    n3 = bl2 ? n3 + dimension.width : n3 - dimension.width;
                }
                SynthToolBarUI.this.contentRect.x = bl2 ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, synthContext) : 0;
                SynthToolBarUI.this.contentRect.y = 0;
                SynthToolBarUI.this.contentRect.width = jToolBar.getWidth() - SynthToolBarUI.this.contentRect.x;
                SynthToolBarUI.this.contentRect.height = jToolBar.getHeight();
            } else {
                int n4 = SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, synthContext);
                for (int i3 = 0; i3 < jToolBar.getComponentCount(); ++i3) {
                    Component component = jToolBar.getComponent(i3);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(0, n4, dimension.width, dimension.height);
                    n4 += dimension.height;
                }
                SynthToolBarUI.this.contentRect.x = 0;
                SynthToolBarUI.this.contentRect.y = SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, synthContext);
                SynthToolBarUI.this.contentRect.width = jToolBar.getWidth();
                SynthToolBarUI.this.contentRect.height = jToolBar.getHeight() - SynthToolBarUI.this.contentRect.y;
            }
            synthContext.dispose();
        }
    }
}

