#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/named.conf.new
config etc/rc.d/rc.bind.new
# Add a /var/named if it doesn't exist:
if [ ! -d var/named ]; then
  mkdir -p var/named
  chmod 755 var/named
fi
# Generate /etc/rndc.key if there's none there,
# and there also no /etc/rndc.conf (the other
# way to set this up).
if [ ! -r etc/rndc.key -a ! -r /etc/rndc.conf ]; then
  chroot . /sbin/ldconfig
  chroot . /usr/sbin/rndc-confgen -a
fi
( cd usr/lib ; rm -rf liblwres.so.1 )
( cd usr/lib ; ln -sf liblwres.so.1.2.1 liblwres.so.1 )
( cd usr/lib ; rm -rf libisc.so.9 )
( cd usr/lib ; ln -sf libisc.so.9.1.4 libisc.so.9 )
( cd usr/lib ; rm -rf libbind.so.0 )
( cd usr/lib ; ln -sf libbind9.so.0.0.4 libbind.so.0 )
( cd usr/lib ; rm -rf libisccc.so.0 )
( cd usr/lib ; ln -sf libisccc.so.0.2.1 libisccc.so.0 )
( cd usr/lib ; rm -rf libdns.so.20 )
( cd usr/lib ; ln -sf libdns.so.20.0.0 libdns.so.20 )
( cd usr/lib ; rm -rf libisccfg.so.1 )
( cd usr/lib ; ln -sf libisccfg.so.1.0.4 libisccfg.so.1 )
( cd usr/sbin ; rm -rf lwresd )
( cd usr/sbin ; ln -sf named lwresd )
