/* This overlay JS file contains the JS necessary for integrating
   AIM presence into the messenger msg header pane overlay (msgHdrViewOverlay).

   It allows us to dynamically modify the msg hdr view overlay to add 
   presence indication for email addresses in that pane.
*/



// cache the properties we are interested in...
var buddyStateString = RDF.GetResource("http://home.netscape.com/NC-rdf#BuddyStateString");

// This array of dom nodes is an array indexed by URI that keeps track of the
// dom nodes in the msg header pane we care about...
var domNodes = new Object();

/* SetPresence updates the titled button image (node)
   based on the property value of presence
*/
function SetPresence(node, presence)
{
  if (node)
  {
   // if we have a node that corresponds to this URI, then we need to poke
   // it....
    var targetString = presence.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    node.setAttribute("BuddyStateString", targetString);
    // this silly align hack is because css isn't noticing the alignment
    // attribute unless I set it to something...then set it back to what
    // I really want...
    node.setAttribute("align", "left");
    node.setAttribute("align", "right");
    node.setAttribute("max-height", "15px");
  }
}

/* Extract the AIM ID from the node and send an instant message
*/
function SendIMFor (node)
{
//XXXjelwellXXX might need to change state from OnlineAway to Online
  var target = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
  var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  if ("OnlineAway" == state)
  {
	if ( aimLocateManager() ) {
		aimLocateManager().SetUserInfoAwayMessage(null);
	}
  }

  if (node)
  {
    var screenName = node.getAttribute("IMScreenName");
    if (screenName)
    {
      aimIMInvokeIMForm(screenName);
    }
    else
      aimIMInvokeIMForm(null);
  }
}

function AddToBuddyListFor(node)
{
//XXXjelwellXXX might need to change state from OnlineAway to Online
  if (node)
  {
    var screenName = node.getAttribute("IMScreenName");
    openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", "modal=yes,titlebar,chrome", null, null, screenName);
  }
}

