// globals
// window arguments defined here, but may not be used.
// mainly to test & explain valid arguments.

inviteArgsObj = window.arguments[0];

var inviteMode                = inviteArgsObj.inviteMode;
var inviteProposalObj         = inviteArgsObj.inviteProposalObj;
var inviteMsg                 = inviteProposalObj.GetInvitation();
var fileProposalScreenName    = inviteArgsObj.inviteProposalScreenName;

var nsIFilePicker = Components.interfaces.nsIFilePicker;
var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
var fileXferSession;
var fileName;
var fileXferSessionCallback = new Object();
var remoteError = false;

fileXferSessionCallback.OnStateChange = function (state, msg)
{
  var stateEnum = Components.interfaces.nsAimFileXferStates;
  if (stateEnum.Complete == state)
  {
      window.close();
  }
  if (stateEnum.Progress == state)
  {
      if (document.getElementById("imfileprogress").getAttribute("mode") !="determined"){
        document.getElementById("imfileprogress").setAttribute("mode", "determined");
      }
      document.getElementById("filestate").setAttribute("value", fileXferSession.GetTotalBytes() + " / " + fileXferSession.GetTotalSize() * 100);
    document.getElementById("imfileprogress").setAttribute("value", fileXferSession.GetTotalBytes() / fileXferSession.GetTotalSize() * 100);
  }
        if (stateEnum.Error == state)
        {
                aimErrorBox(msg);
                remoteError = true;
                window.close();
        }
}

function incomingFileOnWinLoad(){
   dump("incomingFileOnWinLoad\n");

   if(inviteMode && inviteMode=="incomingfile"){
     //setButtons(aimString('chat.YesButton'), aimString('chat.NoButton'), aimString('accept.tooltip'), aimString('decline.tooltip'));
    
      dump("incoming file\n");

      doSetOKCancel(incomingFileCmdAcceptRendezvous, incomingfileCmdDeclineRendezvous);

      if(inviteProposalObj)
      {
         incomingChatRoomInviteMsg = inviteProposalObj.GetInvitation();

         document.getElementById("IncomingFile").setAttribute("title", aimString('file.receive').replace(/%ScreenName%/, fileProposalScreenName));

         var descriptionNode = top.document.getElementById("description").contentWindow;
         
         var myRange = descriptionNode.document.createRange();
         var descriptionBody = descriptionNode.document.body;
         myRange.setStartAfter(descriptionBody);

         var docFrag = myRange.createContextualFragment(inviteMsg);
         descriptionBody.appendChild(docFrag)

         inviteProposalObj.Accept();
         fileXferSession = fileXfer().Receive(inviteProposalObj);
         inviteArgsObj.fileXferSession = fileXferSession;
         document.getElementById("size").setAttribute("label", aimString('file.buddy') + "    (" + aimString('file.size') + " " + fileXferSession.GetTotalSize() + " " + aimString('file.bytes') + ")");
         fileName = fileXferSession.GetFileName();
         var fileDirectory = aimPrefsManager().GetCharPref( "aim.filexfer.location", null, false );
         if (fileDirectory && fileDirectory != "")
           document.getElementById("filelocation").setAttribute("value", fileDirectory + fileName);
         document.getElementById("filename").setAttribute("value",fileName);
         fileXferSession.SetScreenName(fileProposalScreenName);
         fileXferSession.SetInviteMode(0);
       } 
      fileXferSession.SetFileXferSessionCallback(fileXferSessionCallback);
   }
}

function incomingFileOnWinUnLoad(){
   //window.close();
}

function cmdIncomingFileWarn()
{
}

function incomingfileCmdDeclineRendezvous()
{
   inviteProposalObj.Reject();
   window.close();
}

function incomingFileCmdAcceptRendezvous(){
   var fileLocation = document.getElementById("filelocation").value;
   if (fileLocation && fileLocation.length > 0)
       inviteArgsObj.filepath = document.getElementById("filelocation").value;
   else
   {
       alert(aimString('file.pickdirectory'));
       return;
   }

   window.openDialog('chrome://aim/content/transfer.xul','_blank','chrome,all,dialog=no',inviteArgsObj); 
   window.close();
}

function openfilepicker()
{
      fp.init(window, aimString('file.choose'), nsIFilePicker.modeSave);
      if (fileName && fileName != "")
      {
        dump ("fileName is : " + fileName + " \n");
        fp.defaultString = fileName;
      }
      else
      {
        fp.defaultString = aimPrefsManager().GetCharPref( "aim.filexfer.location", null, false );
        dump ("fileName is : " + aimPrefsManager().GetCharPref( "aim.filexfer.location", null, false ) + " \n");
      }

      fp.appendFilters(nsIFilePicker.filterAll);

      try {
         fp.show();
      }
      catch (ex) {
         dump ("filePicker.chooseInputFile threw an exception\n");
         return false;
      }
      if (fp.file && fp.file.path.length > 0)
          document.getElementById("filelocation").setAttribute("value", fp.file.path);
}

