const nsIWebNavigation = Components.interfaces.nsIWebNavigation;

var gURLBar = null;
var gBrowser = null;
var gSession = null;

function nsBrowserStatusHandler()
{
  this.init();
}

nsBrowserStatusHandler.prototype = 
{
  QueryInterface : function(aIID)
  {
    if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
        aIID.equals(Components.interfaces.nsISupportsWeakReference))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

  init : function()
  {
  },

  destroy : function()
  {
  },

  onStateChange : function(aWebProgress, aRequest, aStateFlags, aStatus)
  {
  },

  onProgressChange : function(aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress)
  {
  },

  onLocationChange : function(aWebProgress, aRequest, aLocation)
  {
    UpdateBackForwardButtons();
  },

  onStatusChange : function(aWebProgress, aRequest, aStatus, aMessage)
  {
  },

  onSecurityChange : function(aWebProgress, aRequest, aState)
  {
  }
}

var gBrowserStatusHandler;
function MiniNavStartup()
{
  var minibrowser = document.getElementById("content");
  var aimtodayurl = aimRegionString("aim.aimtoday");
  if (minibrowser)
    minibrowser.setAttribute("src", aimtodayurl);

  var webNavigation = getWebNavigation();
  gBrowser = document.getElementById("content");
  gBrowserStatusHandler = new nsBrowserStatusHandler();

  try {
    getBrowser().sessionHistory;
  } catch(e) {
    webNavigation.sessionHistory = Components.classes["@mozilla.org/browser/shistory;1"]
                                             .createInstance(Components.interfaces.nsISHistory);
  }

  var interfaceRequestor = getBrowser().docShell.QueryInterface(Components.interfaces.nsIInterfaceRequestor);
  var webProgress = interfaceRequestor.getInterface(Components.interfaces.nsIWebProgress);

  gSession = webNavigation;


  webProgress.addProgressListener(gBrowserStatusHandler,
                                    Components.interfaces.nsIWebProgress.NOTIFY_LOCATION);
}

 function createBackMenu(event)
 {
   return FillHistoryMenu(event.target, "back");
 }
 
 function createForwardMenu(event)
 {
   return FillHistoryMenu(event.target, "forward");
 }
 
 function gotoHistoryIndex(aEvent)
 {
   var index = aEvent.target.getAttribute("index");
   if (!index)
     return false;
   try {
     getWebNavigation().gotoIndex(index);
   }
   catch(ex) {
     return false;
   }
   return true;
 }

function MiniNavShutdown()
{
  dump("*** MiniNavShutdown\n");
  if (gBrowserStatusHandler)
    gBrowserStatusHandler.destroy();
}

function getBrowser()
{
  if (!gBrowser)
    gBrowser = document.getElementById("content");
  return gBrowser;
}

function getWebNavigation()
{
  if (!gSession) {
    gSession = getBrowser().webNavigation;
  }
  return gSession;
}

function UpdateBackForwardButtons()
{
  var backBroadcaster = document.getElementById("canGoBack");
  var forwardBroadcaster = document.getElementById("canGoForward");
  var webNavigation = getWebNavigation();
 
  // Avoid setting attributes on broadcasters if the value hasn't changed!
  // Remember, guys, setting attributes on elements is expensive!  They
  // get inherited into anonymous content, broadcast to other widgets, etc.!
  // Don't do it if the value hasn't changed! - dwh
 
  var backDisabled = (backBroadcaster.getAttribute("disabled") == "true");
  var forwardDisabled = (forwardBroadcaster.getAttribute("disabled") == "true");
 
  if (backDisabled == webNavigation.canGoBack) {
    if (backDisabled)
       backBroadcaster.removeAttribute("disabled");
    else
       backBroadcaster.setAttribute("disabled", true);
  }
   
  if (forwardDisabled == webNavigation.canGoForward) {
    if (forwardDisabled)
       forwardBroadcaster.removeAttribute("disabled");
    else
       forwardBroadcaster.setAttribute("disabled", true);
  }
}

function BrowserBack()
{
  getWebNavigation().goBack();
  UpdateBackForwardButtons();
}

function BrowserForward()
{
  getWebNavigation().goForward();
  UpdateBackForwardButtons();
}

function BrowserStop()
{
  getWebNavigation().stop(nsIWebNavigation.STOP_ALL);
}

function BrowserReload()
{
  getWebNavigation().reload(nsIWebNavigation.LOAD_FLAGS_NONE);
}
