/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  	Martijn Pieters <mj@digicool.com> 
 *      for toBase64() copied from 
 *      mozilla\extensions\xml-rpc\src\nsXmlRpcClient.js
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gIOService;
var gDataReceived = null;
var gImageData = [];
var gAuthenticationUrl;
var gNewAccountUrl;
var gSuggestSnUrl;
var gReadUrl;
var gWriteUrl;
var gForgottenPwdUrl;
var gSetUserBrandUrl;
var gAgeSuspendUrl;
var gCreditCardValidationUrl;
var gGetRegImageUrl;
var gCurrentPageDefined;
var gStartInPage;
var gCategory;
var gCloseProgressMeter = false;
var gEntryPoint;
var gCurrentErrorMsg;
var gAuthToken;
var gSnToken;
var gCcToken;
var gWroteInfo = false;
var gReadInfo = false;
var gUserBrandIsSet = false;
var gFailedToCreateWebMailAccount = false;
var gCollectDataFromExistingMember = false;
var gSNSEntryCreated = false;
var gPingedForExistingInfo = false;
var gMigratedUserScreenName;
var gFirstName;
var gLastName;
var gSiteIdPerActivationSchema;
var gFinalSideBarPanel;
var gNetscapeNetworkFlag;
var gPayingMember = false;
var gAgeSuspended = false;
var gAgeSuspendedPlus = false;
var gAgeSuspendedSet = false;
var gNumOfCredits = 0;
var gValidate;
var gNetscapeNetworkSite;
var gSetAgeSuspend = false;
var gWroteAgeData = false;
var gScreenName;
var gCreditPageCancelled = false;
var gExistingAccountDOBYear;
var gExistingAccountDOBMonth;
var gExistingAccountDOBDay; 
var gExistingAccountZip;
var gExistingAccountCountry;
var gExistingAccountGender;

const kPostMethod = "POST";
const kGetMethod = "GET";
const kScreennameNamespace = "0-9a-zA-Z";
const kNetscapeNetworkBrand = "NETSCAPE-NETWORK";

var strBundleService = Components.classes["@mozilla.org/intl/stringbundle;1"].getService(); 
strBundleService = strBundleService.QueryInterface(Components.interfaces.nsIStringBundleService);

var activationStrBundle = strBundleService.createBundle("chrome://communicator/locale/profile/activation.properties");

function PostData(destinationDirectoryLocation, data)
{
  gActivationListener(destinationDirectoryLocation, data, kPostMethod);
}

function getIOService()
{
  if (gIOService)
    return gIOService;

  gIOService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  return gIOService;
}

function get_uri(url)
{
  var nsiuri = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
  nsiuri.spec = url;
  return nsiuri;
}

function post_data_to_server(newLocation, data, pingMethod)
{
  try
  {
    // Set up channel.
    var ioService = getIOService();

    var uri = get_uri(newLocation);

    var chann = ioService.newChannelFromURI(uri)
        .QueryInterface(Components.interfaces.nsIHttpChannel);

    if (pingMethod == kPostMethod) {
      // Create a stream out of the request and attach it to the channel
      var upload = chann.QueryInterface(Components.interfaces.nsIUploadChannel);
      var postStream = createInstance('@mozilla.org/io/string-input-stream;1',
          'nsIStringInputStream');


      if (!gSiteIdPerActivationSchema)
        gSiteIdPerActivationSchema = activationStrBundle.GetStringFromName("defaultSiteId");

      chann.setRequestHeader("SNS-SITEID", gSiteIdPerActivationSchema, false);

      // get the charset
      var charset = activationStrBundle.GetStringFromName("charset");

      if (!data) {
        data = "siteId=" + escape(gSiteIdPerActivationSchema) + "&charset=" + escape(charset);
        chann.setRequestHeader("HTTP-COOKIE", document.cookie, true);
      }
      else {
        // Add charset to the data we are posting
        data += "&siteId=" + escape(gSiteIdPerActivationSchema) + "&charset=" + escape(charset);
      }

      //dump("XXX " + newLocation + " " + data + "\n");
      postStream.setData(data, data.length);
      var cookieString = document.cookie;

      upload.setUploadStream(postStream, 'application/x-www-form-urlencoded', -1);
    }

    chann.requestMethod = pingMethod;

    chann.notificationCallbacks = gProgressNotifications;

    chann.asyncOpen(gActivationListener, null);
  }
  catch (e)
  {
  }
}

var gActivationListener =
{
  QueryInterface: function(aIId, instance)
  {
    if (aIId.equals(Components.interfaces.nsIStreamListener))
      return this;
    if (aIId.equals(Components.interfaces.nsISupports))
      return this;
    
    throw Components.results.NS_NOINTERFACE;
  },

  onStartRequest: function(request, ctxt)
  {
    gImageData = [];
    gDataReceived = "";
    gCloseProgressMeter = false;
  },

  onStopRequest: function(request, ctxt, status, errorMsg)
  {
    var currPage;
    var screenNames;
    var statusArray;
    var isExistingAccount = false;
    var isValidAccount = false;
    var errorCode;
    var cookieCheckInvalid = false;
    var coppaViolation = false;
    var invalidCreditCard = false;
    gMismatchedImageWord = false;
 
    try {
      if (gCurrentPageDefined)
        currPage = gCurrentPageDefined;
      else
        currPage = document.documentElement.currentPage.id;
    }
    catch (ex) {
    }
    
    // if there was no data (gImageData.length == 0)
    // we should send the user to the "Try Again Later" page
    if (currPage == "ispPage17" && gImageData.length)
    {
      // if the image data is really an error code
      // like "rc=304", we need to handle it differently
      if (gImageData[0] == 114 &&
          gImageData[1] == 99 &&
          gImageData[2] == 61)
      {
        // convert the bytes into a string
        gDataReceived = "";
        for (i=0;i<gImageData.length;i++)
        {
          gDataReceived += String.fromCharCode(gImageData[i]);
        }
      }
      else  
      {
        var imageWordImg = document.getElementById("imageWordImg");
        imageWordImg.setAttribute("src", "data:image/gif;base64," + toBase64(gImageData));
        // fake the "rc=0"
        gDataReceived = "rc=0";
      }
    }

    // Network transaction is over. Time to close the progress dialog
    //gCloseProgressMeter = true;
    if (gDataReceived && currPage) {
      // There are 2 cases when we come here.
      // 1. MainStream Activation beginning
      // 2. DownStream Activation beginning
      //    a. From Mailnews
      //    b. From IM
      //    c. From other points in Navigator
      if (currPage == "activationStartWindow" || 
          currPage == "ispPage1" || 
          gEntryPoint == "downstreamActivation") {
        gEntryPoint = null;
        var value = extractReturnValue("rc", true);
        if (value == 0) {
          gAuthenticationUrl = extractReturnValue("authUrl", true);
          gNewAccountUrl = extractReturnValue("newSnUrl", true);
          gReadUrl = extractReturnValue("readUrl", true);
          gWriteUrl = extractReturnValue("writeUrl", true);
          gForgottenPwdUrl = extractReturnValue("forgottenPwdUrl", true);
          gSuggestSnUrl = extractReturnValue("suggestSnUrl", true);
          gSetUserBrandUrl = extractReturnValue("setUserBrandUrl", true);
          gAgeSuspendUrl = extractReturnValue("ageSuspendUrl", true);
          gCreditCardValidationUrl = extractReturnValue("creditCardValidationUrl", true);
          gGetRegImageUrl = extractReturnValue("getRegImageUrl", true);
        }
        else { 
          if (currPage == "activationStartWindow" && !gPingedForExistingInfo && !gReadInfo) {
            var progressWindow = getProgressDialog(currPage);
            if (progressWindow) 
              progressWindow.close();
          }
          else if (currPage != "activationStartWindow") {
            gCloseProgressMeter = true;
            setAllHandlersForPageAdvance();
            try {
            gCurrentErrorMsg = activationStrBundle.GetStringFromID(value);
            }
            catch (ex) {
              // possbily hit an undefined error case
              gCurrentErrorMsg = activationStrBundle.GetStringFromName("unknownError");
            }

            document.documentElement.advance("ispPage10");
          }
        }

        // Set the next pages from here
        switch (currPage) {
          case "activationStartWindow" :
            // based on what you find here, 
            // you have to jump to the right page in the wizard sequence
            // We always start with an existing account scenario in the process
            // of mainstream registration. For downstream registration, coming from
            // menuitem which has no wizard base, we need to start in new account page.
            if (gStartInPage && gStartInPage == "ispPage4") {
              if (gCategory) {
                switch (gCategory) {
                  case "globalHelp:registerNetscape" :
              setNewAccountGlobals();
              window.openDialog("chrome://communicator/content/profile/newactivation.xul",
                                "Activation", "chrome,titlebar,resizable=no,centerscreen,dialog=no", 
                                {page:gStartInPage, origin:currPage, newaccturl:gNewAccountUrl,
                                 authurl:gAuthenticationUrl, readurl:gReadUrl, writeurl:gWriteUrl, 
                                 forgotpwdurl:gForgottenPwdUrl,suggestsnurl:gSuggestSnUrl,
                                 setbrandurl:gSetUserBrandUrl,agesuspendurl:gAgeSuspendUrl,
                                 creditvalidurl:gCreditCardValidationUrl,gFinalSideBarPanel:"search",
                                 getregimageurl:gGetRegImageUrl}, this);
                    break;
                  case "messenger:getFreeAccount" :
                    setNewAccountGlobals();
                    window.openDialog("chrome://messenger/content/AccountWizard.xul",
                                      "AccountWizard", "chrome,titlebar,resizable,centerscreen", 
                                      {page:gStartInPage, origin:currPage, newaccturl:gNewAccountUrl,
                                       authurl:gAuthenticationUrl, readurl:gReadUrl, writeurl:gWriteUrl, 
                                       forgotpwdurl:gForgottenPwdUrl,suggestsnurl:gSuggestSnUrl,setbrandurl:gSetUserBrandUrl,
                                       agesuspendurl:gAgeSuspendUrl,creditvalidurl:gCreditCardValidationUrl,
                                       getregimageurl:gGetRegImageUrl}, this);
                    break;
                  default :
                    break;
                }
              }
            }
            else {
            if ("setExistingAccountGlobals" in this) 
              setExistingAccountGlobals();
            if("gPingedForExistingInfo" in this  && !gPingedForExistingInfo)  {
              gPingedForExistingInfo = true;
              var charset = activationStrBundle.GetStringFromName("charset");
              post_data_to_server(gAuthenticationUrl, null, kPostMethod, charset);
            }
            else if ("gReadInfo" in this && !gReadInfo) {
              gReadInfo = true;
              var charset = activationStrBundle.GetStringFromName("charset");
              post_data_to_server(gReadUrl, ("authToken="+ gAuthToken + 
                                             "&user_name_first&user_name_last&user_gender" + 
                                             "&user_home_postal_postalcode&user_home_postal_countrycode" + 
                                             "&user_bdate_ymd_year&user_bdate_ymd_month&user_bdate_ymd_day" +
                                             "&user_nscp_network_member"), kPostMethod, charset);
            }
            else {
              if ("extractReturnValue" in this) {
                gMigratedUserScreenName = extractReturnValue("user_screenname", true);
                gFirstName = extractReturnValue("user_name_first", true);
                gLastName = extractReturnValue("user_name_last", true);
              }

              var startPage = "ispPage3";
              if (gCategory == "messenger:setupExistingAccount") {
                window.openDialog("chrome://messenger/content/AccountWizard.xul",
                                  "Activation", "chrome,titlebar,resizable=no,centerscreen,dialog=no", null, 
                                {page:gStartInPage, origin:currPage, newaccturl:gNewAccountUrl,
                                 authurl:gAuthenticationUrl, readurl:gReadUrl, writeurl:gWriteUrl, 
                                 forgotpwdurl:gForgottenPwdUrl,suggestsnurl:gSuggestSnUrl,
                                 setbrandurl:gSetUserBrandUrl,agesuspendurl:gAgeSuspendUrl,
                                 creditvalidurl:gCreditCardValidationUrl,gFinalSideBarPanel:"search",
                                 getregimageurl:gGetRegImageUrl}, this);
              }
              else
              window.openDialog("chrome://communicator/content/profile/newactivation.xul",
                                "Activation", "chrome,titlebar,resizable=no,centerscreen,dialog=no", 
                                {page:startPage, origin:currPage, newaccturl:gNewAccountUrl,
                                 authurl:gAuthenticationUrl, readurl:gReadUrl, writeurl:gWriteUrl, 
                                 forgotpwdurl:gForgottenPwdUrl,suggestsnurl:gSuggestSnUrl,setbrandurl:gSetUserBrandUrl,
                                 agesuspendurl:gAgeSuspendUrl,creditvalidurl:gCreditCardValidationUrl,
                                 collectedScreenName:gMigratedUserScreenName, collectedFirstName:gFirstName,
                                 collectedLastName:gLastName, getregimageurl:gGetRegImageUrl}, this);
            }
            }
            return;
          case "ispPage1" :
            // based on what you find here, 
            // you have to jump to the right page in the wizard sequence
            // For now, let's go to the standard start page.
            gAcctTypeOnPageHandlerKicked = true;
            gCloseProgressMeter = true;
            if (gExistingAccount)
              document.documentElement.advance("ispPage3");
            else
              document.documentElement.advance("ispPage4");
            return;
          default :
            gCloseProgressMeter = true;
            gAcctTypeOnPageHandlerKicked = true;
            if (gExistingAccount)
              document.documentElement.advance("ispPage3");
            else
              document.documentElement.advance("ispPage4");
            break;
        }
      }
      else {
        if (gDataReceived) {
          // Get status of the transaction
          var value = extractReturnValue("rc", true);
            switch (parseInt(value)) { 
              // SNS APIs returned a successful tranasaction code (rc=0) for a 
              // requested operation on a given account. Examples include, 
              // API authenticated the existing user's Screen Name and password, 
              // user's information could be read from/written to SNS database.
              case 0 : 
                isValidAccount = true;
                break;

              // SNS APIs returned a code (rc=216) that indicates that user has tried
              // to create a new Screen Name and that Screen Name is already 
              // taken. Client need to serve a page with alternative Screen Names.
              case 216 : 
                isExistingAccount = true;
                break;

              // SNS APIs checked existing user cookies and got back saying that existing
              // SNS cookies are invalid or expired. So, we need to ask users for Screen Name
              // and password and do the authentication.
              case 210 : 
              case 215 : 
                cookieCheckInvalid = true;
                break;

              // SNS APIs returned an error trying to process user's request.
              // For list of error codes, please refer to 
              // http://lxr/commercial/source/profile/resources/locale/en-US/activation.properties

               // we get this error when en-us user is under 13.
               case 214 :
                 coppaViolation = true;
                 errorCode = value;
                 break;

               // User is under 13 years(age suspended) and 30 days has not passed 
               // since he was age suspended.
               case 231:
                 gAgeSuspended = true;
                 break;

              // User is under 13 years(age suspended) and 30 days have passed 
              // since he was age suspended.
              case 232:
                gAgeSuspendedPlus = true;
                break;

              // the credit card information entered is not valid
              case 233:
                invalidCreditCard = true;
                break;

              // the word the user typed did not match the image
              case 303:
                gMismatchedImageWord = true;
                errorCode = value;
                break;
			    
              default :
                errorCode = value;
                break;
            }

          // Check for additional data
          // Get AuthToken
          var authToken = extractReturnValue("authToken", false);
          if (authToken) {
            // Be careful. Strip of that new line character.
            realToken = authToken.split("\n");
            gAuthToken = escape(realToken[0]);
          }

          // Get screennames, if any
          var screenNameData = extractReturnValue("screennames", true);
          if (screenNameData) {
            gAlternateNamesReceived = true;
            isExistingAccount = true;
            screenNames = screenNameData.split(" ");
          }

          // Get user first name
          if (!gFirstName) {
            gFirstName = extractReturnValue("user_name_first", true);
          }

          // Get user last name
          if (!gLastName) {
            gLastName = extractReturnValue("user_name_last", true);
          }

          // Get user gender
          if (!gExistingAccountGender) {
            gExistingAccountGender = extractReturnValue("user_gender", true);
          }

          // Get user's zipcode
          if (!gExistingAccountZip) {
            gExistingAccountZip = extractReturnValue("user_home_postal_postalcode", true);
          } 
          
          // Get user's countrycode
          if (!gExistingAccountCountry) {
            gExistingAccountCountry = extractReturnValue("user_home_postal_countrycode", true);
          }

          // Get user's dob year
          if (!gExistingAccountDOBYear) {
            gExistingAccountDOBYear = extractReturnValue("user_bdate_ymd_year", true);
          }

          // Get user's dob month
          if (!gExistingAccountDOBMonth) {
            gExistingAccountDOBMonth = extractReturnValue("user_bdate_ymd_month", true);
          }

          // Get user's dob day
          if (!gExistingAccountDOBDay) {
            gExistingAccountDOBDay = extractReturnValue("user_bdate_ymd_day", true);
          }

          // Get the netscape network flag
          if (!gNetscapeNetworkFlag) {
            gNetscapeNetworkFlag = extractReturnValue("user_nscp_network_member", true);
          }
          
          // if this a AOL/CS paying member
          if (!gPayingMember) {
            gPayingMember = extractReturnValue("payingMember", true);
          }

          if (gAgeSuspended || gAgeSuspendedPlus)
          {
            if (!gSnToken) {
              var snToken = extractReturnValue("snToken", false);
              if (snToken) {
                // Be careful. Strip of that new line character.
                gSnToken = escape(snToken.split("\n")[0]);
              }
            }
          }

          // Get ccToken
          var ccToken = extractReturnValue("ccToken", false);
          if (ccToken) {
            // Be careful. Strip of that new line character.
            gCcToken = escape(ccToken.split("\n")[0]);
          }

          if ((currPage == "ispPage5") && coppaViolation)
            gSetAgeSuspend = true;
        }

        if (isValidAccount || isExistingAccount || gSNSEntryCreated ||
            gAgeSuspended || gAgeSuspendedPlus || gSetAgeSuspend || invalidCreditCard) {
          
          switch (currPage) {
            case "ispPage17" :
              gCloseProgressMeter = true;
              break;
            case "ispPage2"  :
              if (gNewAccount) {
                // Assuming that user has valid record in the database, 
                // let's move onto the next page
                gNewAcctHandlerKicked = true;

                if (isExistingAccount) {
                  if (gAlternateNamesReceived) {
                    setAltScreenNameAsLabels(screenNames);
                    setNextPage("ispPage6", gEndPageId);
                    gCloseProgressMeter = true;
                    document.documentElement.advance("ispPage6");
                  }
                  else {
                    gCloseProgressMeter = false;
                    var hints = gNewAccountScreenName + " " + ReduceToNamespace(gNewAccountUserFullName, kScreennameNamespace);
                    post_data_to_server(gSuggestSnUrl, "hints="+hints, kPostMethod);
                  }
                }
                else if (isValidAccount || gSNSEntryCreated) {
                  // all is good, proceed with new screen name
                  gAlternateNamesReceived = false;
                  gUserFullName = gNewAccountUserFullName;
                  gScreenName = gNewAccountScreenName;
                  gPassword = gNewAccountPassword;
                  gEmailAddress = gScreenName + '@' + kWebMailDomain;
                  gSNSEntryCreated = true;

                  // Time to set the Netscape Network flag for this new member. If this API 
                  // is not supported for a given siteId, the registration process continues 
                  // with the next step i.e., writing the data collected to the database.
                  if (!gUserBrandIsSet) {
                    gCloseProgressMeter = false;
                    gUserBrandIsSet = true;
                    post_data_to_server(gSetUserBrandUrl, ("authToken="+ gAuthToken + 
                                                           "&brand="+kNetscapeNetworkBrand), kPostMethod);
                  }

                 // Get back to writeUrl after figuring out the 
                  // token problem
                  if (!gWroteInfo) {
                    gCloseProgressMeter = false;
                    gWroteInfo = true;
                    post_data_to_server(gWriteUrl, ("authToken="+ gAuthToken + 
                                                  "&user_gender="+gNewAccountGender+ 
                                                  "&user_home_postal_postalcode="+gNewAccountZip+ 
                                                  "&user_home_postal_countrycode="+gNewAccountCountry), kPostMethod);
                  }
                  else
                    pingWebMailServer("hiddenWindow1");
                }
              }
              else if (gExistingAccount) {
                // Assuming that user has valid record in the database, 
                // let's move onto the next page
                gUserFullName = existingAccountUserName;
                gScreenName = existingAccountScreenName;
                gPassword = existingAccountPassword;
                gEmailAddress = gScreenName + '@' + kWebMailDomain;

                // Time to set the Netscape Network flag for this existing member who is not a 
                // member of Netscape Netwrok yet. If this API is not supported for a given siteId, 
                // the registration process continues with the next step i.e., getting user name
                // OR getting Webmail account.
                if (!gUserBrandIsSet) {
                  gCloseProgressMeter = false;
                  gUserBrandIsSet = true;
                  post_data_to_server(gSetUserBrandUrl, ("authToken="+ gAuthToken + 
                                                         "&brand="+kNetscapeNetworkBrand+
                                                         "&hand=1"), kPostMethod);
                }
                
                if (document.documentElement.id == "migWiz") {
                  gCloseProgressMeter = true;
                  gExistingAccountOnPageHandlerKicked = true;
                  setNextPage("ispPage2", gEndPageId);
                  document.documentElement.advance(gEndPageId);
                }
                else {
                  if (!(gFirstName || gLastName)) {
                    gCloseProgressMeter = true;
                    gExistingAccountOnPageHandlerKicked = true;
                    setNextPage("ispPage2", "ispPage7");
                    setNextPage("ispPage7", gEndPageId);
                    document.documentElement.advance("ispPage7");
                  }
                  else {
                    setUpUserFullName();
                    pingWebMailServer("hiddenWindow1");
                  }
                }
              }
              break;
            case "ispPage3"  :
              // Time to check if the user has Netscape Network flag
              // and send them to appropriate wizard page
              gScreenName = existingAccountScreenName;
              gPassword = existingAccountPassword;
              gEmailAddress = gScreenName + '@' + kWebMailDomain;
              gSNSEntryCreated = true;

              if (gAgeSuspendedPlus || gAgeSuspended) {
                if (gAgeSuspendedPlus) {
                  gCloseProgressMeter = true;
                  gExistingAccountOnPageHandlerKicked = true;
                  if (gValidate == "true")
                    document.documentElement.advance("ispPage14");
                  else
                    document.documentElement.advance("ispPage16");
                }
                else {
                  if (gValidate == "true")
                  {
                    gCloseProgressMeter = true;
                    gExistingAccountOnPageHandlerKicked = true;
                    setNextPage("ispPage3", "ispPage12");
                    setNextPage("ispPage12", "ispPage2");
                    document.documentElement.advance("ispPage12");
                  }
                  else {
                    gCloseProgressMeter = true;
                    gExistingAccountOnPageHandlerKicked = true;
                    setNextPage("ispPage3", "ispPage16");
                    document.documentElement.advance("ispPage16");
                  }
                }
              }
              else {
                if (!gReadInfo) {
                  gCloseProgressMeter = false;
                  gReadInfo = true;
                  post_data_to_server(gReadUrl, ( "authToken="+ gAuthToken + 
                                               "&user_name_first&user_name_last&user_gender" + 
                                               "&user_home_postal_postalcode&user_home_postal_countrycode" + 
                                               "&user_bdate_ymd_year&user_bdate_ymd_month&user_bdate_ymd_day" +
                                               "&user_nscp_network_member"), kPostMethod);
                }
                else {
                  // If the user is AOL/CS paying member, go to the end page.
                  // If the user has ever registered with Netscape Network,
                  // his/her record in UMP will have Netscape Network bit
                  // set to 'y'. So, check if the user has already registered.
                  // If so, skip terms page. Otherwise, start with collecting 
                  // user information and move on.
                  // For sites that are not part of the netscape network check if
                  // we have all the data. If all the info exists we do not have to
                  // collect the information.
                  if (gPayingMember=="1" || gNetscapeNetworkFlag == "y" || 
                     ((gNetscapeNetworkSite == "false") && (gExistingAccountDOBYear && gExistingAccountDOBMonth && 
                      gExistingAccountDOBDay && gExistingAccountZip && gExistingAccountCountry && gExistingAccountGender))) 
                  {
                    if (document.documentElement.id == "migWiz") {
                      gCloseProgressMeter = true;
                      gExistingAccountOnPageHandlerKicked = true;
                      setNextPage("ispPage3", gEndPageId);
                      document.documentElement.advance(gEndPageId);
                    }
                    else {
                    if (!(gFirstName || gLastName)) {
                      gCloseProgressMeter = true;
                      gExistingAccountOnPageHandlerKicked = true;
                      if (document.documentElement.id == "migWiz") {
                        setNextPage("ispPage3", gEndPageId);
                        document.documentElement.advance(gEndPageId);
                      }
                      else {
                        setNextPage("ispPage3", "ispPage7");
                        setNextPage("ispPage7", gEndPageId);
                        document.documentElement.advance("ispPage7");
                      }
                    }
                    else {
                      setUpUserFullName();
                      pingWebMailServer("hiddenWindow4");
                    }
                  }
                  }
                  else {
                    // If the user has not registered, get user details
                    // again and follow the regular path of an existing
                    // member.
                     gCloseProgressMeter = true;
                     gExistingAccountOnPageHandlerKicked = true;
                     gCollectDataFromExistingMember = true;
                     setNextPage("ispPage3", "ispPage5");
                     setNextPage("ispPage5", "ispPage17");
                     setNextPage("ispPage17", "ispPage2");
                     if (document.documentElement.id == "migWiz")
                       setNextPage("ispPage2", gEndPageId);
                     else {
                       setNextPage("ispPage2", "ispPage7");
                       setNextPage("ispPage7", gEndPageId);
                     }
                     document.documentElement.advance("ispPage5");
                   }
                }
              }
              break;
            case "ispPage5"  :
             if (gExistingAccount)
             {
               // if user is under age the we need to set the agesuspend bit to 1
               // if gValidate = false we dont have to set the bit
               if (gValidate == "true" && gSuspendAge && gSetAgeSuspend) {
                 gSetAgeSuspend = false;
                 gCloseProgressMeter = false;
                 post_data_to_server(gAgeSuspendUrl, ("authToken=" + gAuthToken + 
                                                      "&agesuspend=1"), kPostMethod);
                }
                else {
                  gSetAgeSuspend = false;
                  if (!gWroteAgeData) {
                    if (gSuspendAge) { //user age < age limit
                      gWroteAgeData = true;
                      gCloseProgressMeter = true;
                      if (gValidate == "true") { 
                        setNextPage("ispPage5", "ispPage12");
                        document.documentElement.advance("ispPage12");
                      }
                      else { // do not validate. just block
                        setNextPage("ispPage5", "ispPage16");
                        document.documentElement.advance("ispPage16");
                      }
                    }
                  }
                }
              }
              break;
            case "ispPage6"  :
              // Assuming that user has valid record in the database, 
              // let's move onto the next page

              if (isExistingAccount) {
                if (gAlternateNamesReceived) {
                  gAlternateNamesReceived = false;
                  gCloseProgressMeter = true;
                  setAltScreenNameAsLabels(screenNames);
                  gScreenNamesOnPageHandlerKicked = false;
                }
                else {
                  gAlternateNamesReceived = false;
                  isExistingAccount = false;
                  gCloseProgressMeter = false;
                  var hints = gNewAccountScreenName + " " + ReduceToNamespace(gNewAccountUserFullName, kScreennameNamespace);
                  post_data_to_server(gSuggestSnUrl, "hints="+hints, kPostMethod);
                }
              }
              else if (isValidAccount || gSNSEntryCreated) {
                // all is good, proceed with new screen name
                gAlternateNamesReceived = false;
                gUserFullName = gNewAccountUserFullName;
                gScreenName = gNewAccountScreenName;
                gPassword = gNewAccountPassword;
                gEmailAddress = gScreenName + '@' + kWebMailDomain;
                gScreenNamesOnPageHandlerKicked = true;
                gSNSEntryCreated = true;

                // Time to set the Netscape Network flag for this new member. If this API 
                // is not supported for a given siteId, the registration process continues 
                // with the next step i.e., writing the data collected to the database.
                if (!gUserBrandIsSet) {
                  gCloseProgressMeter = false;
                  gUserBrandIsSet = true;
                  post_data_to_server(gSetUserBrandUrl, ("authToken="+ gAuthToken + 
                                                         "&brand="+kNetscapeNetworkBrand), kPostMethod);
                }

                // Get back to writeUrl after figuring out the 
                // token problem
                if (!gWroteInfo) {
                  gCloseProgressMeter = false;
                  gWroteInfo = true;
                  post_data_to_server(gWriteUrl, ("authToken="+ gAuthToken + 
                                                  "&user_gender="+gNewAccountGender+ 
                                                  "&user_home_postal_postalcode="+gNewAccountZip+ 
                                                  "&user_home_postal_countrycode="+gNewAccountCountry+
                                                  "&user_bdate_ymd_year="+gNewAccountDOBYear+
                                                  "&user_bdate_ymd_month="+gNewAccountDOBMonth+
                                                  "&user_bdate_ymd_day="+gNewAccountDOBDay), kPostMethod);
                }
                  else {
                  pingWebMailServer("hiddenWindow2");
              }
              }
              break;
            case "ispPage8"  :
              setNextPage("ispPage8", "ispPage9");
              gCloseProgressMeter = true;
              gForgotPwdHandlerKicked = true;
              document.documentElement.advance("ispPage9");
              break;
            case "ispPage12" :
              // only allow the user to try 5 times in a session
              if (invalidCreditCard) {
                gNumOfCredits++;
                if (gNumOfCredits >= 5) {
                  gCloseProgressMeter = true;
                  gCreditLimitPassed = true;
                  document.documentElement.advance("ispPage15");
                }
                else {
                  // if we do not close the progressdialog like this
                  // showErrorMsg is getting called before we close progressdialog
                  // and when we close errormsg dialog, the focus is not on the wizard.
                  var progressWindow = getProgressDialog("progressWindow");
                  if (progressWindow)
                    progressWindow.close();
                  showErrorMsg("invalidCredit");
                }
              }
              else {
                // if the credit card information is valid set the Netscape network flag.
                if (!gNNFlagSet) {
                  gCloseProgressMeter = false;
                  gNNFlagSet = true;
                  if (gSnToken)
                    post_data_to_server(gAgeSuspendUrl, ("snToken=" + gSnToken +
                                                       "&ccToken=" + gCcToken + 
                                                       "&agesuspend=0" +
                                                       "&sns_bit=1"), kPostMethod);
                  else {
                    post_data_to_server(gAgeSuspendUrl, ("authToken=" + gAuthToken +
                                                       "&ccToken=" + gCcToken + 
                                                       "&agesuspend=0" +
                                                       "&sns_bit=1"), kPostMethod);
                  }
                }
                else {
                  // we may not have the authtoken since we got error 231 the first time we called
                  // gAuthenticationUrl
                  if (!gAuthToken) {
                    gCloseProgressMeter = false;
                    post_data_to_server(gAuthenticationUrl, ("screenname="+escape(gScreenName)+
                                                             "&password="+escape(gPassword)), kPostMethod);
                  }
                  else {
                    if (!gReadInfo) {
                      gCloseProgressMeter = false;
                      gReadInfo = true;
                      post_data_to_server(gReadUrl, ( "authToken="+ gAuthToken + 
                                             "&user_name_first&user_name_last&user_gender" + 
                                             "&user_home_postal_postalcode&user_home_postal_countrycode" + 
                                             "&user_bdate_ymd_year&user_bdate_ymd_month&user_bdate_ymd_day" +
                                             "&user_nscp_network_member"), kPostMethod);
                    }
                    else {
                      gExistingAccountOnPageHandlerKicked = true;
                      if (document.documentElement.id == "migWiz")
                      {
                        gCloseProgressMeter = true;
                        gCreditLimitPassed = true;
                        setNextPage("ispPage2", gEndPageId);
                        document.documentElement.advance("ispPage2");
                      }
                      else {
                      if (!(gFirstName || gLastName)) {
                        gCloseProgressMeter = true;
                        gCreditLimitPassed = true;
                        setNextPage("ispPage2", "ispPage7");
                        setNextPage("ispPage7", gEndPageId);
                        document.documentElement.advance("ispPage2");
                      }
                      else {
                        setUpUserFullName();
                        pingWebMailServer("hiddenWindow6");
                      }
                      }
                    }
                  }
                }
              }
              break;
            case "ispPage14" :
              if (!gNotAvailableWritten) {
                gNotAvailableWritten = true;
                gCloseProgressMeter = true;
              } 
              break;
            default :
              // go to error page
              break;
          }
        }
        else {
          // go to error page
          if (currPage == "activationStartWindow") {
            var progressWindow = getProgressDialog(currPage);
            if (progressWindow) 
              progressWindow.close();
          }
          else {
            gCloseProgressMeter = true;
            setAllHandlersForPageAdvance();
            try {
              gCurrentErrorMsg = activationStrBundle.GetStringFromID(errorCode);
            }
            catch (ex) {
              // possbily hit an undefined error case
              gCurrentErrorMsg = activationStrBundle.GetStringFromName("unknownError");
            }
            document.documentElement.advance("ispPage10");
          }
        }
      }
    }
    else {
      // go to error page
      if (currPage == "activationStartWindow") {
        var progressWindow = getProgressDialog(currPage);
        if (progressWindow) 
          progressWindow.close();
      }
      else {
        gCloseProgressMeter = true;
        setAllHandlersForPageAdvance();
        gCurrentErrorMsg = activationStrBundle.GetStringFromName("couldNotConnectToServer");
        document.documentElement.advance("ispPage10");
      }
    }
  },

  onDataAvailable: function(request, ctxt, inStream, sourceOffset, count)
  {
    var currPage;
    try {
      if (gCurrentPageDefined)
        currPage = gCurrentPageDefined;
      else
        currPage = document.documentElement.currentPage.id;
    }
    catch (ex) {
    }
    
    if (currPage == "ispPage17")
    {
      var sstream = Components.classes["@mozilla.org/binaryinputstream;1"];
      sstream = sstream.createInstance(Components.interfaces.nsIBinaryInputStream);
      sstream.setInputStream(inStream);
      gImageData = gImageData.concat(sstream.readByteArray(count));
    }
    else
    {
      var SIStream = Components.Constructor(
      '@mozilla.org/scriptableinputstream;1',
      'nsIScriptableInputStream', 'init');
      var scriptableStream = new SIStream(inStream);
      gDataReceived += scriptableStream.read(count);
    }
  }
}

/* XXX copied from mozilla\extensions\xml-rpc\src\nsXmlRpcClient.js, is this an issue? */
/* Convert data (an array of integers) to a Base64 string. */
const toBase64Table = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz' +
    '0123456789+/';
const base64Pad = '=';
function toBase64(data) {
    var result = '';
    var length = data.length;
    var i;
    // Convert every three bytes to 4 ascii characters.
    for (i = 0; i < (length - 2); i += 3) {
        result += toBase64Table[data[i] >> 2];
        result += toBase64Table[((data[i] & 0x03) << 4) + (data[i+1] >> 4)];
        result += toBase64Table[((data[i+1] & 0x0f) << 2) + (data[i+2] >> 6)];
        result += toBase64Table[data[i+2] & 0x3f];
    }

    // Convert the remaining 1 or 2 bytes, pad out to 4 characters.
    if (length%3) {
        i = length - (length%3);
        result += toBase64Table[data[i] >> 2];
        if ((length%3) == 2) {
            result += toBase64Table[((data[i] & 0x03) << 4) + (data[i+1] >> 4)];
            result += toBase64Table[(data[i+1] & 0x0f) << 2];
            result += base64Pad;
        } else {
            result += toBase64Table[(data[i] & 0x03) << 4];
            result += base64Pad + base64Pad;
        }
    }

    return result;
}

var gProgressNotifications =
{
  getInterface: function(aIId, instance)
  {
    if (aIId.equals(Components.interfaces.nsIProgressEventSink))
      return this;
    if (aIId.equals(Components.interfaces.nsISupports))
      return this;

	if (aIId.equals(Components.interfaces.nsIHttpEventSink))
	{  
	  dump("is this exception expected?\n")
	  dump("see http://lxr.mozilla.org/mozilla/source/netwerk/protocol/http/public/nsIHttpEventSink.idl#49\n");
	}  
	
    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  onStatus: function(request, ctxt, status, statusText)
  {
    // DecToHex gets last 2 digits of hex.
    // Applying HexToDec on that will give us the code we are looking for.
    var decodedStatus = HexToDec(DecToHex(status));

    var currPage;
    try {
      if (gCurrentPageDefined)
        currPage = gCurrentPageDefined;
      else
        currPage = document.documentElement.currentPage.id;
    }
    catch (ex) {
    }

    var progressWindow;
    if (currPage == "activationStartWindow") {
      progressWindow = getActivationStartDialog();
    }
    else {
      progressWindow = getProgressDialog("progressWindow");
    }
    var statusMsg;
    switch (decodedStatus) {
      case 3 :
        if (progressWindow) {
            statusMsg = activationStrBundle.GetStringFromName("connectingToServer");
            progressWindow.setStatus(statusMsg);
        }
        break;
      case 4 :
        if (progressWindow) {
            statusMsg = activationStrBundle.GetStringFromName("connectedToServer");
            progressWindow.setStatus(statusMsg);
        }
        break;
      case 5 :
        if (progressWindow) {
            statusMsg = activationStrBundle.GetStringFromName("connectedToServer");
            progressWindow.setStatus(statusMsg);
        }
        break;
      case 6 :
        if (progressWindow) {
            statusMsg = activationStrBundle.GetStringFromName("connectedToServer");
            progressWindow.setStatus(statusMsg);
        }
        break;
      case 7 :
        if (progressWindow) {
            statusMsg = activationStrBundle.GetStringFromName("connectingToServer");
            progressWindow.setStatus(statusMsg);
        }
        break;
      default:
        break;
    }
  },

  onProgress: function(request, ctxt, progress, progressMax)
  {
  }
}

/* Create an instance of the given ContractID, with given interface */
function createInstance(contractId, intf) {
    return Components.classes[contractId]
        .createInstance(Components.interfaces[intf]);
}

var hexbase="0123456789ABCDEF";
function DecToHex(number) {
  // take a decimal integer, return 2-digit hex string
  return hexbase.charAt((number>> 4)& 0xf)+ hexbase.charAt(number& 0xf);
}

function HexToDec(number) {
  // take a hex string, return decimal integer
  return parseInt(number.toUpperCase(), 16);
}

function pingForTransactionUrls()
{
  var versionNumber = activationStrBundle.GetStringFromName("SNS_API_Version");
  var data = "version=" + versionNumber;

  var initialUrl = gPrefs.getComplexValue("browser.new_registration.sns_production_url",
                                   Components.interfaces.nsIPrefLocalizedString).data;

  post_data_to_server(initialUrl, data, kPostMethod);

  window.openDialog("chrome://communicator/content/profile/progressMeter.xul", "progressWindow", "chrome,modal,titlebar,resizable,centerscreen", this);
}

function getActivationStartDialog()
{
  var progressWindow;
  var windowManagerInterface = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
  progressWindow = windowManagerInterface.getMostRecentWindow('activationStartWindow');
  return progressWindow;
}

function getProgressDialog(windowType)
{
  var progressWindow;
  var windowManagerInterface = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
  progressWindow = windowManagerInterface.getMostRecentWindow(windowType);
  return progressWindow;
}

function setEntryPoint(name)
{
  gEntryPoint = name;
  
  // Set siteId at this time
  if (gEntryPoint == "mainstreamActivation")
    gSiteIdPerActivationSchema = activationStrBundle.GetStringFromName("mainstreamSiteId");
  else  if (gEntryPoint == "downstreamActivation")
    gSiteIdPerActivationSchema = activationStrBundle.GetStringFromName("downstreamSiteId");
}

function setAllHandlersForPageAdvance()
{
  gAcctTypeOnPageHandlerKicked = true;
  gNewAcctHandlerKicked = true;
  gExistingAccountOnPageHandlerKicked = true;
  gScreenNamesOnPageHandlerKicked = true;
  gForgotPwdHandlerKicked = true;
}

function extractReturnValue(key, unesacpeResult)
{
  value = null;
  if (gDataReceived) {
    var dataArray = gDataReceived.split("&");
  
    var dataSubArray;
    for (var i=0; i < dataArray.length; i++) {
      dataSubArray = dataArray[i].split("=");
      if (dataSubArray[0] == key) {
        value = dataSubArray[1];
        if (unesacpeResult)
          value = unescape(value);
        break;
      }
    }
  }
  return value;
}

function ReduceToNamespace(name, namespace)
{
    var regex = /[^ + namespace + ]/g;

    return name.replace(regex, "");
}

// get the format string from the properties file
// and set the full name accordingly
function setUpUserFullName() {
  if (gFirstName && gLastName)
    gUserFullName = activationStrBundle.formatStringFromName("nameFormat", 
                                                           [gFirstName, gLastName], 2);
  else {
    if (gFirstName)
      gUserFullName = gFirstName;
    else {
      if (gLastName)
        gUserFullName = gLastName;
    }
  }
}
