/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gNewAccountWord;
var gNewAccountExistingEmail;
var gNewAccountDateOfBirth;
var gNewAccountZip;
var gNewAccountCountry;
var gNewAccountGender;
var gCountryListBuilt = false;
var gNewAccountDOBYear;
var gNewAccountDOBMonth;
var gNewAccountDOBDay;
var gSuspendAge = false;
var gNNFlagSet;

function newAccount2Load()
{
  gExistingEmailRow = document.getElementById("existingEmailAddressRow");
  var collapseEmailField = false;
  // With new Netscape Network initiative, existing members with no 
  // Netscape Network flag set in the database, will have to provide 
  // data so that records in database can be filled appropriately. 
  // Also, in the process Netscape Network flag will be set.
  if (gCollectDataFromExistingMember) {
    gExistingAccountOnPageHandlerKicked = false;
    gWroteAgeData = false;
    gNNFlagSet = false;
    collapseEmailField = true;
    gSuspendAge = false;
    gSetAgeSuspend = false;

    setNextPage("ispPage5", "ispPage2");
    //alert("next is 2, e");

    // Move focus onto the next item
    var monthGroup = document.getElementById("month");
    if ( monthGroup ) {
      setTimeout( function(firstItem) { firstItem.focus(); }, 0, monthGroup );
    }
  }
  else {
    //alert("case 7");
    setNextPage("ispPage5", "ispPage17");
    setNextPage("ispPage17", "ispPage2");
    setNextPage("ispPage2", "ispPage2");

    // Set focus on existing email field
    var existingEmailTextBox = document.getElementById("newAccountExistingEmail");
    if ( existingEmailTextBox ) {
      setTimeout( function(firstItem) { firstItem.focus(); }, 0, existingEmailTextBox );
    }
  }

  // if we are trying to collect the data for an existing account,
  // there is no need to show email field. Otherwise,
  // make sure they are there.

  prepareEmailField(collapseEmailField);
  enableButton("next");
  setYearDefault();
  buildCountryList();
}

function newAccount2Unload()
{
  if (gExistingAccount && gWroteAgeData)
    return true;

  if (gExistingEmailRow.getAttribute("collapsed") != "true") {
    gNewAccountExistingEmail = document.getElementById("newAccountExistingEmail").value;
    if (!gNewAccountExistingEmail || !isAValidEmailAddress(gNewAccountExistingEmail)) {
      showErrorMsg("newAcctExistingEmailInvalid");
      return false;
    }
  }

  var dateOfBirthDate = document.getElementById("date").value;
  var dateOfBirthMonth = document.getElementById("month").value;
  var dateOfBirthYear = document.getElementById("year").value;

  if (!dateOfBirthMonth) {
    showErrorMsg("newAcctDOBMonthMissing");
    return false;
  }

  if (!dateOfBirthDate) {
    showErrorMsg("newAcctDOBDateMissing");
    return false;
  }

  if (!dateOfBirthYear || !isAValidYear(dateOfBirthYear)) {
    showErrorMsg("newAcctDOBYearMissing");
    return false;
  }

  gNewAccountDateOfBirth = dateOfBirthYear + dateOfBirthMonth + dateOfBirthDate;

  var radioGroup = document.getElementById("gender");
  if (radioGroup.selectedItem) {
    gNewAccountGender = radioGroup.selectedItem.id;
  }

  if (!gNewAccountGender) {
    showErrorMsg("newAcctGenderMissing");
    return false;
  }

  gNewAccountZip = document.getElementById("newAccountZip").value;
  if (!gNewAccountZip) {
    showErrorMsg("newAcctZipMissing");
    return false;
  }

  gNewAccountCountry = document.getElementById("newAccountCountry").value;
  gNewAccountDOBYear = dateOfBirthYear;
  gNewAccountDOBMonth = dateOfBirthMonth;
  gNewAccountDOBDay = dateOfBirthDate;
  gNewAccountDateOfBirth = dateOfBirthYear + dateOfBirthMonth + dateOfBirthDate;

  var ageLimit = getAgeLimit();
  if (isUnderAge(dateOfBirthDate, dateOfBirthMonth, dateOfBirthYear, ageLimit)) {
    if (isUnderAge(dateOfBirthDate, dateOfBirthMonth, dateOfBirthYear, 4)) {
      showErrorMsg("newAcctUnder4");
      document.getElementById("month").selectedIndex = 0;
      document.getElementById("date").selectedIndex = 0;
      document.getElementById("year").value = activationStrBundle.GetStringFromName("yearDefault");
      return false;
    }
    else {
      //for existing users we need to save the info in the UMP even if the user is under age.
      if (gExistingAccount) {
        gValidate = activationStrBundle.GetStringFromName("validateCreditCard");
        gSuspendAge = true;
        if (gValidate == "true") { // show the credit card page
          setNextPage("ispPage5", "ispPage17");
          //alert("case 8");
          setNextPage("ispPage17", "ispPage12");
          setNextPage("ispPage12", "ispPage2");
        }
        else {
          //alert("case 9");
          setNextPage("ispPage5", "ispPage16");
        }

        // if the entered age is >= 13 do not save the data on the server.
        // since the server will not handle ageLimit other than 13
        if ((ageLimit > 13) && !isUnderAge(dateOfBirthDate, dateOfBirthMonth, dateOfBirthYear, 13))
          return true;

        // Time to write the data collected. For intl users < 13 years, 
        // the server will reset the cookies such that the user will be logged out.
        post_data_to_server(gWriteUrl, ("authToken="+ gAuthToken + 
                                          "&user_gender="+gNewAccountGender+ 
                                          "&user_home_postal_postalcode="+gNewAccountZip+ 
                                          "&user_home_postal_countrycode="+gNewAccountCountry+
                                          "&user_bdate_ymd_year="+gNewAccountDOBYear+
                                          "&user_bdate_ymd_month="+gNewAccountDOBMonth+
                                          "&user_bdate_ymd_day="+gNewAccountDOBDay), kPostMethod);
        window.openDialog("chrome://communicator/content/profile/progressMeter.xul",
                          "progressWindow", "chrome,modal,titlebar,resizable,centerscreen", this);
        return false;
      }
      showErrorMsg("newAcctUnder13");
      window.setTimeout(function() {window.close();}, 1);
      try {
        if (actvInst) {
          actvInst.processScreenNameInfo(false, null, null)
        }
      }
      catch (ex) {
      }
      return false;
    }
  }
  return true;
}

function isAValidYear(year)
{
  var defaultYear = activationStrBundle.GetStringFromName("yearDefault");
  if ((year == defaultYear) || (year.length < 4))
    return false;

  return true;
}

function getAgeLimit()
{
  var underAgeLimit = activationStrBundle.GetStringFromName("underAgeLimit");
  var ageLimit = 13;
  if (!isNaN(underAgeLimit))
    ageLimit = parseInt(underAgeLimit);
  return ageLimit;  
}

//returns true if the date that is passed in is < age
function isUnderAge(date, month, year, age)
{
  var underAge = false;  

  // Fix month value to suit date object
  month = month-1;

  var today = new Date();
  var yearDiff = (today.getYear() + 1900) - year;

  if (yearDiff == age) {
    var monthDiff = today.getMonth() - parseInt(month);
    if (monthDiff == 0) {
      underAge = (today.getDate() < parseInt(date));
    }
    else { 
      underAge = (monthDiff < 0);
    }
  }
  else {
    underAge = (yearDiff < age);
  }

  return underAge;
}

function isAValidEmailAddress(emailAddress)
{
  var validEmail = false;
  var emailData = emailAddress.split('@');
   
  if (emailData.length == 2) {
    validEmail = true;
  }

  return validEmail;
}

// Show or hide email field based on flow
function prepareEmailField(needToBeCollapsed)
{
  if (needToBeCollapsed) {
    // Hide existing email address field
    // as every user would have had it while 
    // creating his/her new screen name
    gExistingEmailRow.setAttribute("collapsed", "true");
    document.getElementById("existingEmailAddressSeparator").setAttribute("collapsed", "true");
  }
  else {
    // Show existing email address field
    // as every user should have it while 
    // creating a new screen name
    gExistingEmailRow.removeAttribute("collapsed");
    document.getElementById("existingEmailAddressSeparator").removeAttribute("collapsed");
  }
}
