/* The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Mozilla Communicator client code, released
 * March 31, 1998.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation. Portions created by Netscape are
 * Copyright (C) 1998-1999 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 */ 

var actvInst = Components.classes["@mozilla.org/profile/activation;1"].createInstance();
actvInst = actvInst.QueryInterface(Components.interfaces.nsIActivation);

var gPrefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);

const kIMScreenNamePref = "aim.session.screenname";
const kWebMailDomain = "netscape.net";
const kTestActivation = "browser.test_new_activation";

function setHelpText(element, helpAreaId, helpElementId)
{
  clearHelpText(helpAreaId, helpElementId);

  var helpArea  = document.getElementById(helpAreaId);
  helpArea.setAttribute("hidden", false);

  var currentElement  = document.getElementById(element);
  var helpText  = currentElement.getAttribute("helptext");

  var helpTextNode = document.createTextNode(helpText);

  var helpElement  = document.getElementById(helpElementId);
  helpElement.appendChild(helpTextNode);
}

function clearHelpText(helpAreaId, helpElementId)
{
  var helpElement  = document.getElementById(helpElementId);
  if (helpElement.firstChild)
    helpElement.removeChild(helpElement.firstChild);

  var helpArea  = document.getElementById(helpAreaId);
  helpArea.setAttribute("hidden", true);
}

function setNewAccountGlobals()
{
  gNewAccount = true;
  gExistingAccount = false;
}

function setExistingAccountGlobals()
{
  gExistingAccount = true;
  gNewAccount = false;
}

function enableButton(buttonLabel)
{
  var button = document.documentElement.getButton(buttonLabel);
  button.removeAttribute("disabled");
}

function disableButton(buttonLabel)
{
  var button = document.documentElement.getButton(buttonLabel);
  button.setAttribute("disabled", "true");
}


function setErrorMessage(errorMessage)
{
  clearErrorMessage();

  var errorTextNode = document.createTextNode(errorMessage);

  var errorMessageElement  = document.getElementById("errorMessage");
  errorMessageElement.appendChild(errorTextNode);
}

function clearErrorMessage()
{
  var errorMessageElement  = document.getElementById("errorMessage");
  if (errorMessageElement.firstChild)
    errorMessageElement.removeChild(errorMessageElement.firstChild);
}

function setNextPage(currentPageId, nextPageId) 
{
	//alert("XXX setNextPage " + currentPageId + " " + nextPageId);
    dump("XXX setNextPage " + currentPageId + " " + nextPageId + "\n");
    var currentPage = document.getElementById(currentPageId);
    currentPage.next = nextPageId;
}

function setDayDefault()
{
  var dayMenuList = document.getElementById("day");
  dayMenuList.selectedIndex = 0;
}

function setMonthDefault()
{
  var monthMenuList = document.getElementById("month");
  monthMenuList.selectedIndex = 0;
}

function setYearDefault()
{
  var yearTextBox = document.getElementById("year");
  if (!yearTextBox.value) 
    yearTextBox.value = activationStrBundle.GetStringFromName("yearDefault");
}

function buildCountryList()
{
  if (!gCountryListBuilt) {
    var countryList = document.getElementById("newAccountCountry");

    var countryPrefix = "country";
    var countryCodeSuffix = "Code";
    for (var i = 0; i < 239; i++) {
      var country = activationStrBundle.GetStringFromName(countryPrefix+(i+1));
      var countryCode = activationStrBundle.GetStringFromName(countryPrefix+(i+1)+countryCodeSuffix);

      var item = countryList.appendItem(country, i);
      item.setAttribute("value", countryCode);
    }
    countryList.selectedIndex = parseInt(activationStrBundle.GetStringFromName("selectCountryIndex"))-1;
    gCountryListBuilt = true;
  }
}

function showErrorMsg(errorId)
{
  var errorTitle = activationStrBundle.GetStringFromName("errorMsgWindowTitle");
  var errorMsg = activationStrBundle.GetStringFromName(errorId);
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService();
  promptService = promptService.QueryInterface(Components.interfaces.nsIPromptService);

  if (promptService) {  
    promptService.alert(window, errorTitle, errorMsg);
  }
}

function openTermsInAWindow()
{
  window.openDialog("chrome://communicator/content/profile/termsWindow.xul");
}

function loadTerms()
{
  var termsFrame = document.getElementById("termsWindowFrame");
  var termsURL = gPrefs.getComplexValue("browser.new_registration.terms_url",
                                   Components.interfaces.nsIPrefLocalizedString).data;
  termsFrame.setAttribute("src", termsURL);
}

function printTerms()
{
  try {
    var termsFrame = document.getElementById("termsWindowFrame");
    var printTermsWindow = termsFrame.docShell.contentViewer.QueryInterface(Components.interfaces.nsIWebBrowserPrint);
    if (printTermsWindow) {
      // get local copy of print settings
      var printSettings = printTermsWindow.globalPrintSettings;
      printSettings.showPrintProgress = false;
      printTermsWindow.print(printSettings, null);
    }
  } 
  catch (e) {
  }
}

function openLearnAboutNNInAWindow()
{
  window.openDialog("chrome://communicator/content/profile/learnAboutNNWindow.xul");
}

function loadAgeVerificationContent()
{
  var underAgeLimit = activationStrBundle.GetStringFromName("underAgeLimit");
  var ageLimit = document.getElementById("ageLimit");
  ageLimit.setAttribute("value", underAgeLimit);
}

function loadNNContent()
{
  var learnNNFrame = document.getElementById("learnNNWindowFrame");
  var learnNNURL = gPrefs.getComplexValue("browser.new_registration.learn_about_NN_url",
                                   Components.interfaces.nsIPrefLocalizedString).data;
  learnNNFrame.setAttribute("src", learnNNURL);
}

function SetCustomizedWizardDimensions()
{
  var width  = activationStrBundle.GetStringFromName("wizardWindowWidth");
  var height = activationStrBundle.GetStringFromName("wizardWindowHeight");

  document.documentElement.width = width;
  document.documentElement.height = height;

  // Also check if there are any arguments. If there are arguments to start
  // in page, request is coming from Get Free Web Mail page. Process that one.
  if (window.arguments && window.arguments[0]) {
    if (window.arguments[0].page == "ispPage4") {
      var progressWindow = getProgressDialog("activationStartWindow");
      if (progressWindow) 
        progressWindow.close();

	  //alert("SetNewPageMappings 1\n");
      SetNewPageMappings(window.arguments[0].page, "ispPage5", "done");
      gNewAccountUrl = window.arguments[0].newaccturl;
      gDisableBackButton = true;

      // get all other urls too
      gAuthenticationUrl = window.arguments[0].authurl;
      gReadUrl = window.arguments[0].readurl;
      gWriteUrl = window.arguments[0].writeurl;
      gForgottenPwdUrl = window.arguments[0].forgotpwdurl;
      gSuggestSnUrl = window.arguments[0].suggestsnurl;
      gSetUserBrandUrl = window.arguments[0].setbrandurl;
      gAgeSuspendUrl = window.arguments[0].agesuspendurl;
      gCreditCardValidationUrl = window.arguments[0].creditvalidurl;
      gGetRegImageUrl = window.arguments[0].getregimageurl;
      document.documentElement.goTo(window.arguments[0].page);
    }
  }
  else if (window.arguments && window.arguments[1]) {
    if (window.arguments[1].page == "ispPage3") {
      var progressWindow = getProgressDialog("activationStartWindow");
      if (progressWindow) 
        progressWindow.close();

      //alert("SetNewPageMappings 2\n");
      SetNewPageMappings(window.arguments[1].page, "ispPage5", "done");

      // get all urls
      gNewAccountUrl = window.arguments[1].newaccturl;
      gAuthenticationUrl = window.arguments[1].authurl;
      gReadUrl = window.arguments[1].readurl;
      gWriteUrl = window.arguments[1].writeurl;
      gForgottenPwdUrl = window.arguments[1].forgotpwdurl;
      gSuggestSnUrl = window.arguments[1].suggestsnurl;
      gSetUserBrandUrl = window.arguments[1].setbrandurl;
      gAgeSuspendUrl = window.arguments[1].agesuspendurl;
      gCreditCardValidationUrl = window.arguments[1].creditvalidurl;
      gGetRegImageUrl = window.arguments[1].getregimageurl;
      document.documentElement.goTo(window.arguments[1].page);
    }
  }
}

function setOtherISPServices()
{
  // time to set IM screenname pref, if there isn't already one
  var IMScreenName;
  var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

  try {
    IMScreenName = prefService.getComplexValue(kIMScreenNamePref,
                               Components.interfaces.nsIPrefLocalizedString);
  }
  catch (ex) {
  }

  if (!IMScreenName) {
    if (gScreenName) {
      try {
      var str = Components.classes["@mozilla.org/supports-wstring;1"]
                          .createInstance(Components.interfaces.nsISupportsWString);
      str.data = gScreenName;
      prefService.setComplexValue(kIMScreenNamePref,
                               Components.interfaces.nsISupportsWString, str);
    }
      catch (ex) {
      }
    }
  }
}

var gWebMailTimerIntervalID;
var gWebMailTimer=0;

function checkWebMailReply()
{
  var webmailCookieID = "WM_RC";
  var createdWebMailAccount = false;
  var begin, end;

  // Get webmail cookie.
  webmailCookie   = actvInst.getWebMailCookie();

  if (webmailCookie) {
    begin = webmailCookie.indexOf(webmailCookieID);
    if (begin != -1) {
      // Increase begin index to ignore the cookie ID name and '=' part 
      begin += webmailCookieID.length + 1;

      end = webmailCookie.indexOf(";", begin);
      if (end == -1) 
          end = webmailCookie.length;

      webmailCookie = webmailCookie.substring(begin, end);

      if (webmailCookie) {

          if (webmailCookie == 0)
            createdWebMailAccount = true;
      }
    }
  }
  return createdWebMailAccount;
}

function pingWebMailServer(hiddenWindowID) 
{ 
    // Create a session history object and set it on the content docshell
    gWebMailTimerIntervalID = setInterval("isWebMailAccountCreated()", 1000);

    var webMailUrl = gPrefs.getComplexValue("browser.new_registration.webmail_production_url",
                                   Components.interfaces.nsIPrefLocalizedString).data;
    var hiddenWindow = document.getElementById(hiddenWindowID);
    try {
      hiddenWindow.setAttribute("src", webMailUrl);
    }
    catch (e) {
    }
  }

function isWebMailAccountCreated()
{
  if (gWebMailTimer >= 60 || checkWebMailReply())
  {
    var webMailAccountCreated = false;
    // Clear the interval 
    clearInterval(gWebMailTimerIntervalID);

    // Time to quit, either we haven't reached the server or right url is not loaded
    if (!checkWebMailReply()) {
      gFailedToCreateWebMailAccount = true;
    }
    
    var currPage = document.documentElement.currentPage.id;

    switch(currPage) {
      case "ispPage2" :
          if (gFailedToCreateWebMailAccount && document.documentElement.id == "AccountWizard") {
            gCloseProgressMeter = true;
            setNextPage("ispPage2", "ispPage11");
            document.documentElement.advance("ispPage11");
          }
          else {
            gCloseProgressMeter = true;
            setNextPage("ispPage2", gEndPageId);
            document.documentElement.advance(gEndPageId);
          }
        break;
      case "ispPage3" :
        gCloseProgressMeter = true;
        gExistingAccountOnPageHandlerKicked = true;
        setNextPage("ispPage2", gEndPageId);
        document.documentElement.advance(gEndPageId);
        break;
      case "ispPage5" :
        gCloseProgressMeter = true;
        gWroteAgeData = true;
        //alert("case 12");
        setNextPage("ispPage2", gEndPageId);
        document.documentElement.advance("ispPage2");
        break;
      case "ispPage6" :
        if (gFailedToCreateWebMailAccount && document.documentElement.id == "AccountWizard") {
          gCloseProgressMeter = true;
          setNextPage("ispPage6", "ispPage11");
          document.documentElement.advance("ispPage11");
        }
        else {
          gCloseProgressMeter = true;
          setNextPage("ispPage6", gEndPageId);
          document.documentElement.advance(gEndPageId);
        }
        break;
      case "ispPage7" :
        gCloseProgressMeter = true;
        if (gFailedToCreateWebMailAccount && document.documentElement.id == "AccountWizard")
        {
          setNextPage("ispPage7", "ispPage11");
          document.documentElement.advance("ispPage11");
        }
        else {
          setNextPage("ispPage7", gEndPageId);
          document.documentElement.advance(gEndPageId);
        }
        break;
      case "ispPage12" :
        gCloseProgressMeter = true;
        gNNFlagSet = true;
        setNextPage("ispPage2", gEndPageId);
        document.documentElement.advance("ispPage2");
        break;
      case "ispPage17" :
        //alert("what do here?");
        break;  
      default :
        break;
    }
  }
  else
  {	  
      gWebMailTimer++;
  }
}

function testingNewActivation()
{
  var prefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
  var testingActivation = prefService.getBoolPref(kTestActivation);

  return testingActivation;

}

function testingIspServices()
{
  return testingNewActivation();
}

function isAValidScreenName(screenName)
{
  var validName = true;

  if (screenName.length < 3 || screenName.length > 16) {
    validName = false;
  }
  else if (!(screenName[0].match(/[A-Za-z]/g))) {
    validName = false;
  }
  else {
    var charsMatched = screenName.match(/[A-Za-z0-9_]/g);
    if (!charsMatched || (charsMatched.length != screenName.length)) {
      validName = false;
    }
  }
  return validName;
}
