/* 
 * Copyright (C) 2003-2004 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: noskin_window.c,v 1.35 2004/12/15 23:59:59 dsalt Exp $
 *
 * standard, non-skinned main window
 */

#include "globals.h"

#ifndef EXP_STUFF

#include "noskin_window.h"

#include <stdio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#include "utils.h"
#include "engine.h"
#include "key_events.h"
#include "player.h"
#include "playlist.h"
#include "mediamarks.h"
#include "menu.h"
#include "drag_drop.h"
#include "gtkvideo.h"
#include "gtkflipbutton.h"
#include "infobar.h"
#include "time_widget.h"
#include "vis.h"

#include "playlist.xpm"
#include "play.xpm"
#include "pause.xpm"
#include "stop.xpm"
#include "speaker.xpm"
#include "nospeaker.xpm"
#include "sliders.xpm"
#include "fast_forward.xpm"

/*
#define VIS_WIDGET
*/

/* global */
GtkWidget *gtv;

/* private/local */
static GtkObject      *seeker, *vol_adj, *audio_adj;
static GtkTooltips    *tips;
static int             have_video = -1, have_audio = -1;

static GtkWidget *controlwindow, *controlvbox, *controlhbox, *controlhome;
static GtkWidget *cw_top, *cw_bottom;

/*
 * callbacks
 */

static void control_cb (GtkWidget* widget, gpointer data) {

  char *cmd = (char *) data;

  if (no_recursion)
    return;

  engine_exec (cmd, NULL, NULL);

  /* take focus away from this button
     (pressing 'space' for pause tends to behave strangely otherwise */
  gtk_window_set_focus(GTK_WINDOW (app), NULL);
}

static void toggle_cb (GtkToggleButton *button, gpointer data)
{
  if (!no_recursion)
    ui_set_status (UI_CURRENT_STATE);
}

static GtkWidget *add_pix_button_common (GtkWidget *box, GtkWidget *button,
					 char *cmd, char *tip, gboolean start)
{
  gtk_button_set_relief (GTK_BUTTON(button), GTK_RELIEF_NONE);
  if (start)
    gtk_box_pack_start (GTK_BOX(box), button, FALSE, FALSE, 2);
  else
    gtk_box_pack_end (GTK_BOX(box), button, FALSE, FALSE, 2);

  g_signal_connect (GTK_OBJECT(button), "clicked",
		    G_CALLBACK(control_cb), cmd);
  gtk_tooltips_set_tip (GTK_TOOLTIPS(tips), button, tip, NULL);
  gtk_widget_show_all (button);
  return button;
}

static GtkWidget *new_pixmap (gchar **xpm)
{
  GdkPixmap *image;
  GdkBitmap *transparent;

  image = gdk_pixmap_colormap_create_from_xpm_d
	    (NULL, gdk_colormap_get_system(), &transparent, NULL, xpm);
  return gtk_pixmap_new (image, transparent);
}

static GtkWidget *add_pix_button (GtkWidget *box, gchar **pixmap_array,
				  char *cmd, char *tip, gboolean toggle,
				  gboolean start)
{
  GtkWidget *button;

  if (toggle)
  {
    button = gtk_toggle_button_new ();
    g_signal_connect (GTK_OBJECT(button), "toggled",
		      G_CALLBACK(toggle_cb), NULL);
  }
  else
    button = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER(button), new_pixmap (pixmap_array));
  return add_pix_button_common (box, button, cmd, tip, start);
}

static GtkWidget *add_pix_flip_button (GtkWidget *box, gchar **inactive,
				       gchar **active, char * cmd, char *tip,
				       gboolean start)
{
  GtkWidget *button = gtk_flip_button_new (new_pixmap (inactive),
					   new_pixmap (active));
  g_signal_connect (GTK_OBJECT(button), "toggled",
		    G_CALLBACK(toggle_cb), NULL);
  return add_pix_button_common (box, button, cmd, tip, start);
}

/*
 * slider
 */

static gint update_slider_cb (gpointer data) {

  gint pos_stream, pos_time, length_time;
  int hv_new, ha_new;

  hv_new = xine_get_stream_info (stream, XINE_STREAM_INFO_HAS_VIDEO);
  ha_new = xine_get_stream_info (stream, XINE_STREAM_INFO_HAS_AUDIO);

  if (have_video != hv_new || have_audio != ha_new)
  {
    have_video = hv_new;
    have_audio = ha_new;
    if (have_video) {
      vis_hide (GTK_VIDEO(gtv), audio_port);
      gtk_widget_show (gtv);
      /*gtk_widget_set_size_request (gtv, 480, 205);*/
    }
    else if (!have_audio || !vis_show (GTK_VIDEO(gtv), &audio_port))
      gtk_widget_hide (gtv);
    else
      gtk_widget_show (gtv);
    gtk_window_resize (GTK_WINDOW(app), 10, 10);
  }

  if (xine_get_status (stream) != XINE_STATUS_PLAY)
    return TRUE;

  if (!xine_get_pos_length (stream, &pos_stream, &pos_time, &length_time))
    return TRUE;

  ui_set_control_adjustment (Control_SEEKER, pos_stream);

  /* update the control buttons while we're here */
  ui_set_status (UI_CURRENT_STATE);

  return TRUE;
}

static void seek_cb(GtkWidget* widget, gpointer data){

  if (!no_recursion &&
      xine_get_stream_info (stream, XINE_STREAM_INFO_SEEKABLE))
  {
    xine_play (stream, (gint) GTK_ADJUSTMENT(seeker)->value, 0);
    ui_set_status (UI_PLAY);
  }
}

gint close_application( GtkWidget *widget,
                        GdkEvent  *event,
                        gpointer   data ) {
  engine_exec ("exit();", NULL, NULL);
  return(FALSE);
}

static gint cw_height = 1;

static gboolean window_toolbar_show_int (void)
{
  static gboolean first = TRUE;
  gtk_container_foreach (GTK_CONTAINER(controlvbox),
			 (GtkCallback)gtk_widget_reparent, controlhbox);
  gtk_window_move (GTK_WINDOW(controlwindow), 0,
		   toolbar_at_top ? 1 : gdk_screen_height () - cw_height - 1);
  gtk_widget_show_all (controlwindow);
  gtk_widget_hide (toolbar_at_top ? cw_top : cw_bottom);
  if (first)
  {
    first = FALSE;
    g_idle_add ((GSourceFunc) window_toolbar_show_int, NULL);
  }
  return FALSE;
}

void window_toolbar_show (gboolean show)
{
  toolbar_visible = show;

  if (!show)
    window_toolbar_reset ();
  else if (gtk_video_is_fullscreen (GTK_VIDEO(gtv)))
    window_toolbar_show_int ();

  ui_set_status (UI_TOOLBAR);
}

void window_toolbar_reset (void)
{
  gtk_container_foreach (GTK_CONTAINER(controlhbox),
			 (GtkCallback)gtk_widget_reparent, controlvbox);
  gtk_widget_hide (controlwindow);
}

void window_toolbar_restore (void)
{
  if (toolbar_visible)
    window_toolbar_show_int ();
}

void window_toolbar_position (gboolean top)
{
  toolbar_at_top = top;
  gtk_window_move (GTK_WINDOW(controlwindow),
		   0, top ? 1 : gdk_screen_height () - cw_height - 1);
  gtk_widget_hide (top ? cw_top : cw_bottom);
  gtk_widget_show (top ? cw_bottom : cw_top);
  ui_set_status (UI_TOOLBAR);
}

static void cw_top_bottom_cb (GtkWidget *widget, GtkWidget *other)
{
  window_toolbar_position (widget == cw_top);
}

static gboolean window_toolbar_configure_cb (GtkWidget *widget,
					     GdkEventConfigure *event,
					     gpointer data)
{
  cw_height = event->height;
  return FALSE;
}

static gboolean noskin_main_init_cb (void)
{
  ui_set_status (xine_get_param (stream, XINE_PARAM_AUDIO_MUTE)
		 ? UI_AUDIO_MUTE : UI_AUDIO_UNMUTE);
//  engine_exec ("set_mute (get_mute ())", NULL, NULL);
  return FALSE;
}

static GtkWidget *button_icon_new (const char *stock, const char *tip)
{
  GtkWidget *w = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER(w),
		     gtk_image_new_from_stock (stock, GTK_ICON_SIZE_BUTTON));
  if (tip)
    gtk_tooltips_set_tip(GTK_TOOLTIPS (tips), w, tip, NULL);
  return w;
}

void noskin_main_init (void) {

  GtkWidget     *vbox;
  GtkWidget     *infobox, *infobar, *tw;
#ifdef VIS_WIDGET
  GtkWidget     *vis;
  xine_post_out_t *vis_out;
#endif
  GtkWidget     *sliderbox;
  GtkWidget     *scale, *vol_scale;
  GtkWidget     *ctrl;
  GtkWidget     *audio_spinner;
  time_widget_t *time_widget;
  GdkGeometry    cw_geom;

  tips = gtk_tooltips_new ();

  /* toolbar window (full-screen mode) */

  controlwindow = gtk_window_new(GTK_WINDOW_POPUP);
  g_signal_connect (GTK_OBJECT (controlwindow), "delete_event",
		    G_CALLBACK (gtk_widget_hide), NULL);
  g_signal_connect (GTK_OBJECT (controlwindow), "configure-event",
		    G_CALLBACK (window_toolbar_configure_cb), NULL);
  gtk_window_set_title (GTK_WINDOW(controlwindow), "");
  gtk_window_set_resizable (GTK_WINDOW(controlwindow), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW(controlwindow),
			    GDK_WINDOW_TYPE_HINT_TOOLBAR);
  gtk_window_set_decorated (GTK_WINDOW(controlwindow), FALSE);
  gtk_window_set_accept_focus (GTK_WINDOW(controlwindow), FALSE);

  memset (&cw_geom, 0, sizeof (cw_geom));
  cw_geom.max_width = cw_geom.min_width = gdk_screen_width ();
  cw_geom.max_height = cw_geom.min_height = -1;
  cw_geom.win_gravity = GDK_GRAVITY_SOUTH_WEST;
  gtk_window_set_geometry_hints
    (GTK_WINDOW(controlwindow), controlwindow, &cw_geom,
     GDK_HINT_POS | GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE | GDK_HINT_BASE_SIZE);

  ctrl = gtk_hbox_new (0, 0);
  gtk_container_add (GTK_CONTAINER(controlwindow), ctrl);
  controlhbox = gtk_hbox_new (0, 0);
  gtk_box_pack_start_defaults (GTK_BOX(ctrl), controlhbox);

  {
    GtkWidget *w;

    vbox = gtk_vbox_new (0, 2);
    gtk_box_pack_end (GTK_BOX(ctrl), vbox, FALSE, FALSE, 2);

    w = button_icon_new (GTK_STOCK_CLOSE, _("Hide toolbar"));
    gtk_box_pack_start_defaults (GTK_BOX(vbox), w);
    g_signal_connect_swapped (GTK_OBJECT(w), "clicked",
		      	      G_CALLBACK(ui_toolbar_toggle), NULL);

    cw_top = button_icon_new (GTK_STOCK_GO_UP, _("Move toolbar to top"));
    gtk_box_pack_start_defaults (GTK_BOX(vbox), cw_top);
    cw_bottom = button_icon_new (GTK_STOCK_GO_DOWN,
				 _("Move toolbar to bottom"));
    gtk_box_pack_start_defaults (GTK_BOX(vbox), cw_bottom);
    g_signal_connect (GTK_OBJECT(cw_top), "clicked",
		      G_CALLBACK(cw_top_bottom_cb), cw_bottom);
    g_signal_connect (GTK_OBJECT(cw_bottom), "clicked",
		      G_CALLBACK(cw_top_bottom_cb), cw_top);
  }

  /* main application window */

  app = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  g_signal_connect( GTK_OBJECT (app), "delete_event",
		    G_CALLBACK (close_application), NULL );

  gtk_widget_add_events (app, GDK_KEY_RELEASE_MASK);
  g_signal_connect (GTK_OBJECT(app), "key_press_event",
		    G_CALLBACK(keypress_cb), NULL);

  drag_drop_setup (app);

  /*
   * setup widgets
   */

  controlhome = vbox = gtk_vbox_new (0, 0);
  gtk_container_add (GTK_CONTAINER (app), vbox);

  /*
   * menu, video widget
   */

  gtv = gtk_video_new (xine, stream, xine_get_video_source (stream), 
  	               video_driver_id, 480, 300,
                       0x04 /* press: button 2 */,
                       0x08 /* release: button 3 */);
  drag_drop_setup (gtv);
  g_signal_connect (GTK_OBJECT (gtv), "keypress",
		    G_CALLBACK (keypress_cb), NULL);
  g_signal_connect (GTK_OBJECT (gtv), "keyrelease",
		    G_CALLBACK (keyrelease_cb), NULL);

  create_menus (app);
  gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, FALSE, 0);

  gtk_box_pack_start_defaults (GTK_BOX(vbox), gtv);

  controlvbox = gtk_vbox_new (0, 0);
  gtk_box_pack_start (GTK_BOX(vbox), controlvbox, FALSE, FALSE, 0);
  vbox = controlvbox;

  /* vis / time_widget / infobar */

  infobox = gtk_hbox_new (0, 0);

#ifdef VIS_WIDGET
  {
    xine_video_port_t *video_port;
    xine_post_t *vis_plugin;
    xine_post_out_t *audio_source;
    xine_post_in_t *input;

    video_port = xine_open_video_driver (xine, "none", 0, NULL);
    vis_plugin = xine_post_init (xine, "fftscope", 0, &audio_port, &video_port);
    audio_source = xine_get_audio_source (stream);
    input = xine_post_input (vis_plugin, "audio in");
    xine_post_wire (audio_source, input);
    vis_out = xine_post_output (vis_plugin, "generated video");
  }
  vis = gtk_video_new (xine, stream, vis_out, "xshm", 100, 50);
  gtk_box_pack_start (GTK_BOX(infobox), vis, FALSE, FALSE, 0);
#endif

  time_widget = create_time_widget (&tw);
  gtk_box_pack_start (GTK_BOX(infobox), tw, FALSE, FALSE, 0);
  drag_drop_setup (tw);

  bar = create_infobar (&infobar);
  gtk_box_pack_start (GTK_BOX(infobox), infobar, TRUE, TRUE, 0);
  drag_drop_setup (infobar);

  gtk_box_pack_start (GTK_BOX(vbox), infobox, FALSE, FALSE, 2);

  /* slider/seeker */

  sliderbox = gtk_vbox_new (0, 2);

  seeker = ui_register_control_adjustment (Control_SEEKER);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(seeker));
  gtk_scale_set_draw_value (GTK_SCALE(scale), FALSE);
  g_signal_connect( GTK_OBJECT (seeker), "value-changed",
		      G_CALLBACK (seek_cb), NULL );

  ctrl = gtk_hbox_new (0, 2);
  gtk_box_pack_start (GTK_BOX(ctrl), scale, TRUE, TRUE, 4);
  gtk_box_pack_start (GTK_BOX(sliderbox), ctrl, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX(vbox), sliderbox, FALSE, FALSE, 0);

  /*
   * control bar
   */

  ctrl = gtk_hbox_new (0, 0);

  /* buttons */

  ui_register_control_button
    (Control_PLAY,
     add_pix_button (ctrl, play_xpm, "play ();", _("Play"), TRUE, TRUE));
  ui_register_control_button
    (Control_FASTFWD,
     add_pix_button (ctrl, fast_forward_xpm,
		     "if (!is_live_stream ()) set_speed (16);",
		     _("Fast forward"), TRUE, TRUE));
  ui_register_control_button
    (Control_PAUSE,
     add_pix_button (ctrl, pause_xpm,
		     "if (!is_live_stream ()) pause ();",
		     _("Pause"), TRUE, TRUE));
  ui_register_control_button
    (Control_STOP,
     add_pix_button (ctrl, stop_xpm, "stop ();", _("Stop"), TRUE, TRUE));

  add_pix_button (ctrl, playlist_xpm,
		  "playlist_show ()", _("Playlist"), FALSE, TRUE);
  add_pix_button (ctrl, sliders_xpm,
		  "settings_show ()", _("A/V settings"), FALSE, TRUE);

  /* audio channel selection */

  audio_adj = ui_register_control_adjustment (Control_AUDIO_CHANNEL);
  audio_spinner = gtk_spin_button_new (GTK_ADJUSTMENT (audio_adj),
				       1.0,0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(audio_spinner), TRUE);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tips), audio_spinner,
			_("Audio channel"), NULL);
  gtk_box_pack_end (GTK_BOX(ctrl), audio_spinner, FALSE, FALSE, 5);

  /* volume slider */

  vol_adj = ui_register_control_adjustment (Control_VOLUME);
  vol_scale = gtk_hscale_new (GTK_ADJUSTMENT (vol_adj));
  gtk_scale_set_draw_value (GTK_SCALE (vol_scale), FALSE);
  gtk_widget_set_size_request (vol_scale, 75, -1);  
  gtk_box_pack_end (GTK_BOX (ctrl), vol_scale, FALSE, FALSE, 5);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tips), vol_scale, _("Volume"), NULL);

  /* mute button */

  ui_register_control_button
    (Control_MUTE,
     add_pix_flip_button (ctrl, nospeaker_xpm, speaker_xpm,
			  "set_mute ();", _("Mute/unmute"), FALSE));

  gtk_box_pack_end (GTK_BOX(sliderbox), ctrl, FALSE, FALSE, 4);

  /* Show the app window */

  gtk_widget_show_all(app);
  g_idle_add ((GSourceFunc) noskin_main_init_cb, NULL);

  have_video = 1;

  postinit_infobar (app, bar);
  postinit_time_widget (app, time_widget);

  gtk_timeout_add (1000, update_slider_cb, NULL);
}
#endif /* !EXP_STUFF */
