/*
 * C 2003-2004 Edscott Wilson Garcia under GPL
 * This software is bound by the GPL, see accompanying files for
 * more information.
 *
 * <edscott@xfce.org>
 *
 *  */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <gtk/gtk.h>
#include <string.h>
#include <gmodule.h>
#include <errno.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <xfce4-modules/mime_icons.h>

#include "main_gui.h"
#include "support.h"
#include "callbacks.h"

#define D(x)
#define DD(x) x


GtkTreeView *treeview;
GtkTreeView *treeview2;
GtkTreeStore *store;  
GtkTreeStore *store2;  
GtkWidget *xfmime_edit;

#define STOCK_STUFF {GTK_STOCK_DIALOG_INFO,GTK_STOCK_DIALOG_WARNING,GTK_STOCK_DIALOG_ERROR,GTK_STOCK_DIALOG_QUESTION,GTK_STOCK_DND,GTK_STOCK_DND_MULTIPLE,GTK_STOCK_ADD,GTK_STOCK_APPLY,GTK_STOCK_BOLD,GTK_STOCK_CANCEL,GTK_STOCK_CDROM,GTK_STOCK_CLEAR,GTK_STOCK_CLOSE,GTK_STOCK_COLOR_PICKER,GTK_STOCK_CONVERT,GTK_STOCK_COPY,GTK_STOCK_CUT,GTK_STOCK_DELETE,GTK_STOCK_EXECUTE,GTK_STOCK_FIND,GTK_STOCK_FIND_AND_REPLACE,GTK_STOCK_FLOPPY,GTK_STOCK_GOTO_BOTTOM,GTK_STOCK_GOTO_FIRST,GTK_STOCK_GOTO_LAST,GTK_STOCK_GOTO_TOP,GTK_STOCK_GO_BACK,GTK_STOCK_GO_DOWN,GTK_STOCK_GO_FORWARD,GTK_STOCK_GO_UP,GTK_STOCK_HELP,GTK_STOCK_HOME,GTK_STOCK_INDEX,GTK_STOCK_ITALIC,GTK_STOCK_JUMP_TO,GTK_STOCK_JUSTIFY_CENTER,GTK_STOCK_JUSTIFY_FILL,GTK_STOCK_JUSTIFY_LEFT,GTK_STOCK_JUSTIFY_RIGHT,GTK_STOCK_MISSING_IMAGE,GTK_STOCK_NEW,GTK_STOCK_NO,GTK_STOCK_OK,GTK_STOCK_OPEN,GTK_STOCK_PASTE,GTK_STOCK_PREFERENCES,GTK_STOCK_PRINT,GTK_STOCK_PRINT_PREVIEW,GTK_STOCK_PROPERTIES,GTK_STOCK_QUIT,GTK_STOCK_REDO,GTK_STOCK_REFRESH,GTK_STOCK_REMOVE,GTK_STOCK_REVERT_TO_SAVED,GTK_STOCK_SAVE,GTK_STOCK_SAVE_AS,GTK_STOCK_SELECT_COLOR,GTK_STOCK_SELECT_FONT,GTK_STOCK_SORT_ASCENDING,GTK_STOCK_SORT_DESCENDING,GTK_STOCK_SPELL_CHECK,GTK_STOCK_STOP,GTK_STOCK_STRIKETHROUGH,GTK_STOCK_UNDELETE,GTK_STOCK_UNDERLINE,GTK_STOCK_UNDO,GTK_STOCK_YES,GTK_STOCK_ZOOM_100,GTK_STOCK_ZOOM_FIT,GTK_STOCK_ZOOM_IN,GTK_STOCK_ZOOM_OUT,NULL}

enum
{
    DND_NONE,
    DND_MOVE,
    DND_COPY,
    DND_LINK
};

enum
{
    TARGET_URI_LIST,
    TARGET_PLAIN,
    TARGET_STRING,
    TARGETS
};


static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/plain", 0, TARGET_PLAIN},
    {"STRING", 0, TARGET_STRING}
};
#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))

static GModule *xfmime_icon_cm=NULL;

static GtkStyle *style;

xfmime_icon_functions *xfmime_icon_fun=NULL;

gchar *no_xml_file=NULL;
gchar *xml_file=NULL;
gchar *icon_theme_name=NULL;
    


void unload_mime_icon_module(void){
	if (!xfmime_icon_fun) return;
	g_free(xfmime_icon_fun);
	xfmime_icon_fun = NULL;
	

	if (!g_module_close(xfmime_icon_cm)){
	   g_warning("g_module_close(xfmime_icon_cm) != TRUE\n");
	}
	/*else {
           g_message ("xffm: module libxfce4_mime_icons unloaded");
	}*/	   
	xfmime_icon_cm=NULL;
}

xfmime_icon_functions *load_mime_icon_module(void){
    gchar  *module;
    xfmime_icon_functions *(*module_init)(void) ;
    gchar *librarydir=g_build_filename (LIBDIR, "xfce4", "modules",NULL);
    
    if (xfmime_icon_fun) return xfmime_icon_fun;
    
    module = g_module_build_path(librarydir, "xfce4_mime_icons");
    g_free(librarydir);
    
    xfmime_icon_cm=g_module_open (module, 0);
    if (!xfmime_icon_cm){
	g_error("g_module_open(%s) == NULL\n",module);
   	exit(1);
    }
    
   if (!g_module_symbol (xfmime_icon_cm, "module_init",(gpointer *) &(module_init)) ) {
	g_error("g_module_symbol(module_init) != FALSE\n");
        exit(1);
    }

    
    xfmime_icon_fun = (*module_init)();
    
#if 0         
    /* these functions are imported from the module */
    if (!g_module_symbol (xfmime_icon_cm, "mime_icon_get_iconset",(gpointer *) &(xfmime_icon_fun->mime_icon_get_iconset)) ||    
	!g_module_symbol (xfmime_icon_cm, "mime_icon_add_iconset",(gpointer *) &(xfmime_icon_fun->mime_icon_add_iconset)) ||    
	!g_module_symbol (xfmime_icon_cm, "mime_icon_load_theme",(gpointer *) &(xfmime_icon_fun->mime_icon_load_theme)) ||    
	!g_module_symbol (xfmime_icon_cm, "mime_icon_find_pixmap_file",(gpointer *) &(xfmime_icon_fun->mime_icon_find_pixmap_file)) ||    
	!g_module_symbol (xfmime_icon_cm, "mime_icon_create_pixmap",(gpointer *) &(xfmime_icon_fun->mime_icon_create_pixmap)) ||    
	!g_module_symbol (xfmime_icon_cm, "mime_icon_create_pixbuf",(gpointer *) &(xfmime_icon_fun->mime_icon_create_pixbuf))    
       ) {
	g_error("g_module_symbol() != FALSE\n");
        exit(1);
    }
#endif
    
    /*g_message ("module %s successfully loaded", library);	    */
    g_free(module);
    return xfmime_icon_fun;
}

gboolean get_xml_files(void){
    if (!icon_theme_name) {
	g_warning("!icon_theme_name");
    }
    g_free(xml_file);
    xml_file= MIME_ICON_get_local_xml_file(icon_theme_name);
    if (!xml_file || !g_file_test(xml_file,G_FILE_TEST_EXISTS)){
	g_free(xml_file); 
	xml_file= MIME_ICON_get_global_xml_file(icon_theme_name);	
    }
    printf("DBG: xml file is %s\n",(xml_file)?xml_file:"NULL");
 
    return TRUE;
}


static char *dnd_data = NULL;

void
on_treeview1_drag_data_get             (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    /*printf("drag get\n");*/
    GtkTreeView *treeview = (GtkTreeView *)widget;
    GtkTreeIter iter;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    gchar *n;
    
    if (dnd_data) g_free(dnd_data);
    gtk_tree_selection_get_selected (selection,(GtkTreeModel **)(&store),&iter);
                     /* GtkTreeModel **model,GtkTreeIter *iter);*/
    gtk_tree_model_get((GtkTreeModel *)store, &iter, ICON_COLUMN, &n, -1);
    if (n) {
      gchar *i=MIME_ICON_find_pixmap_file(n);
      if (i){
        dnd_data = g_strconcat("file:",i,NULL);
        gtk_selection_data_set(selection_data, selection_data->target, 
		    8, (const guchar *)dnd_data,strlen(dnd_data)+ 1); 
	g_free(i);
      }
    }
    
    return;

}
void
on_treeview2_drag_data_get             (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    /*printf("drag get\n");*/
    GtkTreeView *treeview = (GtkTreeView *)widget;
    GtkTreeIter iter;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    gchar *n;
    
    if (dnd_data) g_free(dnd_data);
    gtk_tree_selection_get_selected (selection,(GtkTreeModel **)(&store2),&iter);
                     /* GtkTreeModel **model,GtkTreeIter *iter);*/
    gtk_tree_model_get((GtkTreeModel *)store2, &iter, ICON_COLUMN, &n, -1);
    if (n && strncmp(n,"gtk-",strlen("gtk-"))!=0) {
      gchar *i=MIME_ICON_find_pixmap_file(n);
      if (i){
        dnd_data = g_strconcat("file:",i,NULL);
        gtk_selection_data_set(selection_data, selection_data->target, 
		    8, (const guchar *)dnd_data,strlen(dnd_data)+ 1); 
	g_free(i);
      }
    }
    if (n && strncmp(n,"gtk-",strlen("gtk-"))==0) {
        dnd_data = g_strconcat("file:/",n,NULL);
        gtk_selection_data_set(selection_data, selection_data->target, 
		    8, (const guchar *)dnd_data,strlen(dnd_data)+ 1); 
    }
    
    return;

}

xmlNodePtr rootM;
static gboolean xmladd(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data){
	gchar *n,*i;
    xmlNodePtr node;
    gtk_tree_model_get(treemodel, iter, NAME_COLUMN, &n, -1);
    gtk_tree_model_get(treemodel, iter, ICON_COLUMN, &i, -1);
    if (i && strlen(i)) {
        node = xmlNewTextChild(rootM, NULL, "mime-type", NULL);
    	xmlSetProp(node,"type", n);
    	xmlSetProp(node,"icon",i);
    }

    if (n) g_free(n);
    if (i) g_free(i);
    return FALSE;
}


static void writexml(void){
    xmlDocPtr doc;
    char *mimefile=NULL;
    gchar *icon_theme_path=NULL;
    
    if (!icon_theme_name) {
	g_warning("!icon_theme_name");
    }
   icon_theme_path=MIME_ICON_get_theme_path(icon_theme_name);
    if (!icon_theme_path) {
	g_warning("!icon_theme_path");
    }
    
    mimefile = MIME_ICON_get_local_xml_file(icon_theme_path);
    g_free(icon_theme_path);
    
    {
       doc = xmlNewDoc("1.0");
       doc->children = xmlNewDocRawNode(doc, NULL, "mime-info", NULL);

       rootM = (xmlNodePtr) doc->children;
       xmlDocSetRootElement(doc, rootM);
    }   
   
    /* write xml out */
    gtk_tree_model_foreach((GtkTreeModel *)store, xmladd,NULL);
    
    xmlSaveFormatFile(mimefile, doc, 1);

    xmlFreeDoc(doc);
    { 
 		GtkWidget *dialog = gtk_message_dialog_new ((GtkWindow *)xfmime_edit,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_INFO,
                                  GTK_BUTTONS_CLOSE,mimefile);
 		gtk_dialog_run (GTK_DIALOG (dialog));
 		gtk_widget_destroy (dialog);
    }
    g_free(mimefile);

    
}

void
on_save_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
	writexml();
}


void
on_quit_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


gboolean on_drag_motion(GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    GdkDragAction action;

    /*printf("DBG:  on_drag_motion \n"); */



    /* Insert code to get our default action here. */
	action = GDK_ACTION_COPY;




	gdk_drag_status(dc, GDK_ACTION_COPY, t);
    /*fprintf(stderr,"dbg: drag motion done...\n"); */



    return (TRUE);
}

static GdkPixbuf *render_icon(gchar *b){
    GdkPixbuf *icon;
    
    if (strncmp(b,"gtk-",strlen("gtk-"))==0)
	icon=gtk_widget_render_icon(xfmime_edit, b, GTK_ICON_SIZE_DIALOG, NULL);
    else 
    {
#if 0
#ifdef HAVE_LIBRSVG
	gchar *p=strrchr(b,'.');
	if (p && strcmp(p,".svg")==0) {
	    GError *error = NULL;
	    gchar *file=MIME_ICON_find_pixmap_file(b);
	    icon=rsvg_pixbuf_from_file_at_size((const gchar *)file,48,48,&error);
	    g_free(file);
	    if (error) g_error_free(error);
	} else
#endif	
#endif	
	icon = MIME_ICON_create_pixbuf(b);
    }
    return icon;
}

static GdkPixbuf *dead_icon(void){
    GdkPixbuf *icon;
    icon = gtk_image_get_pixbuf((GtkImage *) MIME_ICON_create_pixmap(xfmime_edit, "d-pirate.png"));
    /*if (!icon) printf("DBG: cannot render d-pirate.png\n");*/
    return icon;
}



void on_drag_data(GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, void *client)
{
    gchar *g,*b
	    ;
    int title_offset=0;
    GtkTreePath *treepath;
    GtkTreeIter iter;
    GdkPixbuf *icon=NULL;  
    GtkTreeView *treeview = (GtkTreeView *)widget; 

    if(!widget || data->length < 0 || data->format != 8)
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }

    if(!(info == TARGET_STRING) && !(info == TARGET_URI_LIST))
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }

    if (gtk_tree_view_get_headers_visible(treeview)){
  	PangoRectangle logical_rect;
  	PangoLayout *layout = gtk_widget_create_pango_layout((GtkWidget *)treeview,"W");
  	pango_layout_get_pixel_extents(layout, NULL, &logical_rect);
  	title_offset= PANGO_ASCENT(logical_rect) + PANGO_DESCENT(logical_rect);
  	g_object_unref(layout);
	title_offset +=8;
    } 
    
    if(!gtk_tree_view_get_path_at_pos(treeview, x,  y - title_offset, &treepath, NULL, NULL, NULL))
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return ;
    }
    gtk_tree_model_get_iter((GtkTreeModel *)store, &iter, treepath);
    gtk_tree_path_free(treepath);


    
    if (!strstr((const char *) data->data,"file:")) 
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    g=g_strdup((const char *) data->data);
    if (strstr(g,"\n")) *(strstr(g,"\n"))=0;
    if (strstr(g,"\r")) *(strstr(g,"\r"))=0;

    
    b=g_path_get_basename(g);
  /*
    {
      gtk_tree_model_get((GtkTreeModel *)store, &iter, NAME_COLUMN,&n, -1);
      printf("DBG:drag data=%s->%s\n",n,b); 
      g_free(n);
      }
      */
    
    
    
    icon = render_icon(b);
    /*if (!icon){
	GtkWidget *dialog = gtk_message_dialog_new ((GtkWindow *)xfmime_edit,
                               GTK_DIALOG_DESTROY_WITH_PARENT,
                               GTK_MESSAGE_ERROR,
                               GTK_BUTTONS_CLOSE,"%s\n",g);
 	gtk_dialog_run (GTK_DIALOG (dialog));
 	gtk_widget_destroy (dialog);
    }*/
    if (!icon) icon=dead_icon();
    if (icon) {
	    gtk_tree_store_set(store, &iter, PIXBUF_COLUMN, icon,-1);
	    gtk_tree_store_set(store, &iter, ICON_COLUMN, b,-1);
    } 
    
    g_free(b);
    g_free(g);
    gtk_drag_finish(context, TRUE, FALSE, time);
}



typedef struct column_info_t
{
    int id;
    GType type;
}
column_info_t;

gchar *compare_p(gchar *na){
    gchar *pa;
    /*if (strncmp(na,"application/x-",strlen("application/x-"))==0){
	pa = na + strlen("application/x-");
    } else if (strncmp(na,"application/",strlen("application/"))==0){
	pa = na + strlen("application/");
    } else */
    pa=na;
    return pa;
}
gint IterCompareFunc(GtkTreeModel *treemodel, GtkTreeIter *a,GtkTreeIter *b, gpointer user_data){
    gchar *na,*nb,*pa=NULL,*pb=NULL;
    gtk_tree_model_get(treemodel, a, NAME_COLUMN, &na, -1);
    gtk_tree_model_get(treemodel, b, NAME_COLUMN, &nb, -1);
    if (!na && !nb) {
	return 0;
    }
    if (!na){
       	return 1;
    }
    if (!nb) {
	return -1;
    }
	
    pa = compare_p(na);
    pb = compare_p(nb);
    /*printf("DBG %s==%s\n",pa,pb);*/
    return strcmp(pa,pb);
}
gint IterCompareFunc2(GtkTreeModel *treemodel, GtkTreeIter *a,GtkTreeIter *b, gpointer user_data){
    gchar *na,*nb,*pa=NULL,*pb=NULL;
    gtk_tree_model_get(treemodel, a, ICON_COLUMN, &na, -1);
    gtk_tree_model_get(treemodel, b, ICON_COLUMN, &nb, -1);
    if (!na && !nb) {
	return 0;
    }
    if (!na){
       	return 1;
    }
    if (!nb) {
	return -1;
    }
	
    pa = compare_p(na);
    pb = compare_p(nb);
    /*printf("DBG %s==%s\n",pa,pb);*/
    return strcmp(pa,pb);
}

GtkTreeStore *create_treestore(void)
{
    GtkTreeStore *ts;
    GtkTreeSortable *sortable;
       column_info_t column_info[] = {

	{PIXBUF_COLUMN, GDK_TYPE_PIXBUF},
	{GROUP_COLUMN, G_TYPE_STRING},
	{NAME_COLUMN, G_TYPE_STRING},
	{ICON_COLUMN, G_TYPE_STRING}
    };
    ts = gtk_tree_store_new(TREE_COLUMNS, 
		column_info[PIXBUF_COLUMN].type, 
		column_info[GROUP_COLUMN].type, 
		column_info[NAME_COLUMN].type,
		column_info[ICON_COLUMN].type);
    
    sortable=GTK_TREE_SORTABLE((GtkTreeStore *)ts);
    gtk_tree_sortable_set_sort_func(sortable,NAME_COLUMN,IterCompareFunc,NULL,NULL);
    gtk_tree_sortable_set_sort_column_id (sortable,NAME_COLUMN,GTK_SORT_ASCENDING);
    return ts;
}
GtkTreeStore *create_treestore2(void)
{
    GtkTreeStore *ts;
    GtkTreeSortable *sortable;
       column_info_t column_info[] = {

	{PIXBUF_COLUMN, GDK_TYPE_PIXBUF},
	{GROUP_COLUMN, G_TYPE_STRING},
	{NAME_COLUMN, G_TYPE_STRING},
	{ICON_COLUMN, G_TYPE_STRING}
    };
    ts = gtk_tree_store_new(TREE_COLUMNS, 
		column_info[PIXBUF_COLUMN].type, 
		column_info[GROUP_COLUMN].type, 
		column_info[NAME_COLUMN].type,
		column_info[ICON_COLUMN].type);
    
    sortable=GTK_TREE_SORTABLE((GtkTreeStore *)ts);
    gtk_tree_sortable_set_sort_func(sortable,ICON_COLUMN,IterCompareFunc2,NULL,NULL);
    gtk_tree_sortable_set_sort_column_id (sortable,ICON_COLUMN,GTK_SORT_ASCENDING);
    return ts;
}

gboolean group_found;
gboolean name_found;
gchar *icon_value;
static gboolean find_row(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    char *name = g_strdup  ((const gchar *) data);
    char *n;
    GdkPixbuf *icon=NULL;   

    if (name_found) return TRUE;
    
    gtk_tree_model_get(treemodel, iter, NAME_COLUMN, &n, -1);

    if (n &&  strcmp(n,name)==0){ 
	    
	    /*printf("duplicate %s==%s, looking for icon %s\n",n,name,id);*/
	    name_found=TRUE;
	    if (icon_value && strlen(icon_value)) {
		    icon=render_icon(icon_value);
		    /*
		    if (strncmp(icon_value,"gtk-",strlen("gtk-"))==0) 
			    icon=gtk_widget_render_icon(xfmime_edit, icon_value, GTK_ICON_SIZE_DIALOG, NULL);
	            else 
			    icon = gtk_image_get_pixbuf((GtkImage *) MIME_ICON_create_pixmap(xfmime_edit, icon_value));*/
		    if (!icon) {
			/*printf("DBG:dead_icon() for %s\n",name);*/
			icon=dead_icon();
		    }
		    if (icon) {
			    gtk_tree_store_set((GtkTreeStore *) store, iter, PIXBUF_COLUMN, icon,-1);
   			    g_object_unref (G_OBJECT (icon));
		    }
		    gtk_tree_store_set((GtkTreeStore *) store, iter, ICON_COLUMN, icon_value,-1);
	    }
    } 
    
    g_free(n);
    
    g_free(name);
    return FALSE;
}


gboolean   unref_row    (GtkTreeModel *model,
                                             GtkTreePath *path,
                                             GtkTreeIter *iter,
                                             gpointer data){
     gtk_tree_model_unref_node (model,iter);
     return FALSE;
}

static gboolean find_name(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data){
    char *name =(gchar *) data;
    gchar *n;
    if (name_found) return TRUE;
    gtk_tree_model_get(treemodel, iter, NAME_COLUMN, &n, -1);
    if (strcmp(name,n)==0) {
	name_found=TRUE;
	return TRUE;
    }
    return FALSE;
}


static gboolean find_type(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data)
{
    char *name = g_strdup  ((const gchar *) data);
    char *n,*g,*group;

    if (name_found) return TRUE;
    if (!strstr(name,"/")){
	    g_free(name);
	    return FALSE;
    }
    group = g_strdup(name);
    *(strchr(group,'/')) = 0;   /* group = strtok(group,"/");*/
    gtk_tree_model_get(treemodel, iter, GROUP_COLUMN, &g, -1);
    gtk_tree_model_get(treemodel, iter, NAME_COLUMN, &n, -1);
    if (g && strcmp(g,group)==0){
	    GtkTreeIter child;
	    group_found=TRUE;
	    if (!name_found && strcmp(n,name)!=0) {
	      gtk_tree_store_insert (store, &child, iter, 0);
	      /*if (strstr(name,"pgp"))printf("DBG:adding now %s\n",name);*/
	      gtk_tree_store_set((GtkTreeStore *) store, &child, NAME_COLUMN, name,-1);
	      name_found=TRUE;
	    }
    }
    if (g) g_free(g);
    
    if (n) g_free(n);
    g_free(name);
    g_free(group);
    return FALSE;
}
	  
int insert_dir(const gchar *in_theme_dir,const gchar *subdir,GtkTreeIter *parent){
    GtkTreeIter child,grandchild;
    gboolean ok=FALSE;
    gchar *n=g_build_filename(in_theme_dir,subdir,NULL);
    D(printf("DBG: inserting %s\n",n);)
    if (g_file_test(n,G_FILE_TEST_IS_DIR)){
	GDir *gdir;
	const char *file;
        gtk_tree_store_insert (store2, &child,parent,0);
        gtk_tree_store_set((GtkTreeStore *) store2, &child, ICON_COLUMN, subdir,-1);
	if ((gdir = g_dir_open(n, 0, NULL)) != NULL) {
	    while((file = g_dir_read_name(gdir))) {
		char *path = g_build_filename(n, file, NULL);
		if(g_file_test(path, G_FILE_TEST_IS_DIR))
		{
		    int r=insert_dir((const gchar *)n,file,&child);
		    if (r) ok=TRUE;
		    g_free(path);
		    continue;
		}
		g_free(path); 
		if (file && (strstr(file,".xpm")||strstr(file,".png")||strstr(file,".svg"))){
		    GdkPixbuf *icon=NULL;   
		    ok=TRUE;
		    gtk_tree_store_append (store2, &grandchild,&child);
		    gtk_tree_store_set((GtkTreeStore *) store2, &grandchild, ICON_COLUMN, file,-1);
		    icon=render_icon((gchar *)file);
		    if (!icon) {
			DD(printf("DBG: unable to render %s\n",file);)
			DD(printf("DBG:  (at %s)\n",n);)
			icon=dead_icon();
		    }

		    /* icon = gtk_image_get_pixbuf((GtkImage *) MIME_ICON_create_pixmap(xfmime_edit, file));*/
		    if (icon) {
			gtk_tree_store_set((GtkTreeStore *) store2, &grandchild, PIXBUF_COLUMN, icon,-1);
			g_object_unref (G_OBJECT (icon));
		    } 
		}
		D(else printf("DBG: %s is not rendered\n",file);)
	    }
	    g_dir_close(gdir);
	    if (!ok) {
		gtk_tree_store_remove(store2, &child);
	    }
	}
    }
    g_free(n);
    return ok;
}

static gboolean create_icon_tree2(void){
    GtkTreeIter iter;
    GtkTreeIter child;
    gchar *in_theme_dir=NULL;
    
    if (store2){
    	gtk_tree_model_foreach((GtkTreeModel *)store2, unref_row, NULL);
	gtk_tree_store_clear (store2);
    } else store2=create_treestore2();

    /* insert fallback hicolor  directory*/
    in_theme_dir=MIME_ICON_get_theme_path("hicolor");
    if (in_theme_dir) {
	printf("inserting %s\n",in_theme_dir);
	gtk_tree_store_append (store2, &iter, NULL);
	gtk_tree_store_set((GtkTreeStore *) store2, &iter, ICON_COLUMN, "hicolor",-1);
	insert_dir(in_theme_dir,"48x48",&iter);
	insert_dir(in_theme_dir,"scalable",&iter);
    }

    /* insert theme dir*/
    g_free(in_theme_dir);
    in_theme_dir=MIME_ICON_get_theme_path(icon_theme_name);
    if (g_file_test(in_theme_dir,G_FILE_TEST_IS_DIR)){
	gtk_tree_store_insert (store2, &iter, NULL,0);
	gtk_tree_store_set((GtkTreeStore *) store2, &iter, ICON_COLUMN, icon_theme_name,-1);
	insert_dir(in_theme_dir,"48x48",&iter);
	insert_dir(in_theme_dir,"scalable",&iter);
    }
    /*else printf("%s not a dir\n",in_theme_dir);*/
    g_free(in_theme_dir);in_theme_dir=NULL;

  
    {
       gchar **p,*stocks[]=STOCK_STUFF;
       gtk_tree_store_append (store2, &iter,NULL);
       gtk_tree_store_set((GtkTreeStore *) store2, &iter, ICON_COLUMN, "gtk-stock",-1);
       for (p=stocks;p && *p; p++){
	    GdkPixbuf *icon=NULL;   
	    gtk_tree_store_append (store2, &child,&iter);
	    /*printf("gtk -> %s\n",*p);*/
	    gtk_tree_store_set((GtkTreeStore *) store2, &child, ICON_COLUMN, *p,-1);
	    
	    icon=gtk_widget_render_icon(xfmime_edit, *p, GTK_ICON_SIZE_DIALOG, NULL);
	    if (icon) {
	      gtk_tree_store_set((GtkTreeStore *) store2, &child, PIXBUF_COLUMN, icon,-1);
	      g_object_unref (G_OBJECT (icon));
	    } 
       }
    }
       
    return TRUE;
}


static gboolean create_icon_tree(void){
    gchar *typesfile;
    xmlDocPtr doc;
    xmlChar *id;
    xmlNodePtr node;
    int i;

    MIME_ICON_load_theme();

    if (store){
    	gtk_tree_model_foreach((GtkTreeModel *)store, unref_row, NULL);
	gtk_tree_store_clear (store);
    } else store=create_treestore();

 
    if (!get_xml_files()) goto error_xml;
    

    /*********************** types defined in freedesktop.xml and xfce.xml ***/
    for (i=0;i<2;i++){
	gchar *tfiles[2]={"freedesktop.org.xml", "xfce.org.xml"};

	typesfile=g_strconcat(PACKAGE_DATA_DIR,
		    G_DIR_SEPARATOR_S,"xfce4",
		    G_DIR_SEPARATOR_S,"mime",
		    G_DIR_SEPARATOR_S,tfiles[i],NULL);

	
    	if (access(typesfile,F_OK)!=0) continue;    
    	xmlKeepBlanksDefault(0);
    	if((doc = xmlParseFile(typesfile)) == NULL)
    	{
		g_warning("xmlParseFile(%s) != NULL", typesfile);
		continue;
	}
    	node = xmlDocGetRootElement(doc);
    	if(!xmlStrEqual(node->name, (const xmlChar *)"mime-info"))
    	{
        	xmlFreeDoc(doc);
		continue;
    	}
    	for(node = node->children; node; node = node->next)
    	{
		if(xmlStrEqual(node->name, (const xmlChar *)"mime-type"))
		{
	   	 id = xmlGetProp(node, (const xmlChar *)"type");
		 if (id && strchr(id,'/')){
			GtkTreeIter iter;
			GtkTreeIter child;
			name_found=group_found=FALSE;
			gtk_tree_model_foreach((GtkTreeModel *)store, find_name,id);
			if (!name_found) {
		 	  gtk_tree_model_foreach((GtkTreeModel *)store, find_type,id);
			  if (!group_found){
				gchar *n,*g=strdup(id);
				*(strchr(g,'/')) = 0; /*g=strtok(g,"/");*/
				n=g_strconcat(g,"/default",NULL);
		  		gtk_tree_store_insert (store, &iter, NULL,0);
		  		gtk_tree_store_set((GtkTreeStore *) store, &iter, GROUP_COLUMN, g,-1);
				gtk_tree_store_set((GtkTreeStore *) store, &iter, NAME_COLUMN, n,-1);
				/*printf("DBG:adding %s\n",n);*/
				g_free(n);
				g_free(g);
		  		gtk_tree_store_insert (store, &child, &iter, 0);
				gtk_tree_store_set((GtkTreeStore *) store, &child, NAME_COLUMN, id,-1);
			  }
			}
		 	g_free(id);
		 }
		}
	}
    	xmlFreeDoc(doc); 
	g_free(typesfile);
    }
    
    /********************   icons defined in mime.types ***************/
    xmlKeepBlanksDefault(0);
    
    if((doc = xmlParseFile(xml_file)) == NULL)
    {
      error_xml:
	g_message("xmlParseFile(%s) != NULL", xml_file);
	return FALSE;
	goto time2return;
    }
    node = xmlDocGetRootElement(doc);
    if(!xmlStrEqual(node->name, (const xmlChar *)"mime-info"))
    {
        xmlFreeDoc(doc);
	goto error_xml;
    }

    /* Now parse the xml tree */
    /*printf("DBG: parsing %s\n",mimefile);*/
    for(node = node->children; node; node = node->next)
    {
	if(xmlStrEqual(node->name, (const xmlChar *)"mime-type"))
	{
	    id = xmlGetProp(node, (const xmlChar *)"type");
	    icon_value = xmlGetProp(node, (const xmlChar *)"icon");
	    
	    if (id && icon_value) {
		name_found=FALSE;
		if(!style) style = gtk_style_new();
		gtk_tree_model_foreach((GtkTreeModel *)store, find_row,id);
		if (!name_found){
			g_warning("%s %s",strerror(EINVAL),id);
		}
	

	    }
	    if (icon_value) g_free(icon_value); 
	    if (id) g_free(id); 
	}
    }

    xmlFreeDoc(doc);
    
time2return:
    return TRUE;
}

#if 0
gint changer;
GtkWidget *dialog;
static gint change_theme(gpointer data){
	GtkLabel		*label;
	gchar			*txt;
	GtkOptionMenu *om=(GtkOptionMenu *)data;
	g_source_remove(changer);
	label = GTK_LABEL (gtk_bin_get_child(GTK_BIN(om)));
	g_free(theme_dir);
	theme_dir = txt = g_strdup (gtk_label_get_text (label));
  	create_icon_tree(txt);
  	create_icon_tree2(txt);
	gtk_main_quit();
	gtk_widget_destroy(dialog);
    
	return FALSE;
}

void theme_changed (GtkOptionMenu *om, gpointer user_data){
	gchar *message_format;
	GtkLabel *label = GTK_LABEL (gtk_bin_get_child(GTK_BIN(om)));
	if (!get_xml_files(gtk_label_get_text (label))) return;
	if (no_xml_file) message_format = g_strdup_printf("%s\n%s",strerror(ENOENT),no_xml_file);
	else  message_format = g_strdup_printf("%s",xml_file);
	dialog = gtk_message_dialog_new ((GtkWindow *)xfmime_edit,GTK_DIALOG_MODAL|GTK_DIALOG_DESTROY_WITH_PARENT,
                                             ((no_xml_file)?GTK_MESSAGE_WARNING:GTK_MESSAGE_INFO),
                                             GTK_BUTTONS_NONE,
					     (const gchar *)message_format);
	gtk_window_set_transient_for (GTK_WINDOW (xfmime_edit),  GTK_WINDOW (dialog));
        changer=g_timeout_add_full(0, 260, (GtkFunction) change_theme, (gpointer)(om), NULL);
	gtk_widget_show_all(dialog);
	gtk_main();
	g_free(message_format);
}
#endif

static gboolean icon_changed(GtkCellRendererText *cell,
	     const gchar         *path_string,
	     const gchar         *new_text,
	     gpointer             data)
{             
    GtkTreeModel *model = (GtkTreeModel *)store;
    GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
    GtkTreeIter iter;
    GdkPixbuf *icon=NULL;   

    gint *column;

    column = g_object_get_data (G_OBJECT (cell), "column");

    gtk_tree_model_get_iter (model, &iter, path);

    if (GPOINTER_TO_INT (column) == ICON_COLUMN) {
	gchar *old_text;
        gtk_tree_model_get (model, &iter, column, &old_text, -1);
	g_free (old_text);
	if (!new_text) gtk_tree_store_set (store, &iter, column,"",-1);
	else gtk_tree_store_set (store, &iter, column,new_text,-1);
	if (new_text && strlen(new_text)){
	  icon=render_icon((gchar *)new_text);
	  if (!icon) icon=dead_icon();
	  /*if (strncmp(new_text,"gtk-",strlen("gtk-"))==0){
	   icon = gtk_widget_render_icon(xfmime_edit, new_text, GTK_ICON_SIZE_DIALOG, NULL);
	  } else {
	   icon = gtk_image_get_pixbuf((GtkImage *) MIME_ICON_create_pixmap(xfmime_edit,new_text ));
	  }*/
	}
	gtk_tree_store_set(store, &iter, PIXBUF_COLUMN, icon,-1);
      	/*if (!icon){ 
 		GtkWidget *dialog = gtk_message_dialog_new ((GtkWindow *)xfmime_edit,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,"%s\n",new_text);
 		gtk_dialog_run (GTK_DIALOG (dialog));
 		gtk_widget_destroy (dialog);
	}*/


    }
    gtk_tree_path_free (path);
    
    return FALSE;
}

void mk_treeview(){
  GtkCellRenderer *cell;
  GtkTreeViewColumn *column;
  treeview =(GtkTreeView *)lookup_widget((GtkWidget *)xfmime_edit,"treeview1");
  gtk_tree_view_set_model (treeview,(GtkTreeModel *)store);
   gtk_tree_view_set_headers_visible(treeview,FALSE);

  gtk_drag_dest_set((GtkWidget *) treeview, GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_HIGHLIGHT, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

  gtk_drag_source_set((GtkWidget *) treeview, GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    /* create the pixbuf column */
    column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);

    cell = gtk_cell_renderer_pixbuf_new();
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "pixbuf", PIXBUF_COLUMN, 
		    "pixbuf_expander_closed", PIXBUF_COLUMN, 
		    "pixbuf_expander_open", PIXBUF_COLUMN, 
		    NULL);


    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    gtk_tree_view_set_expander_column(treeview, column);

    /* group */ 

    column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);
    cell = gtk_cell_renderer_text_new();
    g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_clickable(column, TRUE);

    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "text", GROUP_COLUMN, 
		    NULL);
     gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);

     /* name */
     column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);
    cell = gtk_cell_renderer_text_new();
    g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_clickable(column, TRUE);

    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "text", NAME_COLUMN, 
		    NULL);
     gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    
      /* iconfile */
     column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);
    cell = gtk_cell_renderer_text_new();
    g_object_set(G_OBJECT(cell), "editable", TRUE, NULL);
    g_signal_connect (G_OBJECT (cell), "edited",
		      G_CALLBACK (icon_changed), NULL);
    g_object_set_data (G_OBJECT (cell), "column", (gint *)ICON_COLUMN);

    
    gtk_tree_view_column_set_clickable(column, TRUE);

    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "text", ICON_COLUMN, 
		    NULL);
     gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);

}

void mk_treeview2(void){
  GtkCellRenderer *cell;
  GtkTreeViewColumn *column;
  treeview2 =(GtkTreeView *)lookup_widget((GtkWidget *)xfmime_edit,"treeview2");
  gtk_tree_view_set_model (treeview2,(GtkTreeModel *)store2);
   
   gtk_tree_view_set_headers_visible(treeview2,FALSE);


  gtk_drag_source_set((GtkWidget *) treeview2, GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

    /* create the pixbuf column */
    column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);

    cell = gtk_cell_renderer_pixbuf_new();
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "pixbuf", PIXBUF_COLUMN, 
		    "pixbuf_expander_closed", PIXBUF_COLUMN, 
		    "pixbuf_expander_open", PIXBUF_COLUMN, 
		    NULL);


    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview2), column);
    gtk_tree_view_set_expander_column(treeview2, column);


     /* name */
     column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_reorderable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);
    cell = gtk_cell_renderer_text_new();
    g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_clickable(column, TRUE);

    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "text", ICON_COLUMN, 
		    NULL);
     gtk_tree_view_append_column(GTK_TREE_VIEW(treeview2), column);
}

int
main (int argc, char *argv[])
{
  gtk_set_locale ();
  gtk_init (&argc, &argv); 

  
  xfmime_edit = create_xfmime_edit ();

#if GTK_CHECK_VERSION (2,4,0)
    g_object_get (gtk_settings_get_default(), "gtk-icon-theme-name", &icon_theme_name, NULL);
#else /* gtk < 2.4 */
    {
      GtkSettings *gsettings = gtk_settings_get_default ();
      g_object_get (G_OBJECT (gsettings), "gtk-icon-theme-name", &icon_theme_name, NULL);
    }
#endif

    create_icon_tree();
    create_icon_tree2();
  

  /* treeview */
  mk_treeview();
  mk_treeview2();
  gtk_widget_show (xfmime_edit);
  g_signal_connect ((gpointer) xfmime_edit, "destroy",
                    G_CALLBACK (on_quit_clicked),
                    NULL);

  
  gtk_main ();
  return 0;
}

