%define name	xine-ui
%define version	0.99.3
%define release	1

%define major   1
%define libname libxine%{major}
%define libvers 1

%define skindir    %{_datadir}/xine/skins
%define deskdir    %{_datadir}/xine/desktop

%define	ginstall install -c

Name:        %{name}
Summary:     A Free Audio/Video Player.
Summary(cs): Voln audio a video pehrva
Summary(de): Ein freies Audio- und Video-Abspielprogramm
Version:     %{version}
Release:     %{release}
Copyright:   GPL
Group:       Applications/Multimedia
Source:      http://xinehq.de/files/%{name}-%{version}.tar.gz
URL:         http://xinehq.de
Packager:    Manfred Tremmel <Manfred.Tremmel@iiv.de>
Requires:    %{libname} >= %{libvers}
Requires:    curl
Requires:    readline
BuildPreReq: %{libname}-devel >= %{libvers}
BuildRoot:   %{_tmppath}/%{name}-buildroot

%description
xine is a fully-featured free audio/video player for unix-like systems which
uses libxine for audio/video decoding and playback. For more informations on
what formats are supported, please refer to the libxine documentation.

%description -l cs
xine je vceelov voln iiteln audio a video pehrva pro unixovsk
systmy, kter pouv libxine k dekdovn zvuku a videa a k pehrvn.
Vce informac o tom, jak formty jsou podporovny zskte v dokumentaci
od libxine.

%description -l de
xine ist ein freies Audio- und Video-Abspielprogramm fr unixartige Systeme
mit umfassenden Funktionen. Zur Audio- und Videodekodierung und Wiedergabe
werden die xine-Bibliotheken aus libxine verwendet. Weitere Informationen
ber die untersttzten Formate entnehmen Sie in der Dokumentation zu libxine.

%prep
%setup -n %{name}-%{version}

%build
export CFLAGS="${RPM_OPT_FLAGS}"
export XINE_DOCPATH="%{_docdir}/xine-ui"

if [ ! -f configure ]; then
   NO_CONFIGURE=1 ./autogen.sh
fi

#
# currently we do not use %%configure as it seems to cause trouble with
# certain automake produced configure scripts - depending on automake version.
#
./configure --build=%{_target_platform} --prefix=%{_prefix} \
	    --exec-prefix=%{_exec_prefix} --bindir=%{_bindir} \
	    --sbindir=%{_sbindir} --sysconfdir=%{_sysconfdir} \
	    --datadir=%{_datadir} --includedir=%{_includedir} \
	    --libdir=%{_libdir} --libexecdir=%{_libexecdir} \
	    --localstatedir=%{_localstatedir} \
	    --sharedstatedir=%{_sharedstatedir} --mandir=%{_mandir} \
	    --infodir=%{_infodir}
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=%{?buildroot:%{buildroot}} install
install -m 644 misc/desktops/xine.wmconfig %{?buildroot:%{buildroot}}%{deskdir}/

%post
if [ "$1" = "1" ] || [ "$1" = "2" ] ; then # install or update
  if test -d %{skindir}/metal; then rm -rf %{skindir}/metal; fi
  if test -d %{skindir}/default; then rm -rf %{skindir}/default && ln -s %{skindir}/xinetic %{skindir}/default; fi

  if test ! -d %{_datadir}/icons; then
    %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/icons
  fi
  %{ginstall} -m 644 -o 0 -g 0 %{_datadir}/pixmaps/xine.xpm %{_datadir}/icons/xine.xpm
  if test ! -d %{_datadir}/pixmaps; then
    %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/pixmaps
  fi
  if test -d %{_sysconfdir}/X11/wmconfig; then
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.wmconfig %{_sysconfdir}/X11/wmconfig/xine
  fi
  if test -d %{_sysconfdir}/X11/applnk; then
    if test ! -d %{_sysconfdir}/X11/applnk/Multimedia; then
      %{ginstall} -m 755 -o 0 -g 0 -d %{_sysconfdir}/X11/applnk/Multimedia
    fi
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_sysconfdir}/X11/applnk/Multimedia/xine.desktop
  fi
  # End Icons
  # Gnome
  if test -d /opt/gnome; then
    if test ! -d /opt/gnome/share/pixmaps; then
      %{ginstall} -m 755 -o 0 -g 0 -d /opt/gnome/share/pixmaps
    fi
    %{ginstall} -m 644 -o 0 -g 0 %{_datadir}/pixmaps/xine.xpm /opt/gnome/share/pixmaps/xine.xpm
    if test -d /opt/gnome/share/gnome/apps/Multimedia; then
      %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/gnome/share/gnome/apps/Multimedia/xine.desktop
    else
      %{ginstall} -m 755 -o 0 -g 0 -d /opt/gnome/share/gnome/apps/Multimedia
      %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/gnome/share/gnome/apps/Multimedia/xine.desktop
    fi
  else
    if test -d %{_datadir}/gnome/apps; then
      if test -d %{_datadir}/gnome/apps/Multimedia; then
        %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/gnome/apps/Multimedia/xine.desktop
      else
        %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/gnome/apps/Multimedia
        %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/gnome/apps/Multimedia/xine.desktop
      fi
    fi
  fi
  # End Gnome
  # Kde3
  if test -d /opt/kde3/; then
    DIR_HI3=/opt/kde3/share/icons/hicolor
    DIR_LO3=/opt/kde3/share/icons/locolor
    HIRES3='48x48 32x32 22x22'
    LORES3='32x32 22x22 16x16'
    for hires in $HIRES3; do
      %{ginstall} -m 755 -o 0 -g 0 -d $DIR_HI3/$hires/apps
      %{ginstall} -m 644 -o 0 -g 0 %{_datadir}/pixmaps/xine_$hires.png $DIR_HI3/$hires/apps/xine.png
    done
    for lores in $LORES3; do
      %{ginstall} -m 755 -o 0 -g 0 -d $DIR_LO3/$lores/apps
      %{ginstall} -m 644 -o 0 -g 0 %{_datadir}/pixmaps/xine_$lores.png $DIR_LO3/$lores/apps/xine.png
    done
    if test ! -d /opt/kde3/share/applnk/Multimedia; then
      %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde3/share/applnk/Multimedia
    fi
    cat %{deskdir}/xine.desktop | sed -e "s/Icon=xine.xpm/Icon=xine/g" -e "s/Exec=xine/Exec=xine %U/g" > %{deskdir}/xine.desktop.kde
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop.kde /opt/kde3/share/applnk/Multimedia/xine.desktop
    rm %{deskdir}/xine.desktop.kde
  fi
  # End Kde3
  # Kde2
  if test -d /opt/kde2/; then
    DIR_HI=/opt/kde2/share/icons/hicolor
    DIR_LO=/opt/kde2/share/icons/locolor
    HIRES='48x48 32x32 22x22'
    LORES='32x32 22x22 16x16'
    for hires in $HIRES; do
      %{ginstall} -m 755 -o 0 -g 0 -d $DIR_HI/$hires/apps
      %{ginstall} -m 644 -o 0 -g 0 %{_datadir}/pixmaps/xine_$hires.png $DIR_HI/$hires/apps/xine.png
    done
    for lores in $LORES; do
      %{ginstall} -m 755 -o 0 -g 0 -d $DIR_LO/$lores/apps
      %{ginstall} -m 644 -o 0 -g 0 %{_datadir}/pixmaps/xine_$lores.png $DIR_LO/$lores/apps/xine.png
    done
    if test ! -d /opt/kde2/share/applnk/Multimedia; then
      %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde2/share/applnk/Multimedia
    fi
    cat %{deskdir}/xine.desktop | sed -e "s/Icon=xine.xpm/Icon=xine/g" -e "s/Exec=xine/Exec=xine %U/g" > %{deskdir}/xine.desktop.kde
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop.kde /opt/kde2/share/applnk/Multimedia/xine.desktop
    rm %{deskdir}/xine.desktop.kde
  else
    if test -d %{_datadir}/applnk/Multimedia; then
      if test ! -d %{_datadir}/applnk/Multimedia; then
        %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/applnk/Multimedia
      fi
      %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/applnk/Multimedia/xine.desktop
    fi
  fi
  # End Kde2
  # Kde
  if test -d /opt/kde; then
    if test ! -d /opt/kde/share/icons; then
      %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde/share/icons
    fi
    if test ! -d /opt/kde/share/applnk/Multimedia; then
      %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde/share/applnk/Multimedia
    fi
    %{ginstall} -m 644 -o 0 -g 0 %{_datadir}/pixmaps/xine.xpm /opt/kde/share/icons/xine.xpm
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/kde/share/applnk/Multimedia/xine.desktop
  else
    if test -d %{_datadir}/applnk/Multimedia; then
      %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/applnk/Multimedia/xine.desktop
    fi
  fi
  # End Kde
fi

%preun
if [ "$1" = "0" ]; then # remove
  DIR_HI=/opt/kde2/share/icons/hicolor
  DIR_LO=/opt/kde2/share/icons/locolor
  DIR_HI3=/opt/kde3/share/icons/hicolor
  DIR_LO3=/opt/kde3/share/icons/locolor
  # icon dimensions
  HIRES='48x48 32x32 22x22'
  LORES='32x32 22x22 16x16'
  # files to remove
  REMOVALS='%{_datadir}/icons/xine.xpm %{_sysconfdir}/X11/wmconfig/xine %{_sysconfdir}/X11/applnk/Multimedia/xine.desktop /opt/gnome/share/pixmaps/xine.xpm /opt/gnome/share/gnome/apps/Multimedia/xine.desktop %{_datadir}/gnome/apps/Multimedia/xine.desktop /opt/kde2/share/applnk/Multimedia/xine.desktop /opt/kde3/share/applnk/Multimedia/xine.desktop  %{_datadir}/applnk/Multimedia/xine.desktop /opt/kde/share/icons/xine.xpm /opt/kde/share/applnk/Multimedia/xine.desktop %{_datadir}/applnk/Multimedia/xine.desktop'
  # remove files in $REMOVALS
  for remove in $REMOVALS; do
    rm -f $remove
  done
  # KDE2 icons
  for hires in $HIRES; do
    rm -f $DIR_HI/$hires/apps/xine.png
  done
  for lores in $LORES; do
    rm -f $DIR_LO/$lores/apps/xine.png
  done
  # KDE3 icons
  for hires in $HIRES; do
    rm -f $DIR_HI3/$hires/apps/xine.png
  done
  for lores in $LORES; do
    rm -f $DIR_LO3/$lores/apps/xine.png
  done
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc %{_docdir}/*
%doc %{_datadir}/doc/xitk/*
%{_bindir}/*xine*
%{skindir}/*
%{deskdir}/*
%{_datadir}/pixmaps/*
%{_datadir}/xine/visuals/*
%lang(de) %{_mandir}/de/man1/*
%lang(fr) %{_mandir}/fr/man1/*
%lang(es) %{_mandir}/es/man1/*
%lang(pl) %{_mandir}/pl/man1/*
%{_mandir}/man1/*
%{_datadir}/locale/*

%changelog
* Fri Apr 09 2004 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- removed ugly hack to use the right docdir end set XINE_DOCPATH instead
* Sun Jan 18 2004 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added readline and curl dependency
* Wed May 14 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update for > 0.9.20
* Sun Mar 09 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Some more cleanups
- lsf patch included
* Sat Jan 11 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Some cleanups
* Fri Dec 06 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- do post and pre only when install and remove, saves entries at update
* Sat Nov 16 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- replaced cvscompile.sh with autogen.sh
* Sat Nov 09 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Final changes for libxine 1.0alpha1
* Wed Nov 06 2002 Bill Fink <billfink@mindspring.com>
- Some more changes for latest xine version
* Mon Nov 04 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Changes for next xine version
* Sun Oct 27 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update of the german descriptions.
- fixed some problems with creating kde2 and kde3 menu-entry
* Mon May 27 2002 Matthias Dahl <matthew2k@web.de>
- added passing of build parameter to configure
* Sun May 26 2002 Matthias Dahl <matthew2k@web.de>
- added more kde2 and kde3 fixes by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sun May 20 2002 Matthias Dahl <matthew2k@web.de>
- added kde2 bugfix by Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added german description by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sun May 20 2002 Matthias Dahl <matthew2k@web.de>
- added kde3 support by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sat May 18 2002 Matthias Dahl <matthew2k@web.de>
- added czech translations by Frantisek Dvorak <valtri@atlas.cz>
* Thu May 16 2002 Matthias Dahl <matthew2k@web.de>
- replaced %configure because it was causing trouble on some configurations
* Sat May 11 2002 Matthias Dahl <matthew2k@web.de>
- reworked/revamped spec file, still needs some tuning (BuildPreReq, ...)
* Fri May 03 2002 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add xitk README file.
* Sun Mar 31 2002 Matthias Dahl <matthew2k@web.de>
- added xine-bugreport and xine-check, including their man pages.
- added german man pages and README_fi.
* Fri Dec 14 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add portuguese brazilian *.mo files: thanks to Miguel Freitas <miguel@cetuc.puc-rio.br> ;-)
* Tue Nov 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add spanish *.mo files: thanks to Juan Manuel Garca Molina <juanmagm@mail.com>
* Sun Nov 18 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add *.mo files
* Wed Oct 3 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- use DESTDIR for package building and add xineshot, based on patch from Andrew Meredith <andrew@anvil.org>
* Thu Sep 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add icons and desktop stuff from patches by Miguel Freitas <miguel@cetuc.puc-rio.br>
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Merge patch from Jos Carlos Monteiro <jcm@netcabo.pt>:
  - Filelist and other minor updates,
  - Fixed some SuSE compatibility issues,
  - Added Portuguese summary.
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add missing files.
* Thu Jul 26 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Made AA as separate package.
* Thu Jul 26 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist.
* Tue Jul 03 2001 Matthias Dahl <matthew2k@web.de>
- fixed the "no-skins-in-final-RPM-package" problem (nice explanation *grin*)
* Sun Jun 10 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist and the requirements field
- removed /sbin/ldconfig as post install script
* Thu Mar 28 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add korean summary, patch from Louis JANG <louis@ns.mizi.com>
* Thu Jan 11 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- patch from Sung-Hyun Nam <namsh@lgic.co.kr> applied.
* Fri Oct 17 2000 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- first spec file.
