/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class WindowPropertyGetter {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private final long actual_type = unsafe.allocateMemory(8L);
    private final long actual_format = unsafe.allocateMemory(4L);
    private final long nitems_ptr = unsafe.allocateMemory(8L);
    private final long bytes_after = unsafe.allocateMemory(8L);
    private final long data = unsafe.allocateMemory(8L);
    private final long window;
    private final XAtom property;
    private final long offset;
    private final long length;
    private final boolean auto_delete;
    private final long type;
    private boolean executed = false;
    private boolean disposed = false;

    public WindowPropertyGetter(long l2, XAtom xAtom, long l3, long l4, boolean bl2, long l5) {
        if (xAtom.getAtom() == 0L) {
            throw new IllegalArgumentException("Property ATOM should be initialized first:" + xAtom);
        }
        if (l2 == 0L) {
            throw new IllegalArgumentException("Window must not be zero");
        }
        this.window = l2;
        this.property = xAtom;
        this.offset = l3;
        this.length = l4;
        this.auto_delete = bl2;
        this.type = l5;
    }

    public WindowPropertyGetter(long l2, XAtom xAtom, long l3, long l4, boolean bl2, XAtom xAtom2) {
        this(l2, xAtom, l3, l4, bl2, xAtom2.getAtom());
    }

    public int execute() {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(XToolkit.XErrorHandler xErrorHandler) {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
        try {
            XToolkit.awtLock();
            if (this.executed) {
                throw new IllegalStateException("Already executed");
            }
            this.executed = true;
            if (xErrorHandler != null) {
                XToolkit.WITH_XERROR_HANDLER(xErrorHandler);
            }
            Native.putLong(this.data, 0L);
            int n2 = XlibWrapper.XGetWindowProperty(XToolkit.getDisplay(), this.window, this.property.getAtom(), this.offset, this.length, this.auto_delete ? 1 : 0, this.type, this.actual_type, this.actual_format, this.nitems_ptr, this.bytes_after, this.data);
            if (xErrorHandler != null) {
                XToolkit.RESTORE_XERROR_HANDLER();
            }
            int n3 = n2;
            return n3;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public int getActualFormat() {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return unsafe.getInt(this.actual_format);
    }

    public long getActualType() {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return XAtom.getAtom(this.actual_type);
    }

    public int getNumberOfItems() {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return (int)Native.getLong(this.nitems_ptr);
    }

    public long getData() {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
        return Native.getLong(this.data);
    }

    public long getBytesAfter() {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.bytes_after);
    }

    public void finalize() {
        if (XlibWrapper.isBuildInternal && !this.disposed) {
            System.err.println("WARNING: sun.awt.X11.WindowPropertyGetter not disposed till finalization!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            unsafe.freeMemory(this.actual_type);
            unsafe.freeMemory(this.actual_format);
            unsafe.freeMemory(this.nitems_ptr);
            unsafe.freeMemory(this.bytes_after);
            if (this.executed && this.getData() != 0L) {
                XlibWrapper.XFree(this.getData());
            }
            unsafe.freeMemory(this.data);
            this.disposed = true;
        }
    }
}

