/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeployClientAuthCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.util.Trace;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JDialog;

class CertificatesInfo {
    private LinkedHashMap activeTrustedCertsMap = new LinkedHashMap();
    private LinkedHashMap activeHttpsCertsMap = new LinkedHashMap();
    private LinkedHashMap activeRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeHttpsRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeClientAuthCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysTrustedCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysHttpsCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysHttpsRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysClientAuthCertsMap = new LinkedHashMap();

    public CertificatesInfo() {
        this.reset();
    }

    public Collection getTrustedCertificates(int n) {
        if (n == 0) {
            return this.activeTrustedCertsMap.keySet();
        }
        return this.activeSysTrustedCertsMap.keySet();
    }

    public Collection getHttpsCertificates(int n) {
        if (n == 0) {
            return this.activeHttpsCertsMap.keySet();
        }
        return this.activeSysHttpsCertsMap.keySet();
    }

    public Collection getRootCACertificates(int n) {
        if (n == 0) {
            return this.activeRootCACertsMap.keySet();
        }
        return this.activeSysRootCACertsMap.keySet();
    }

    public Collection getHttpsRootCACertificates(int n) {
        if (n == 0) {
            return this.activeHttpsRootCACertsMap.keySet();
        }
        return this.activeSysHttpsRootCACertsMap.keySet();
    }

    public Collection getClientAuthCertificates(int n) {
        if (n == 0) {
            return this.activeClientAuthCertsMap.keySet();
        }
        return this.activeSysClientAuthCertsMap.keySet();
    }

    public void removeTrustedCertificate(Certificate certificate) {
        DeploySigningCertStore deploySigningCertStore = new DeploySigningCertStore();
        try {
            deploySigningCertStore.load();
            deploySigningCertStore.remove(certificate);
            deploySigningCertStore.save();
            Object v = this.activeTrustedCertsMap.remove(certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeHttpsCertificate(Certificate certificate) {
        DeploySSLCertStore deploySSLCertStore = new DeploySSLCertStore();
        try {
            deploySSLCertStore.load();
            deploySSLCertStore.remove(certificate);
            deploySSLCertStore.save();
            Object v = this.activeHttpsCertsMap.remove(certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeRootCACertificate(Certificate certificate) {
        RootCertStore rootCertStore = RootCertStore.getInstance();
        try {
            rootCertStore.load();
            rootCertStore.remove(certificate);
            rootCertStore.save();
            Object v = this.activeRootCACertsMap.remove(certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeHttpsRootCACertificate(Certificate certificate) {
        SSLRootCertStore sSLRootCertStore = new SSLRootCertStore();
        try {
            sSLRootCertStore.load();
            sSLRootCertStore.remove(certificate);
            sSLRootCertStore.save();
            Object v = this.activeHttpsRootCACertsMap.remove(certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeClientAuthCertificate(JDialog jDialog, Certificate[] certificateArray) {
        DeployClientAuthCertStore deployClientAuthCertStore = new DeployClientAuthCertStore(jDialog);
        try {
            deployClientAuthCertStore.load();
            boolean bl = deployClientAuthCertStore.remove(certificateArray[0]);
            if (bl) {
                this.activeClientAuthCertsMap.remove(certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addTrustedCertificate(Certificate certificate) {
        DeploySigningCertStore deploySigningCertStore = new DeploySigningCertStore();
        try {
            deploySigningCertStore.load();
            deploySigningCertStore.add(certificate);
            deploySigningCertStore.save();
            this.activeTrustedCertsMap.put(certificate, certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addHttpsCertificate(Certificate certificate) {
        DeploySSLCertStore deploySSLCertStore = new DeploySSLCertStore();
        try {
            deploySSLCertStore.load();
            deploySSLCertStore.add(certificate);
            deploySSLCertStore.save();
            this.activeHttpsCertsMap.put(certificate, certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addCACertificate(Certificate certificate) {
        RootCertStore rootCertStore = RootCertStore.getInstance();
        try {
            rootCertStore.load();
            rootCertStore.add(certificate);
            rootCertStore.save();
            this.activeRootCACertsMap.put(certificate, certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addHttpsCACertificate(Certificate certificate) {
        SSLRootCertStore sSLRootCertStore = new SSLRootCertStore();
        try {
            sSLRootCertStore.load();
            sSLRootCertStore.add(certificate);
            sSLRootCertStore.save();
            this.activeHttpsRootCACertsMap.put(certificate, certificate);
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addClientAuthCertChain(JDialog jDialog, Certificate[] certificateArray, Key key) {
        DeployClientAuthCertStore deployClientAuthCertStore = new DeployClientAuthCertStore(jDialog);
        try {
            boolean bl;
            deployClientAuthCertStore.load();
            if (!deployClientAuthCertStore.contains(certificateArray[0]) && (bl = deployClientAuthCertStore.addCertKey(certificateArray, key))) {
                deployClientAuthCertStore.save();
                this.activeClientAuthCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void reset() {
        Certificate[] certificateArray;
        Iterator iterator;
        Iterator iterator2;
        CertStore certStore;
        this.activeTrustedCertsMap.clear();
        this.activeHttpsCertsMap.clear();
        this.activeRootCACertsMap.clear();
        this.activeHttpsRootCACertsMap.clear();
        this.activeClientAuthCertsMap.clear();
        this.activeSysTrustedCertsMap.clear();
        this.activeSysHttpsCertsMap.clear();
        this.activeSysRootCACertsMap.clear();
        this.activeSysHttpsRootCACertsMap.clear();
        this.activeSysClientAuthCertsMap.clear();
        try {
            certStore = new DeploySigningCertStore();
            certStore.load();
            iterator2 = certStore.iterator(0);
            iterator = certStore.iterator(1);
            while (iterator2.hasNext()) {
                certificateArray = (Certificate[])iterator2.next();
                this.activeTrustedCertsMap.put(certificateArray, certificateArray);
            }
            while (iterator.hasNext()) {
                certificateArray = (X509Certificate)iterator.next();
                this.activeSysTrustedCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        try {
            certStore = new DeploySSLCertStore();
            certStore.load();
            iterator2 = certStore.iterator(0);
            iterator = certStore.iterator(1);
            while (iterator2.hasNext()) {
                certificateArray = (X509Certificate)iterator2.next();
                this.activeHttpsCertsMap.put(certificateArray, certificateArray);
            }
            while (iterator.hasNext()) {
                certificateArray = (X509Certificate)iterator.next();
                this.activeSysHttpsCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        try {
            certStore = RootCertStore.getInstance();
            certStore.load();
            iterator2 = certStore.iterator(0);
            iterator = certStore.iterator(1);
            while (iterator2.hasNext()) {
                certificateArray = (X509Certificate)iterator2.next();
                this.activeRootCACertsMap.put(certificateArray, certificateArray);
            }
            while (iterator.hasNext()) {
                certificateArray = (X509Certificate)iterator.next();
                this.activeSysRootCACertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        try {
            certStore = new SSLRootCertStore();
            certStore.load();
            iterator2 = certStore.iterator(0);
            iterator = certStore.iterator(1);
            while (iterator2.hasNext()) {
                certificateArray = (X509Certificate)iterator2.next();
                this.activeHttpsRootCACertsMap.put(certificateArray, certificateArray);
            }
            while (iterator.hasNext()) {
                certificateArray = (X509Certificate)iterator.next();
                this.activeSysHttpsRootCACertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        try {
            certStore = new DeployClientAuthCertStore();
            ((DeployClientAuthCertStore)certStore).load();
            iterator2 = ((DeployClientAuthCertStore)certStore).iteratorChain(0);
            iterator = ((DeployClientAuthCertStore)certStore).iteratorChain(1);
            while (iterator2.hasNext()) {
                certificateArray = (Certificate[])iterator2.next();
                this.activeClientAuthCertsMap.put(certificateArray, certificateArray);
            }
            while (iterator.hasNext()) {
                certificateArray = (Certificate[])iterator.next();
                this.activeSysClientAuthCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

