/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;

    private /* synthetic */ void finit$() {
        this.count = 0;
        this.pos = 0;
        this.markpos = -1;
        this.marklimit = 0;
    }

    public BufferedInputStream(InputStream in) {
        this(in, 2048);
    }

    public BufferedInputStream(InputStream in, int size) {
        super(in);
        this.finit$();
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[size];
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + super.available();
    }

    public void close() throws IOException {
        this.buf = null;
        super.close();
    }

    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        if (this.markpos >= 0 && this.pos - this.markpos > this.marklimit) {
            this.markpos = -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        int remain = Math.min(this.count - this.pos, len);
        System.arraycopy(this.buf, this.pos, b, off, remain);
        this.pos += remain;
        if (this.markpos >= 0 && this.pos - this.markpos > this.marklimit) {
            this.markpos = -1;
        }
        return remain;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException();
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long n) throws IOException {
        long origN = n;
        while (n > 0L) {
            if (this.pos >= this.count && !this.refill()) {
                if (n < origN) break;
                return -1;
            }
            int numread = (int)Math.min((long)(this.count - this.pos), n);
            this.pos += numread;
            n -= (long)numread;
            if (this.markpos < 0 || this.pos - this.markpos <= this.marklimit) continue;
            this.markpos = -1;
        }
        return origN - n;
    }

    boolean refill() throws IOException {
        if (this.markpos < 0) {
            this.pos = 0;
            this.count = 0;
        } else if (this.markpos > 0) {
            System.arraycopy(this.buf, this.markpos, this.buf, 0, this.count - this.markpos);
            this.count -= this.markpos;
            this.pos -= this.markpos;
            this.markpos = 0;
        } else if (this.marklimit >= this.buf.length) {
            byte[] newbuf = new byte[this.marklimit + 1];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        int numread = super.read(this.buf, this.count, this.buf.length - this.count);
        if (numread < 0) {
            return false;
        }
        this.count += numread;
        return true;
    }
}

