/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropTargetDragEvent
extends DropTargetEvent {
    private static final long serialVersionUID = -8422265619058953682L;
    private Point location;
    private int actions;
    private int dropAction;

    public DropTargetDragEvent(DropTargetContext dropTargetContext, Point point, int n2, int n3) {
        super(dropTargetContext);
        if (point == null) {
            throw new NullPointerException("cursorLocn");
        }
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 0x40000000) {
            throw new IllegalArgumentException("dropAction" + n2);
        }
        if ((n3 & 0xBFFFFFFC) != 0) {
            throw new IllegalArgumentException("srcActions");
        }
        this.location = point;
        this.actions = n3;
        this.dropAction = n2;
    }

    public Point getLocation() {
        return this.location;
    }

    public DataFlavor[] getCurrentDataFlavors() {
        return this.getDropTargetContext().getCurrentDataFlavors();
    }

    public List<DataFlavor> getCurrentDataFlavorsAsList() {
        return this.getDropTargetContext().getCurrentDataFlavorsAsList();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getDropTargetContext().isDataFlavorSupported(dataFlavor);
    }

    public int getSourceActions() {
        return this.actions;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public Transferable getTransferable() {
        return this.getDropTargetContext().getTransferable();
    }

    public void acceptDrag(int n2) {
        this.getDropTargetContext().acceptDrag(n2);
    }

    public void rejectDrag() {
        this.getDropTargetContext().rejectDrag();
    }
}

