/*  aKode: StreamDecoder parent-type

    Copyright (C) 2004 Allan Sandfeld Jensen <kde@carewolf.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef _AKODE_STREAMDECODER_H
#define _AKODE_STREAMDECODER_H

#include "decoder.h"

namespace aKode {

class AudioBuffer;

//! A generic interface for stream-based decoders

/*!
 * StreamDecoder's are the second of the two decoder types in aKodeLib.
 * They work by forking a thread that decodes an entire stream into
 * a synchronised buffer.
 */
class StreamDecoder : public Decoder
{
public:
    /*!
     * Starts a decoding-thread that decodes into the \a buffer.
     * Returns immediately.
     */
    virtual void readStream(AudioBuffer* buffer) = 0;
    /*!
     * Halts decoding and terminates the decoding-thread.
     */
    virtual void halt() = 0;
};

} // namespace

#endif
