/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "base/temp-buf.h"
#include "core/gimp.h"
#include "core/gimpbrush.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "core/gimplist.h"

static ProcRecord brush_new_proc;
static ProcRecord brush_duplicate_proc;
static ProcRecord brush_rename_proc;
static ProcRecord brush_delete_proc;
static ProcRecord brush_get_info_proc;
static ProcRecord brush_get_pixels_proc;
static ProcRecord brush_get_spacing_proc;
static ProcRecord brush_set_spacing_proc;

void
register_brush_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &brush_new_proc);
  procedural_db_register (gimp, &brush_duplicate_proc);
  procedural_db_register (gimp, &brush_rename_proc);
  procedural_db_register (gimp, &brush_delete_proc);
  procedural_db_register (gimp, &brush_get_info_proc);
  procedural_db_register (gimp, &brush_get_pixels_proc);
  procedural_db_register (gimp, &brush_get_spacing_proc);
  procedural_db_register (gimp, &brush_set_spacing_proc);
}

static Argument *
brush_new_invoker (Gimp         *gimp,
                   GimpContext  *context,
                   GimpProgress *progress,
                   Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpData *data = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (strlen (name))
        data = gimp_data_factory_data_new (gimp->brush_factory, name);

      success = (data != NULL);
    }

  return_args = procedural_db_return_args (&brush_new_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (data)->name);

  return return_args;
}

static ProcArg brush_new_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The requested name of the new brush"
  }
};

static ProcArg brush_new_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The actual new brush name"
  }
};

static ProcRecord brush_new_proc =
{
  "gimp_brush_new",
  "Creates a new brush",
  "This procedure creates a new, uninitialized brush",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_new_inargs,
  1,
  brush_new_outargs,
  { { brush_new_invoker } }
};

static Argument *
brush_duplicate_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;
  GimpBrush *brush_copy = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        {
          brush_copy = (GimpBrush *)
            gimp_data_factory_data_duplicate (gimp->brush_factory,
                                              GIMP_DATA (brush));

          success = (brush_copy != NULL);
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_duplicate_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (brush_copy)->name);

  return return_args;
}

static ProcArg brush_duplicate_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_duplicate_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The name of the brush's copy"
  }
};

static ProcRecord brush_duplicate_proc =
{
  "gimp_brush_duplicate",
  "Duplicates a brush",
  "This procedure creates an identical brush by a different name",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_duplicate_inargs,
  1,
  brush_duplicate_outargs,
  { { brush_duplicate_invoker } }
};

static Argument *
brush_rename_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gchar *new_name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  new_name = (gchar *) args[1].value.pdb_pointer;
  if (new_name == NULL || !g_utf8_validate (new_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable)
        gimp_object_set_name (GIMP_OBJECT (brush), new_name);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_rename_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (brush)->name);

  return return_args;
}

static ProcArg brush_rename_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_STRING,
    "new_name",
    "The new name of the brush"
  }
};

static ProcArg brush_rename_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The actual new name of the brush"
  }
};

static ProcRecord brush_rename_proc =
{
  "gimp_brush_rename",
  "Rename a brush",
  "This procedure renames a brush",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_rename_inargs,
  1,
  brush_rename_outargs,
  { { brush_rename_invoker } }
};

static Argument *
brush_delete_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->deletable)
        {
          GError *error = NULL;

          success = gimp_data_factory_data_delete (gimp->brush_factory,
                                                   GIMP_DATA (brush),
                                                   TRUE, &error);

          if (! success)
            {
              g_message (error->message);
              g_clear_error (&error);
            }
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&brush_delete_proc, success);
}

static ProcArg brush_delete_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcRecord brush_delete_proc =
{
  "gimp_brush_delete",
  "Deletes a brush",
  "This procedure deletes a brush",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_delete_inargs,
  0,
  NULL,
  { { brush_delete_invoker } }
};

static Argument *
brush_get_info_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL);
    }

  return_args = procedural_db_return_args (&brush_get_info_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = brush->mask->width;
      return_args[2].value.pdb_int = brush->mask->height;
      return_args[3].value.pdb_int = brush->mask->bytes;
      return_args[4].value.pdb_int = brush->pixmap ? brush->pixmap->bytes : 0;
    }

  return return_args;
}

static ProcArg brush_get_info_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_info_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The brush width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The brush height"
  },
  {
    GIMP_PDB_INT32,
    "mask_bpp",
    "The brush mask bpp"
  },
  {
    GIMP_PDB_INT32,
    "color_bpp",
    "The brush color bpp"
  }
};

static ProcRecord brush_get_info_proc =
{
  "gimp_brush_get_info",
  "Retrieve information about the specified brush.",
  "This procedure retrieves information about the specified brush. This includes the brush name, and the brush extents (width and height).",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_info_inargs,
  4,
  brush_get_info_outargs,
  { { brush_get_info_invoker } }
};

static Argument *
brush_get_pixels_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 mask_bpp = 0;
  gint32 num_mask_bytes = 0;
  guint8 *mask_bytes = NULL;
  gint32 color_bpp = 0;
  gint32 num_color_bytes = 0;
  guint8 *color_bytes = NULL;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        {
          mask_bpp       = brush->mask->bytes;
          num_mask_bytes = brush->mask->height * brush->mask->width;
          mask_bytes     = g_memdup (temp_buf_data (brush->mask), num_mask_bytes);

          if (brush->pixmap)
            {
              color_bpp       = brush->pixmap->bytes;
              num_color_bytes = brush->pixmap->height * brush->pixmap->width;
              color_bytes     = g_memdup (temp_buf_data (brush->pixmap),
                                          num_color_bytes);
            }
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_get_pixels_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = brush->mask->width;
      return_args[2].value.pdb_int = brush->mask->height;
      return_args[3].value.pdb_int = mask_bpp;
      return_args[4].value.pdb_int = num_mask_bytes;
      return_args[5].value.pdb_pointer = mask_bytes;
      return_args[6].value.pdb_int = color_bpp;
      return_args[7].value.pdb_int = num_color_bytes;
      return_args[8].value.pdb_pointer = color_bytes;
    }

  return return_args;
}

static ProcArg brush_get_pixels_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_pixels_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The brush width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The brush height"
  },
  {
    GIMP_PDB_INT32,
    "mask_bpp",
    "The brush mask bpp"
  },
  {
    GIMP_PDB_INT32,
    "num_mask_bytes",
    "Length of brush mask data"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "mask_bytes",
    "The brush mask data"
  },
  {
    GIMP_PDB_INT32,
    "color_bpp",
    "The brush color bpp"
  },
  {
    GIMP_PDB_INT32,
    "num_color_bytes",
    "Length of brush color data"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "color_bytes",
    "The brush color data"
  }
};

static ProcRecord brush_get_pixels_proc =
{
  "gimp_brush_get_pixels",
  "Retrieve information about the specified brush.",
  "This procedure retrieves information about the specified brush. This includes the brush extents (width and height) and its pixels data.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_pixels_inargs,
  8,
  brush_get_pixels_outargs,
  { { brush_get_pixels_invoker } }
};

static Argument *
brush_get_spacing_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL);
    }

  return_args = procedural_db_return_args (&brush_get_spacing_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_brush_get_spacing (brush);

  return return_args;
}

static ProcArg brush_get_spacing_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_spacing_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "spacing",
    "The brush spacing: 0 <= spacing <= 1000"
  }
};

static ProcRecord brush_get_spacing_proc =
{
  "gimp_brush_get_spacing",
  "Get the brush spacing.",
  "This procedure returns the spacing setting for the specified brush. The return value is an integer between 0 and 1000 which represents percentage of the maximum of the width and height of the mask.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_spacing_inargs,
  1,
  brush_get_spacing_outargs,
  { { brush_get_spacing_invoker } }
};

static Argument *
brush_set_spacing_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 spacing;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  spacing = args[1].value.pdb_int;
  if (spacing < 0 || spacing > 1000)
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable)
        gimp_brush_set_spacing (brush, spacing);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&brush_set_spacing_proc, success);
}

static ProcArg brush_set_spacing_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_INT32,
    "spacing",
    "The brush spacing: 0 <= spacing <= 1000"
  }
};

static ProcRecord brush_set_spacing_proc =
{
  "gimp_brush_set_spacing",
  "Set the brush spacing.",
  "This procedure modifies the spacing setting for the specified brush. The value should be a integer between 0 and 1000.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_spacing_inargs,
  0,
  NULL,
  { { brush_set_spacing_invoker } }
};
