/* $Id: seekgraph.h,v 1.9 2003/01/02 13:14:42 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef SEEKGRAPH_H
#define SEEKGRAPH_H

#include "stl.h"
#include "eboard.h"
#include "widgetproxy.h"
#include "notebook.h"

class SeekAd {
 public:
  SeekAd();

  int operator==(int v);
  const char **getListLine();

  int id;
  
  int  clock;
  int  incr;
  bool rated;
  bool automatic;
  bool formula;

  string color;
  string rating;
  string player;
  string range;
  string kind;
  string flags;

};

class SeekGraph : public WidgetProxy,
		  public NotebookInsider
{
 public:
  SeekGraph();
  virtual ~SeekGraph() {}

  void remove(int id);
  void add(SeekAd *ad);
  void clear();
  void updateFont();

 private:
  GtkWidget *clist,*playbutton;
  int Count;
  int Selected;
  int SortCol, SortDirection;

  friend void skg_select  (GtkCList *cl, gint row, gint column, GdkEventButton *eb, gpointer data);
  friend void skg_unselect(GtkCList *cl, gint row, gint column, GdkEventButton *eb, gpointer data);
  friend void skg_play(GtkWidget *w, gpointer data);
  friend void skg_chgsort(GtkCList *cl, gint column, gpointer data);

};

#endif
