/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.net.ssl.SSLException;

final class CipherSuiteList {
    private static CipherSuiteList supportedSuites;
    private static CipherSuiteList defaultSuites;
    private final Collection cipherSuites;
    private String[] suiteNames;

    private CipherSuiteList(Collection collection) {
        this.cipherSuites = collection;
    }

    CipherSuiteList(CipherSuite cipherSuite) {
        this.cipherSuites = new ArrayList(1);
        this.cipherSuites.add(cipherSuite);
    }

    CipherSuiteList(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("CipherSuites may not be null");
        }
        this.cipherSuites = new ArrayList(stringArray.length);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CipherSuite cipherSuite = CipherSuite.valueOf(string);
            if (!cipherSuite.isAvailable()) {
                if (!bl) {
                    CipherSuiteList.clearAvailableCache();
                    bl = true;
                }
                if (!cipherSuite.isAvailable()) {
                    throw new IllegalArgumentException("Cannot support " + string + " with currently installed providers");
                }
            }
            this.cipherSuites.add(cipherSuite);
        }
    }

    CipherSuiteList(HandshakeInStream handshakeInStream) throws IOException {
        byte[] byArray = handshakeInStream.getBytes16();
        if ((byArray.length & 1) != 0) {
            throw new SSLException("Invalid ClientHello message");
        }
        this.cipherSuites = new ArrayList(byArray.length >> 1);
        for (int i = 0; i < byArray.length; i += 2) {
            this.cipherSuites.add(CipherSuite.valueOf(byArray[i], byArray[i + 1]));
        }
    }

    boolean contains(CipherSuite cipherSuite) {
        return this.cipherSuites.contains(cipherSuite);
    }

    Iterator iterator() {
        return this.cipherSuites.iterator();
    }

    int size() {
        return this.cipherSuites.size();
    }

    synchronized String[] toStringArray() {
        if (this.suiteNames == null) {
            this.suiteNames = new String[this.cipherSuites.size()];
            Iterator iterator = this.cipherSuites.iterator();
            for (int i = 0; i < this.suiteNames.length; ++i) {
                CipherSuite cipherSuite = (CipherSuite)iterator.next();
                this.suiteNames[i] = cipherSuite.name;
            }
        }
        return (String[])this.suiteNames.clone();
    }

    public String toString() {
        return this.cipherSuites.toString();
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        byte[] byArray = new byte[this.cipherSuites.size() * 2];
        int n = 0;
        for (CipherSuite cipherSuite : this.cipherSuites) {
            byArray[n] = (byte)(cipherSuite.id >> 8);
            byArray[n + 1] = (byte)cipherSuite.id;
            n += 2;
        }
        handshakeOutStream.putBytes16(byArray);
    }

    static synchronized void clearAvailableCache() {
    }

    private static CipherSuiteList buildAvailableCache(int n) {
        TreeSet<CipherSuite> treeSet = new TreeSet<CipherSuite>();
        Collection collection = CipherSuite.allowedCipherSuites();
        for (CipherSuite cipherSuite : collection) {
            if (!cipherSuite.allowed || cipherSuite.priority < n || !cipherSuite.isAvailable()) continue;
            treeSet.add(cipherSuite);
        }
        return new CipherSuiteList(treeSet);
    }

    static synchronized CipherSuiteList getSupported() {
        if (supportedSuites == null) {
            supportedSuites = CipherSuiteList.buildAvailableCache(1);
        }
        return supportedSuites;
    }

    static synchronized CipherSuiteList getDefault() {
        if (defaultSuites == null) {
            defaultSuites = CipherSuiteList.buildAvailableCache(300);
        }
        return defaultSuites;
    }
}

