/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.memory.CompactibleSpace;
import sun.jvm.hotspot.memory.FreeChunk;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class CompactibleFreeListSpace
extends CompactibleSpace {
    private static long MinChunkSizeInBytes;
    static /* synthetic */ Class class$sun$jvm$hotspot$memory$FreeChunk;

    private static synchronized void initialize(TypeDataBase db) {
        long sizeofFreeChunk = db.lookupType("FreeChunk").getSize();
        VM vm = VM.getVM();
        MinChunkSizeInBytes = CompactibleFreeListSpace.numQuanta(sizeofFreeChunk, vm.getMinObjAlignmentInBytes()) * (long)vm.getMinObjAlignmentInBytes();
    }

    public CompactibleFreeListSpace(Address addr) {
        super(addr);
    }

    public long used() {
        List regions = this.getLiveRegions();
        long usedSize = 0L;
        Iterator itr = regions.iterator();
        while (itr.hasNext()) {
            MemRegion mr = (MemRegion)itr.next();
            usedSize += mr.byteSize();
        }
        return usedSize;
    }

    public long free() {
        return this.capacity() - this.used();
    }

    public void printOn(PrintStream tty) {
        tty.print("free-list-space");
    }

    public List getLiveRegions() {
        Address cur;
        ArrayList<MemRegion> res = new ArrayList<MemRegion>();
        VM vm = VM.getVM();
        JVMDebugger dbg = vm.getDebugger();
        ObjectHeap heap = vm.getObjectHeap();
        Address regionStart = cur = this.bottom();
        Address limit = this.end();
        long addressSize = vm.getAddressSize();
        while (cur.lessThan(limit)) {
            Address klassOop = cur.getAddressAt(addressSize);
            if (klassOop == null) {
                System.err.println("WARNING: null klass encountered, may miss objects in CMS space!");
                return res;
            }
            if (FreeChunk.secondWordIndicatesFreeChunk(dbg.getAddressValue(klassOop))) {
                if (!((Object)cur).equals(regionStart)) {
                    res.add(new MemRegion(regionStart, cur));
                }
                FreeChunk fc = (FreeChunk)VMObjectFactory.newObject(class$sun$jvm$hotspot$memory$FreeChunk == null ? CompactibleFreeListSpace.class$("sun.jvm.hotspot.memory.FreeChunk") : class$sun$jvm$hotspot$memory$FreeChunk, cur);
                long chunkSize = fc.size();
                Assert.that(chunkSize > 0L, "invalid FreeChunk size");
                regionStart = cur = cur.addOffsetTo(chunkSize * addressSize);
                continue;
            }
            if (klassOop == null) continue;
            Oop obj = heap.newOop(cur.addOffsetToAsOopHandle(0L));
            long objectSize = obj.getObjectSize();
            cur = cur.addOffsetTo(CompactibleFreeListSpace.adjustObjectSizeInBytes(objectSize));
        }
        return res;
    }

    private static long numQuanta(long x, long y) {
        return (x + y - 1L) / y;
    }

    private static long adjustObjectSizeInBytes(long sizeInBytes) {
        return Oop.alignObjectSize(Math.max(sizeInBytes, MinChunkSizeInBytes));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CompactibleFreeListSpace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

