/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.IndexableFieldIdentifier;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class Symbol
extends Oop {
    private static long baseOffset;
    private static CIntField length;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("symbolOopDesc");
        length = new CIntField(type.getCIntegerField("_length"), 0L);
        baseOffset = type.getField("_body").getOffset();
    }

    Symbol(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public boolean isSymbol() {
        return true;
    }

    public long getLength() {
        return length.getValue(this);
    }

    public byte getByteAt(long index) {
        return this.getHandle().getJByteAt(baseOffset + index);
    }

    public boolean equals(byte[] modUTF8Chars) {
        int l = (int)this.getLength();
        if (l != modUTF8Chars.length) {
            return false;
        }
        while (l-- > 0) {
            if (modUTF8Chars[l] == this.getByteAt(l)) continue;
            return false;
        }
        Assert.that(l == -1, "we should be at the beginning");
        return true;
    }

    public byte[] asByteArray() {
        int length = (int)this.getLength();
        byte[] result = new byte[length];
        for (int index = 0; index < length; ++index) {
            result[index] = this.getByteAt(index);
        }
        return result;
    }

    public String asString() {
        try {
            return Symbol.readModifiedUTF8(this.asByteArray());
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean startsWith(String str) {
        return this.asString().startsWith(str);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("#" + this.asString());
    }

    public long getObjectSize() {
        return Symbol.alignObjectSize(baseOffset + this.getLength());
    }

    void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doCInt(length, true);
            int length = (int)this.getLength();
            for (int index = 0; index < length; ++index) {
                visitor.doByte(new ByteField(new IndexableFieldIdentifier(index), baseOffset + (long)index, false), true);
            }
        }
    }

    public int fastCompare(Symbol other) {
        return (int)this.getHandle().minus(other.getHandle());
    }

    private static String readModifiedUTF8(byte[] buf) throws IOException {
        int len = buf.length;
        byte[] tmp = new byte[len + 2];
        tmp[0] = (byte)(len >>> 8 & 0xFF);
        tmp[1] = (byte)(len >>> 0 & 0xFF);
        System.arraycopy(buf, 0, tmp, 2, len);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tmp));
        return dis.readUTF();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Symbol.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

