/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.Trie;

public class IntTrie
extends Trie {
    private int m_initialValue_;
    private int[] m_data_;

    public IntTrie(InputStream inputStream, Trie.DataManipulate dataManipulate) throws IOException {
        super(inputStream, dataManipulate);
        if (!this.isIntTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a int trie.");
        }
    }

    public final int getCodePointValue(int n) {
        int n2 = this.getCodePointOffset(n);
        return n2 >= 0 ? this.m_data_[n2] : this.m_initialValue_;
    }

    public final int getLeadValue(char c) {
        return this.m_data_[this.getLeadOffset(c)];
    }

    public final int getBMPValue(char c) {
        return this.m_data_[this.getBMPOffset(c)];
    }

    public final int getSurrogateValue(char c, char c2) {
        if (!Character.isHighSurrogate(c) || !Character.isLowSurrogate(c2)) {
            throw new IllegalArgumentException("Argument characters do not form a supplementary character");
        }
        int n = this.getSurrogateOffset(c, c2);
        if (n > 0) {
            return this.m_data_[n];
        }
        return this.m_initialValue_;
    }

    public final int getTrailValue(int n, char c) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n2 = this.m_dataManipulate_.getFoldingOffset(n);
        if (n2 > 0) {
            return this.m_data_[this.getRawOffset(n2, (char)(c & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    public final int getLatin1LinearValue(char c) {
        return this.m_data_[32 + c];
    }

    protected final void unserialize(InputStream inputStream) throws IOException {
        super.unserialize(inputStream);
        this.m_data_ = new int[this.m_dataLength_];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[this.m_dataLength_ * 4];
        dataInputStream.read(byArray);
        int n = 0;
        for (int i = 0; i < this.m_dataLength_; ++i) {
            this.m_data_[i] = byArray[n++] << 24 & 0xFF000000 | byArray[n++] << 16 & 0xFF0000 | byArray[n++] << 8 & 0xFF00 | byArray[n++] & 0xFF;
        }
        this.m_initialValue_ = this.m_data_[0];
    }

    protected final int getSurrogateOffset(char c, char c2) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(c));
        if (n > 0) {
            return this.getRawOffset(n, (char)(c2 & 0x3FF));
        }
        return -1;
    }

    protected final int getValue(int n) {
        return this.m_data_[n];
    }

    protected final int getInitialValue() {
        return this.m_initialValue_;
    }

    IntTrie(char[] cArray, int[] nArray, int n, int n2, Trie.DataManipulate dataManipulate) {
        super(cArray, n2, dataManipulate);
        this.m_index_ = cArray;
        this.m_data_ = nArray;
        this.m_dataLength_ = this.m_data_.length;
        this.m_initialValue_ = n;
    }
}

