#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/hotplug/blacklist.new
config etc/hotplug/usb.usermap.new
config etc/rc.d/rc.hotplug.new

# So far, this is an empty file.  Remove it if it remains.
rm -f etc/hotplug/usb.usermap.new
